/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPaletteHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DataStreamSupporter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifHeader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.IGifBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifFrameBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifPlainTextRenderingBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.internal.ImageCorrection;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class GifImage
extends RasterImage {
    private final GifHeader a;
    private final List<IGifBlock> b = new List();
    private GifFrameBlock c;
    private boolean d;

    public GifImage(GifFrameBlock gifFrameBlock, IColorPalette iColorPalette) {
        this(gifFrameBlock, iColorPalette, false, 0, 0, 0, true);
    }

    public GifImage(GifFrameBlock gifFrameBlock) {
        this(gifFrameBlock, null);
    }

    public GifImage(GifFrameBlock gifFrameBlock, IColorPalette iColorPalette, boolean bl2, byte by2, byte by3, byte by4, boolean bl3) {
        byte by5;
        int n2;
        if (gifFrameBlock == null) {
            throw new ArgumentNullException("firstFrame");
        }
        if (gifFrameBlock.getContainer() != null) {
            throw new ArgumentException("The first frame already belongs to some other image. Check the Container property.", "firstFrame");
        }
        IColorPalette iColorPalette2 = gifFrameBlock.getPalette();
        int n3 = 0;
        if (iColorPalette != null) {
            n3 = n2 = iColorPalette.getEntriesCount();
            by5 = GifHeader.generateFlags(n2, true, bl2, by2);
        } else if (iColorPalette2 == null) {
            iColorPalette2 = ColorPaletteHelper.create8Bit();
            n2 = iColorPalette2.getEntriesCount();
            by5 = GifHeader.generateFlags(n2, true, false, (byte)0);
            n3 = n2;
            iColorPalette = iColorPalette2;
        } else {
            by5 = GifHeader.generateFlags(0, false, false, (byte)0);
        }
        GifHeader gifHeader = new GifHeader(Operators.castToUInt16(gifFrameBlock.getWidth(), 9), Operators.castToUInt16(gifFrameBlock.getHeight(), 9), by5, by3, by4);
        if (gifHeader.getPaletteSize() != n3 && n3 > 0) {
            throw new GifImageException("The palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        this.a = gifHeader;
        this.b.addItem(gifFrameBlock);
        gifFrameBlock.setContainer(this);
        this.c = gifFrameBlock;
        this.d = bl3;
        this.setPalette(iColorPalette);
        this.setDataLoader(new GifImageActiveFrameLoader(this));
    }

    public GifImage(GifHeader gifHeader, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock) {
        super(iColorPalette);
        this.a = gifHeader;
        for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
            IGifBlock iGifBlock = iGifBlockArray[i2];
            Image image = Operators.as(iGifBlock, Image.class);
            if (image == null) continue;
            image.setContainer(this);
        }
        this.b.addRange(Array.toGenericList(iGifBlockArray));
        this.d = bl2;
        this.c = gifFrameBlock;
        this.setDataLoader(new GifImageActiveFrameLoader(this));
    }

    public boolean hasTrailer() {
        return this.d;
    }

    public void setTrailer(boolean bl2) {
        this.d = bl2;
    }

    public boolean isPaletteSorted() {
        return this.a.isSorted();
    }

    public void setPaletteSorted(boolean bl2) {
        this.a.setSorted(bl2);
    }

    public byte getPaletteColorResolutionBits() {
        return this.a.getColorResolution();
    }

    public void setPaletteColorResolutionBits(byte by2) {
        this.a.setColorResolution(by2);
    }

    @Override
    public int getWidth() {
        return Operators.castToInt32(this.a.getWidth(), 8);
    }

    @Override
    public int getHeight() {
        return Operators.castToInt32(this.a.getHeight(), 8);
    }

    @Override
    public int getBitsPerPixel() {
        int n2 = 0;
        if (this.c != null) {
            n2 = this.c.getBitsPerPixel();
        }
        return n2;
    }

    public IGifBlock[] getBlocks() {
        return this.b.toArray((IGifBlock[])new IGifBlock[0]);
    }

    public GifFrameBlock getActiveFrame() {
        return this.c;
    }

    public void setActiveFrame(GifFrameBlock gifFrameBlock) {
        if (gifFrameBlock != null && (gifFrameBlock.getContainer() == null || gifFrameBlock.getContainer() != this)) {
            throw new GifImageException("The frame does not belong to the current GIF image.");
        }
        this.c = gifFrameBlock;
    }

    @Override
    public int getBackgroundColor() {
        int n2 = 0;
        if (this.getPalette() != null && Operators.castToInt32(this.a.getBackgroundColorIndex(), 6) < this.getPalette().getEntriesCount()) {
            n2 = this.getPalette().getArgb32Color(Operators.castToInt32(this.a.getBackgroundColorIndex(), 6));
        }
        return n2;
    }

    @Override
    public void setBackgroundColor(int n2) {
        if (this.getPalette() != null) {
            this.a.setBackgroundColorIndex(Operators.castToByte(this.getPalette().getNearestColorIndex(n2), 9));
        }
    }

    public byte getBackgroundColorIndex() {
        return this.a.getBackgroundColorIndex();
    }

    public void setBackgroundColorIndex(byte by2) {
        this.a.setBackgroundColorIndex(by2);
    }

    public byte getPixelAspectRatio() {
        return this.a.getPixelAspectRatio();
    }

    public void setPixelAspectRatio(byte by2) {
        this.a.setPixelAspectRatio(by2);
    }

    @Override
    public final boolean isCached() {
        IGifBlock[] iGifBlockArray = this.getBlocks();
        boolean bl2 = true;
        for (int i2 = 0; i2 < iGifBlockArray.length && (!Operators.is(iGifBlockArray[i2], DataStreamSupporter.class) || (bl2 = Operators.as(iGifBlockArray[i2], DataStreamSupporter.class).isCached())); ++i2) {
        }
        return bl2;
    }

    @Override
    public boolean hasTransparentColor() {
        return this.c.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        this.c.setTransparentColor(bl2);
    }

    @Override
    public int getTransparentColor() {
        return this.c.getTransparentColor();
    }

    @Override
    public boolean hasBackgroundColor() {
        return this.getBackgroundColor() != 0;
    }

    @Override
    public final void cacheData() {
        IGifBlock[] iGifBlockArray = this.getBlocks();
        for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
            if (!Operators.is(iGifBlockArray[i2], DataStreamSupporter.class)) continue;
            Operators.as(iGifBlockArray[i2], DataStreamSupporter.class).cacheData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateFlipAll(int n2) {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                if (!Operators.is(iGifBlock, GifFrameBlock.class)) continue;
                Operators.as(iGifBlock, GifFrameBlock.class).rotateFlip(n2);
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.a.setWidth(Operators.castToUInt16(this.c.getWidth(), 9));
        this.a.setHeight(Operators.castToUInt16(this.c.getHeight(), 9));
    }

    public void orderBlocks() {
        Object object;
        int n2;
        this.verifyNotDisposed();
        List list = new List();
        for (n2 = 0; n2 < this.b.size(); ++n2) {
            int n3;
            IGifBlock iGifBlock = this.b.get_Item(n2);
            if (!Operators.is(iGifBlock, GifGraphicsControlBlock.class)) continue;
            object = new List();
            for (n3 = n2 + 1; n3 < this.b.size(); ++n3) {
                IGifBlock iGifBlock2 = this.b.get_Item(n3);
                if (Operators.is(iGifBlock2, GifGraphicsControlBlock.class)) {
                    ((List)object).addItem(n3);
                    continue;
                }
                if (!Operators.is(iGifBlock2, GifFrameBlock.class) && !Operators.is(iGifBlock2, GifPlainTextRenderingBlock.class)) continue;
                list.addRange(object);
                n2 = n3;
                break;
            }
            if (n3 == this.b.size()) break;
        }
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            int n4 = (Integer)list.get_Item(n2);
            object = Operators.as(this.b.get_Item(n4), Image.class);
            if (object != null) {
                ((Image)object).setContainer(null);
            }
            this.b.removeAt(n4);
        }
    }

    public void clearBlocks() {
        this.verifyNotDisposed();
        this.b.clear();
        this.c = null;
    }

    public void insertBlock(int n2, IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = Operators.as(iGifBlock, Image.class);
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this GIF image.");
        }
        this.b.insertItem(n2, iGifBlock);
        if (image != null) {
            image.setContainer(this);
        }
    }

    public void addBlock(IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = Operators.as(iGifBlock, Image.class);
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be added to this GIF image.");
        }
        this.b.addItem(iGifBlock);
        if (image != null) {
            image.setContainer(this);
        }
    }

    public void removeBlock(IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = Operators.as(iGifBlock, Image.class);
        if (image != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.b.removeItem(iGifBlock);
        if (image != null) {
            image.setContainer(null);
        }
        if (this.c == iGifBlock) {
            this.c = null;
        }
    }

    @Override
    public void rotateFlip(int n2) {
        this.verifyNotDisposed();
        this.c.rotateFlip(n2);
        this.a.setWidth(Operators.castToUInt16(this.c.getWidth(), 9));
        this.a.setHeight(Operators.castToUInt16(this.c.getHeight(), 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("newWidth", "The new width should be positive number and at least 1.");
        }
        if (n3 <= 0) {
            throw new ArgumentOutOfRangeException("newHeight", "The new height should be positive number and at least 1.");
        }
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                gifFrameBlock.resize(n2, n3, n4);
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.a.setWidth(Operators.castToUInt16(n2, 9));
        this.a.setHeight(Operators.castToUInt16(n3, 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeProportional(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        double d2 = Operators.castToDouble(n2, 9) / (double)this.getWidth();
        double d3 = Operators.castToDouble(n3, 9) / (double)this.getHeight();
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                int n5 = Operators.castToInt32(d2 * (double)gifFrameBlock.getWidth() + 0.5, 14);
                int n6 = Operators.castToInt32(d3 * (double)gifFrameBlock.getHeight() + 0.5, 14);
                gifFrameBlock.resize(n5, n6, n4);
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.a.setWidth(Operators.castToUInt16(n2, 9));
        this.a.setHeight(Operators.castToUInt16(n3, 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        if (!this.getBounds().contains(rectangle.Clone())) {
            throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
        }
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    gifFrameBlock.crop(rectangle.Clone());
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't crop image. Frame index: ", Int32Extensions.toString(n2)), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.a.setWidth(Operators.castToUInt16(rectangle.getWidth(), 9));
        this.a.setHeight(Operators.castToUInt16(rectangle.getHeight(), 9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grayscale() {
        this.verifyNotDisposed();
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette().getArgb32Entries() : this.getPalette().getArgb32Entries();
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        int n3 = nArray[i2];
                        byte by2 = Operators.castToByte(0.2126 * (double)(n3 >> 16 & 0xFF) + 0.7152 * (double)(n3 >> 8 & 0xFF) + 0.0722 * (double)(n3 & 0xFF), 14);
                        nArray[i2] = n3 & 0xFF000000 | Operators.castToInt32(by2, 6) << 16 | Operators.castToInt32(by2, 6) << 8 | Operators.castToInt32(by2, 6);
                    }
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else {
                        this.setPalette(new ColorPalette(nArray));
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't make image grayscale. Frame index: ", Int32Extensions.toString(n2)), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeFixed(byte by2) {
        this.verifyNotDisposed();
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette().getArgb32Entries() : this.getPalette().getArgb32Entries();
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        int n3 = nArray[i2];
                        byte by3 = Operators.castToByte(0.2126 * (double)(n3 >> 16 & 0xFF) + 0.7152 * (double)(n3 >> 8 & 0xFF) + 0.0722 * (double)(n3 & 0xFF), 14);
                        by3 = Operators.castToInt32(by3, 6) > Operators.castToInt32(by2, 6) ? (byte)-1 : 0;
                        nArray[i2] = n3 & 0xFF000000 | Operators.castToInt32(by3, 6) << 16 | Operators.castToInt32(by3, 6) << 8 | Operators.castToInt32(by3, 6);
                    }
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else {
                        this.setPalette(new ColorPalette(nArray));
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't make image grayscale. Frame index: ", Int32Extensions.toString(n2)), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeOtsu() {
        this.verifyNotDisposed();
        int n2 = 0;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette().getArgb32Entries() : this.getPalette().getArgb32Entries();
                    byte by2 = ImageCorrection.getThresholdOtsuMethod(nArray);
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        int n3 = nArray[i2];
                        int n4 = n3 >> 24 & 0xFF;
                        int n5 = n3 >> 16 & 0xFF;
                        int n6 = n3 >> 8 & 0xFF;
                        int n7 = n3 & 0xFF;
                        byte by3 = Operators.castToByte(0.2126 * (double)n5 + 0.7152 * (double)n6 + 0.0722 * (double)n7, 14);
                        by3 = Operators.castToInt32(by3, 6) > Operators.castToInt32(by2, 6) ? (byte)-1 : 0;
                        nArray[i2] = n4 << 24 | Operators.castToInt32(by3, 6) << 16 | Operators.castToInt32(by3, 6) << 8 | Operators.castToInt32(by3, 6);
                    }
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else {
                        this.setPalette(new ColorPalette(nArray));
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't make image grayscale. Frame index: ", Int32Extensions.toString(n2)), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBrightness(int n2) {
        this.verifyNotDisposed();
        int n3 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette().getArgb32Entries() : this.getPalette().getArgb32Entries();
                    ImageCorrection.correctBrightness(nArray, n2);
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else if (!bl2) {
                        this.setPalette(new ColorPalette(nArray));
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't change brightness. Frame index: ", Int32Extensions.toString(n3)), runtimeException);
                }
                ++n3;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustContrast(float f2) {
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray;
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    int[] nArray2 = gifFrameBlock.loadArgb32Pixels(rectangle.Clone());
                    IColorPalette iColorPalette = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette() : this.getPalette();
                    int[] nArray3 = iColorPalette.getArgb32Entries();
                    ImageCorrection.correctContrast(nArray3, f2);
                    ColorPalette colorPalette = new ColorPalette(nArray3);
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        gifFrameBlock.saveArgb32Pixels(rectangle.Clone(), nArray);
                    } else if (!bl2) {
                        this.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        this.saveArgb32Pixels(rectangle.Clone(), nArray);
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't change contrast. Frame index: ", Int32Extensions.toString(n2)), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = Operators.as(iGifBlock, GifFrameBlock.class);
                if (gifFrameBlock == null) continue;
                try {
                    int[] nArray;
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    int[] nArray2 = gifFrameBlock.loadArgb32Pixels(rectangle.Clone());
                    IColorPalette iColorPalette = gifFrameBlock.getPalette() != null ? gifFrameBlock.getPalette() : this.getPalette();
                    int[] nArray3 = iColorPalette.getArgb32Entries();
                    ImageCorrection.gammaCorrection(nArray3, f2, f3, f4);
                    ColorPalette colorPalette = new ColorPalette(nArray3);
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        gifFrameBlock.saveArgb32Pixels(rectangle.Clone(), nArray);
                    } else if (!bl2) {
                        this.setPalette(colorPalette);
                        nArray = this.a(iColorPalette, colorPalette, nArray2);
                        this.saveArgb32Pixels(rectangle.Clone(), nArray);
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(StringExtensions.concat("Can't change gamma. Frame index: ", Int32Extensions.toString(n2)), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public void adjustGamma(float f2) {
        this.adjustGamma(f2, f2, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            this.a.writeHeader(streamContainer);
            if (this.getPalette() != null) {
                GifHelper.savePalette(streamContainer, this.getPalette());
            }
            IGenericEnumerator iGenericEnumerator = this.b.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                    iGifBlock.save(streamContainer.getStream());
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            if (this.d) {
                streamContainer.writeByte((byte)59);
            }
            streamContainer.setLength(streamContainer.getPosition());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void savePixelsInternal(Rectangle rectangle, int[] nArray) {
        if (this.c == null) {
            throw new GifImageException("Cannot save pixels as no active GIF frame exists. Select an active frame first.");
        }
        this.c.saveArgb32Pixels(rectangle.Clone(), nArray);
    }

    @Override
    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (iColorPalette2 != null && iColorPalette2.getEntriesCount() != 2 && iColorPalette2.getEntriesCount() != 4 && iColorPalette2.getEntriesCount() != 8 && iColorPalette2.getEntriesCount() != 16 && iColorPalette2.getEntriesCount() != 32 && iColorPalette2.getEntriesCount() != 64 && iColorPalette2.getEntriesCount() != 128 && iColorPalette2.getEntriesCount() != 256) {
            throw new GifImageException("The color palette cannot be changed as palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        super.onPaletteChanging(iColorPalette, iColorPalette2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.a.setPalette(iColorPalette2 != null);
        if (iColorPalette2 != null) {
            this.a.setPaletteSize(iColorPalette2.getEntriesCount());
        }
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseManagedResources() {
        IGenericEnumerator iGenericEnumerator = this.b.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                IDisposable iDisposable = Operators.as(iGifBlock, IDisposable.class);
                if (iDisposable == null) continue;
                iDisposable.dispose();
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.b.clear();
        this.c = null;
        super.releaseManagedResources();
    }

    private int[] a(IColorPalette iColorPalette, IColorPalette iColorPalette2, int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int[] nArray2 = new int[nArray.length];
        int n2 = -1;
        RgbEntriesPaletteHash rgbEntriesPaletteHash = new RgbEntriesPaletteHash(iColorPalette);
        for (int n3 : nArray) {
            byte by2;
            byArray[++n2] = by2 = Operators.castToByte(rgbEntriesPaletteHash.getNearestColorIndex(n3), 9);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = iColorPalette2.getArgb32Entries()[Operators.castToInt32(byArray[i2], 6)];
        }
        return nArray2;
    }

    public GifHeader getHeader() {
        return this.a;
    }

    private static class GifImageActiveFrameLoader
    implements IRasterImageArgb32PixelLoader {
        private final GifImage a;

        public GifImageActiveFrameLoader(GifImage gifImage) {
            this.a = gifImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return this.a.c.isRawDataAvailable();
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return this.a.c.getRawDataSettings();
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            if (this.a.c == null) {
                throw new GifImageException("Cannot load pixels as no active GIF frame exists. Select an active frame first.");
            }
            this.a.c.loadPartialArgb32Pixels(rectangle.Clone(), iPartialArgb32PixelLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            this.a.c.loadRawData(rectangle.Clone(), rawDataSettings, iPartialRawDataLoader);
        }
    }
}

