/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffTagsSaver {
    public static final int HeaderSize = 8;
    private static final int a = 34665;
    private static final int b = 34853;
    private final List<TiffDataType> c;

    public TiffTagsSaver(TiffDataType[] tiffDataTypeArray, TiffDataType[] tiffDataTypeArray2, TiffDataType[] tiffDataTypeArray3) {
        this.c = new List<TiffDataType>(Array.toGenericList(tiffDataTypeArray));
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            if (Operators.castToUInt16(tiffDataType.getId(), 8) != 34665 && Operators.castToUInt16(tiffDataType.getId(), 8) != 34853) continue;
            this.c.removeItem(tiffDataType);
        }
        if (tiffDataTypeArray2 != null && tiffDataTypeArray2.length > 0) {
            this.c.addItem(new TiffExifDataType(tiffDataTypeArray2, Operators.castToUInt16(34665, 9)));
        }
        if (tiffDataTypeArray3 != null && tiffDataTypeArray3.length > 0) {
            this.c.addItem(new TiffExifDataType(tiffDataTypeArray3, Operators.castToUInt16(34853, 9)));
        }
        this.c.sort();
    }

    public int getValidTagsCount() {
        return TiffOptions.getValidTagsCount(this.c.toArray((TiffDataType[])new TiffDataType[0]));
    }

    public static void writeTiffHeader(TiffStream tiffStream) {
        int n2 = 18761;
        if (Operators.is(tiffStream, TiffBigEndianStream.class)) {
            n2 = 19789;
        }
        tiffStream.writeSShort((short)n2);
        tiffStream.writeSShort((short)42);
        long l2 = Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(tiffStream.getPosition(), 11), 10) + 4L, 10);
        tiffStream.writeULong(l2);
    }

    public void replaceTags(TiffDataType[] tiffDataTypeArray) {
        block0: for (TiffDataType tiffDataType : tiffDataTypeArray) {
            for (int i2 = 0; i2 < this.c.size(); ++i2) {
                if (Operators.castToUInt16(this.c.get_Item(i2).getId(), 8) != Operators.castToUInt16(tiffDataType.getId(), 8)) continue;
                this.c.set_Item(i2, tiffDataType);
                continue block0;
            }
        }
    }

    public long estimateTagsInfoSize() {
        int n2 = this.getValidTagsCount();
        long l2 = n2 * 12 + 2;
        long l3 = l2 + 4L;
        return Operators.castToUInt32(l3, 11);
    }

    public void writeTags(TiffStream tiffStream, long l2, boolean bl2) {
        long l3 = 4L - Operators.castToUInt32(Operators.castToUInt32(l2, 10) % 4L, 10);
        if (Operators.castToUInt32(l3, 10) != 4L) {
            l2 = Operators.castToUInt32(Operators.castToUInt32(l2, 10) + Operators.castToUInt32(l3, 10), 10);
        }
        int n2 = this.getValidTagsCount();
        tiffStream.writeUShort(Operators.castToUInt16(n2, 9));
        TiffDataType[] tiffDataTypeArray = this.c.toArray((TiffDataType[])new TiffDataType[0]);
        long l4 = TiffTagsSaver.a(tiffStream, tiffDataTypeArray, l2);
        tiffStream.setFrameLastPosition(tiffStream.getPosition());
        tiffStream.writeULong(bl2 ? 0L : l4);
        tiffStream.seek(Operators.castToInt64(l2, 10), 0);
        TiffTagsSaver.a(tiffStream, tiffDataTypeArray);
    }

    private static long a(TiffStream tiffStream, TiffDataType[] tiffDataTypeArray, long l2) {
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            if (tiffDataType == null || !tiffDataType.isValid() || Operators.is(tiffDataType, TiffUnknownType.class)) continue;
            tiffDataType.writeTag(tiffStream, l2);
            l2 = Operators.castToUInt32(Operators.castToUInt32(l2, 10) + Operators.castToUInt32(tiffDataType.getAlignedDataSize(), 10), 10);
        }
        return l2;
    }

    private static void a(TiffStream tiffStream, TiffDataType[] tiffDataTypeArray) {
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            long l2;
            long l3;
            if (tiffDataType == null || !tiffDataType.isValid() || Operators.is(tiffDataType, TiffUnknownType.class) || Operators.castToUInt32(l3 = 4L - Operators.castToUInt32(Operators.castToUInt32(l2 = tiffDataType.writeAdditionalData(tiffStream), 10) % 4L, 10), 10) == 4L) continue;
            tiffStream.write(new byte[(int)Operators.castToUInt32(l3, 10)]);
        }
    }

    private static class TiffExifDataType
    extends TiffDataType {
        private final TiffDataType[] a;
        private final long b;

        public TiffExifDataType(TiffDataType[] tiffDataTypeArray, int n2) {
            super(n2);
            this.a = tiffDataTypeArray;
            long l2 = Operators.castToUInt32(12, 9) * Operators.castToUInt32(Operators.castToUInt32(this.a.length, 9), 10);
            for (TiffDataType tiffDataType : this.a) {
                l2 = Operators.castToUInt32(Operators.castToUInt32(l2, 10) + Operators.castToUInt32(tiffDataType.getAlignedDataSize(), 10), 10);
            }
            if (Operators.castToUInt32(l2, 10) > 0L) {
                l2 = Operators.castToUInt32(Operators.castToUInt32(l2, 10) + 4L, 10);
            }
            this.b = l2;
        }

        @Override
        public long getCount() {
            return 1L;
        }

        @Override
        public int getTagType() {
            return 4;
        }

        @Override
        public long getDataSize() {
            return this.b;
        }

        @Override
        public Object getValue() {
            throw new NotImplementedException();
        }

        @Override
        public void setValue(Object object) {
            throw new NotImplementedException();
        }

        @Override
        public long writeAdditionalData(TiffStream tiffStream) {
            tiffStream.writeUShort(Operators.castToUInt16(this.a.length, 9));
            long l2 = Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(tiffStream.getPosition(), 11), 10) + Operators.castToUInt32(Operators.castToUInt32(12, 9) * Operators.castToUInt32(Operators.castToUInt32(this.a.length, 9), 10), 10), 10) + 2L, 10);
            TiffTagsSaver.a(tiffStream, this.a, l2);
            tiffStream.writeSShort((short)0);
            TiffTagsSaver.a(tiffStream, this.a);
            long l3 = this.getAlignedDataSize();
            long l4 = Operators.castToUInt32(Operators.castToUInt32(l3, 10) - Operators.castToUInt32(this.b, 10), 10);
            if (Operators.castToUInt32(l4, 10) > 0L) {
                tiffStream.write(new byte[(int)Operators.castToUInt32(l4, 10)]);
            }
            return l3;
        }

        @Override
        protected void readData(TiffStream tiffStream, long l2) {
            throw new NotImplementedException();
        }

        @Override
        protected void writeTagValueOrOffset(TiffStream tiffStream, long l2) {
            tiffStream.writeULong(l2);
        }

        @Override
        protected TiffDataType createInstance() {
            throw new NotImplementedException();
        }
    }
}

