/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.UInt32Extensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffSRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.consts.TiffConsts;

public class TiffStream
extends StreamContainer {
    private boolean a = true;
    private long b = 0L;

    public TiffStream(Stream stream) {
        super(stream);
    }

    public TiffStream(Stream stream, boolean bl2) {
        super(stream, bl2);
    }

    public boolean getThrowExceptions() {
        return this.a;
    }

    public void setThrowExceptions(boolean bl2) {
        this.a = bl2;
    }

    public byte[] readUByteArrayUInt32(long l2) {
        byte[] byArray = new byte[(int)(l2 & 0xFFFFFFFFL)];
        int n2 = this.read(byArray);
        if ((long)n2 != (l2 & 0xFFFFFFFFL)) {
            if (this.a) {
                throw new IllegalStateException(StringExtensions.concat("FrameworkException: Cannot read ", UInt32Extensions.toString(l2), " bytes from stream."));
            }
            byArray = null;
        }
        return byArray;
    }

    public byte[] readUByteArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive count value.");
        }
        return this.readUByteArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public double readDouble() {
        double[] dArray = this.readDoubleArrayInt32(1);
        double d2 = 0.0;
        if (dArray != null && dArray.length == 1) {
            d2 = dArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read double value.");
        }
        return d2;
    }

    public double[] readDoubleArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readDoubleArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public double[] readDoubleArrayUInt32(long l2) {
        byte[] byArray = this.readUByteArrayUInt32((l2 & 0xFFFFFFFFL) * 8L & 0xFFFFFFFFL);
        double[] dArray = null;
        if (byArray != null) {
            dArray = this.processReadDataDouble(byArray);
        }
        return dArray;
    }

    public float readFloat() {
        float[] fArray = this.readFloatArrayInt32(1);
        float f2 = 0.0f;
        if (fArray != null && fArray.length == 1) {
            f2 = fArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read float value.");
        }
        return f2;
    }

    public float[] readFloatArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readFloatArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public float[] readFloatArrayUInt32(long l2) {
        byte[] byArray = this.readUByteArrayUInt32((l2 & 0xFFFFFFFFL) * 4L & 0xFFFFFFFFL);
        float[] fArray = null;
        if (byArray != null) {
            fArray = this.processReadDataFloat(byArray);
        }
        return fArray;
    }

    public TiffRational readRational() {
        TiffRational tiffRational = null;
        byte[] byArray = new byte[8];
        if (this.read(byArray) == 8) {
            long[] lArray = this.processReadDataULong(byArray);
            tiffRational = new TiffRational(lArray[0], lArray[1]);
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read 8 bytes from the stream.");
        }
        return tiffRational;
    }

    public TiffSRational readSRational() {
        TiffSRational tiffSRational = null;
        byte[] byArray = new byte[8];
        if (this.read(byArray) == 8) {
            int[] nArray = this.processReadDataLong(byArray);
            tiffSRational = new TiffSRational(nArray[0], nArray[1]);
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read 8 bytes from the stream.");
        }
        return tiffSRational;
    }

    public TiffRational[] readRationalArrayUInt32(long l2) {
        TiffRational[] tiffRationalArray = null;
        byte[] byArray = new byte[(int)((l2 & 0xFFFFFFFFL) * 8L & 0xFFFFFFFFL)];
        if (this.read(byArray) == byArray.length) {
            long[] lArray = this.processReadDataULong(byArray);
            tiffRationalArray = new TiffRational[(int)(l2 & 0xFFFFFFFFL)];
            int n2 = 0;
            while ((long)n2 < (l2 & 0xFFFFFFFFL)) {
                tiffRationalArray[n2] = new TiffRational(lArray[n2 * 2], lArray[n2 * 2 + 1]);
                ++n2;
            }
        } else if (this.a) {
            throw new InvalidOperationException(StringExtensions.concat("FrameworkException: Cannot read ", Int32Extensions.toString(byArray.length), " bytes from the stream."));
        }
        return tiffRationalArray;
    }

    public TiffRational[] readRationalArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readRationalArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public TiffSRational[] readSRationalArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readSRationalArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public TiffSRational[] readSRationalArrayUInt32(long l2) {
        TiffSRational[] tiffSRationalArray = null;
        byte[] byArray = new byte[(int)((l2 & 0xFFFFFFFFL) * 8L & 0xFFFFFFFFL)];
        if (this.read(byArray) == byArray.length) {
            int[] nArray = this.processReadDataLong(byArray);
            tiffSRationalArray = new TiffSRational[(int)(l2 & 0xFFFFFFFFL)];
            int n2 = 0;
            while ((long)n2 < (l2 & 0xFFFFFFFFL)) {
                tiffSRationalArray[n2] = new TiffSRational(nArray[n2 * 2], nArray[n2 * 2 + 1]);
                ++n2;
            }
        } else if (this.a) {
            throw new InvalidOperationException(StringExtensions.concat("FrameworkException: Cannot read ", Int32Extensions.toString(byArray.length), " bytes from the stream."));
        }
        return tiffSRationalArray;
    }

    public byte readSByte() {
        byte[] byArray = this.readSByteArrayInt32(1);
        byte by2 = 0;
        if (byArray != null && byArray.length == 1) {
            by2 = byArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read SByte value.");
        }
        return by2;
    }

    public byte[] readSByteArrayUInt32(long l2) {
        byte[] byArray = null;
        byte[] byArray2 = this.readUByteArrayUInt32(l2);
        if (byArray2 != null) {
            byArray = new byte[(int)(l2 & 0xFFFFFFFFL)];
            if ((l2 & 0xFFFFFFFFL) <= Integer.MAX_VALUE) {
                Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 0, (int)(l2 & 0xFFFFFFFFL));
            } else {
                Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), 0, Integer.MAX_VALUE);
                long l3 = (l2 & 0xFFFFFFFFL) - Integer.MAX_VALUE & 0xFFFFFFFFL;
                long l4 = Integer.MAX_VALUE;
                long l5 = 0L;
                while ((l5 & 0xFFFFFFFFL) < (l3 & 0xFFFFFFFFL)) {
                    byArray[(int)l4] = byArray2[(int)l4];
                    ++l4;
                    ++l5;
                }
            }
        }
        return byArray;
    }

    public byte[] readSByteArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readSByteArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public int readSLong() {
        int[] nArray = this.readSLongArrayInt32(1);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read SLong value.");
        }
        return n2;
    }

    public int[] readSLongArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readSLongArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public int[] readSLongArrayUInt32(long l2) {
        byte[] byArray = this.readUByteArrayUInt32((l2 & 0xFFFFFFFFL) * 4L & 0xFFFFFFFFL);
        int[] nArray = null;
        if (byArray != null) {
            nArray = this.processReadDataLong(byArray);
        }
        return nArray;
    }

    public short readSShort() {
        short[] sArray = this.readSShortArrayInt32(1);
        short s2 = 0;
        if (sArray != null && sArray.length == 1) {
            s2 = sArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read SShort value.");
        }
        return s2;
    }

    public short[] readSShortArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readSShortArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public short[] readSShortArrayUInt32(long l2) {
        short[] sArray = null;
        byte[] byArray = this.readUByteArrayUInt32((l2 & 0xFFFFFFFFL) * 2L & 0xFFFFFFFFL);
        if (byArray != null) {
            sArray = this.processReadDataShort(byArray);
        }
        return sArray;
    }

    public byte readUByte() {
        byte[] byArray = this.readUByteArrayInt32(1);
        byte by2 = 0;
        if (byArray != null && byArray.length == 1) {
            by2 = byArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read UByte value.");
        }
        return by2;
    }

    public long readULong() {
        long[] lArray = this.readULongArrayInt32(1);
        long l2 = 0L;
        if (lArray != null && lArray.length == 1) {
            l2 = lArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read ULong value.");
        }
        return l2;
    }

    public long[] readULongArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readULongArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public long[] readULongArrayUInt32(long l2) {
        long[] lArray = null;
        byte[] byArray = this.readUByteArrayUInt32((l2 & 0xFFFFFFFFL) * 4L & 0xFFFFFFFFL);
        if (byArray != null) {
            lArray = this.processReadDataULong(byArray);
        }
        return lArray;
    }

    public int readUShort() {
        int[] nArray = this.readUShortArrayInt32(1);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        } else if (this.a) {
            throw new InvalidOperationException("FrameworkException: Cannot read UShort value.");
        }
        return n2;
    }

    public int[] readUShortArrayInt32(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Expected a positive number.");
        }
        return this.readUShortArrayUInt32((long)n2 & 0xFFFFFFFFL);
    }

    public int[] readUShortArrayUInt32(long l2) {
        int[] nArray = null;
        byte[] byArray = this.readUByteArrayUInt32((l2 & 0xFFFFFFFFL) * 2L & 0xFFFFFFFFL);
        if (byArray != null) {
            nArray = this.processReadDataUShort(byArray);
        }
        return nArray;
    }

    public void writeDouble(double d2) {
        double[] dArray = new double[]{d2};
        this.writeDoubleArray(dArray);
    }

    public void writeDoubleArray(double[] dArray) {
        byte[] byArray = new byte[dArray.length * TiffConsts.getTiffTypeSize()[12]];
        this.processWriteDataDouble(dArray, byArray);
        this.write(byArray);
    }

    public void writeFloat(float f2) {
        float[] fArray = new float[]{f2};
        this.writeFloatArray(fArray);
    }

    public void writeFloatArray(float[] fArray) {
        byte[] byArray = new byte[fArray.length * 4];
        this.processWriteDataFloat(fArray, byArray);
        this.write(byArray);
    }

    public void writeRational(TiffRational tiffRational) {
        TiffRational[] tiffRationalArray = new TiffRational[]{tiffRational};
        this.writeRationalArray(tiffRationalArray);
    }

    public void writeSRational(TiffSRational tiffSRational) {
        TiffSRational[] tiffSRationalArray = new TiffSRational[]{tiffSRational};
        this.writeSRationalArray(tiffSRationalArray);
    }

    public void writeRationalArray(TiffRational[] tiffRationalArray) {
        for (int i2 = 0; i2 < tiffRationalArray.length; ++i2) {
            TiffRational tiffRational = tiffRationalArray[i2];
            byte[] byArray = new byte[4];
            this.processWriteDataULong(new long[]{tiffRational.getNominator()}, byArray);
            byte[] byArray2 = new byte[4];
            this.processWriteDataULong(new long[]{tiffRational.getDenominator()}, byArray2);
            this.write(byArray);
            this.write(byArray2);
        }
    }

    public void writeSRationalArray(TiffSRational[] tiffSRationalArray) {
        for (int i2 = 0; i2 < tiffSRationalArray.length; ++i2) {
            TiffSRational tiffSRational = tiffSRationalArray[i2];
            byte[] byArray = new byte[4];
            this.processWriteDataLong(new int[]{tiffSRational.getNominator()}, byArray);
            byte[] byArray2 = new byte[4];
            this.processWriteDataLong(new int[]{tiffSRational.getDenominator()}, byArray2);
            this.write(byArray);
            this.write(byArray2);
        }
    }

    public void writeSByte(byte by2) {
        byte[] byArray = new byte[]{by2};
        this.write(byArray);
    }

    public void writeSByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), 0, byArray2.length);
        this.write(byArray2);
    }

    public void writeSLongArray(int[] nArray) {
        byte[] byArray = new byte[nArray.length * TiffConsts.getTiffTypeSize()[9]];
        this.processWriteDataLong(nArray, byArray);
        this.write(byArray);
    }

    public void writeSShort(short s2) {
        short[] sArray = new short[]{s2};
        this.writeSShortArray(sArray);
    }

    public void writeSShortArray(short[] sArray) {
        byte[] byArray = new byte[sArray.length * TiffConsts.getTiffTypeSize()[8]];
        this.processWriteDataShort(sArray, byArray);
        this.write(byArray);
    }

    public void writeSlong(int n2) {
        int[] nArray = new int[]{n2};
        this.writeSLongArray(nArray);
    }

    public void writeUByte(byte by2) {
        byte[] byArray = new byte[]{by2};
        this.write(byArray);
    }

    public void writeULong(long l2) {
        long[] lArray = new long[]{l2};
        this.writeULongArray(lArray);
    }

    public void writeULongArray(long[] lArray) {
        byte[] byArray = new byte[lArray.length * TiffConsts.getTiffTypeSize()[4]];
        this.processWriteDataULong(lArray, byArray);
        this.write(byArray);
    }

    public void writeUShort(int n2) {
        int[] nArray = new int[]{n2};
        this.writeUShortArray(nArray);
    }

    public void writeUShortArray(int[] nArray) {
        byte[] byArray = new byte[nArray.length * TiffConsts.getTiffTypeSize()[3]];
        this.processWriteDataUShort(nArray, byArray);
        this.write(byArray);
    }

    protected double[] processReadDataDouble(byte[] byArray) {
        double[] dArray = new double[byArray.length / 8];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(dArray), 0, byArray.length);
        return dArray;
    }

    protected float[] processReadDataFloat(byte[] byArray) {
        float[] fArray = new float[byArray.length / 4];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(fArray), 0, byArray.length);
        return fArray;
    }

    protected int[] processReadDataLong(byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(nArray), 0, byArray.length);
        return nArray;
    }

    protected short[] processReadDataShort(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(sArray), 0, byArray.length);
        return sArray;
    }

    protected long[] processReadDataULong(byte[] byArray) {
        long[] lArray = new long[byArray.length / 4];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = BitConverter.toUInt32(byArray, i2 * 4);
        }
        return lArray;
    }

    protected int[] processReadDataUShort(byte[] byArray) {
        int[] nArray = new int[byArray.length / 2];
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            nArray[i2] = BitConverter.toUInt16(byArray, i2 * 2);
        }
        return nArray;
    }

    protected void processWriteDataLong(int[] nArray, byte[] byArray) {
        Buffer.blockCopy(Array.boxing(nArray), 0, Array.boxing(byArray), 0, nArray.length * 4);
    }

    protected void processWriteDataRational(TiffRational[] tiffRationalArray, byte[] byArray) {
        for (int i2 = 0; i2 < tiffRationalArray.length; ++i2) {
            byte[] byArray2 = BitConverter.getBytesUInt32(tiffRationalArray[i2].getNominator());
            byte[] byArray3 = BitConverter.getBytesUInt32(tiffRationalArray[i2].getDenominator());
            Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), i2 * 8, 4);
            Buffer.blockCopy(Array.boxing(byArray3), 0, Array.boxing(byArray), i2 * 8 + 1, 4);
        }
    }

    protected void processWriteDataULong(long[] lArray, byte[] byArray) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            byte[] byArray2 = BitConverter.getBytesUInt32(lArray[i2]);
            byArray[4 * i2 + 0] = byArray2[0];
            byArray[4 * i2 + 1] = byArray2[1];
            byArray[4 * i2 + 2] = byArray2[2];
            byArray[4 * i2 + 3] = byArray2[3];
        }
    }

    protected void processWriteDataShort(short[] sArray, byte[] byArray) {
        Buffer.blockCopy(Array.boxing(sArray), 0, Array.boxing(byArray), 0, sArray.length * 2);
    }

    protected void processWriteDataUShort(int[] nArray, byte[] byArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byte[] byArray2 = BitConverter.getBytesUInt16(nArray[i2]);
            byArray[i2 * 2 + 0] = byArray2[0];
            byArray[i2 * 2 + 1] = byArray2[1];
        }
    }

    protected void processWriteDataFloat(float[] fArray, byte[] byArray) {
        Buffer.blockCopy(Array.boxing(fArray), 0, Array.boxing(byArray), 0, fArray.length * 4);
    }

    protected void processWriteDataDouble(double[] dArray, byte[] byArray) {
        Buffer.blockCopy(Array.boxing(dArray), 0, Array.boxing(byArray), 0, dArray.length * 8);
    }

    public long getFrameLastPosition() {
        return this.b;
    }

    public void setFrameLastPosition(long l2) {
        this.b = l2;
    }
}

