/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageLoadException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.JpegExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.AdobeApp14Segment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.IccSegment;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JFIFData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDecoderState;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegMarkers;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegDecodingController;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffBigEndianStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageloadoptions.JpegLoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IImageLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders.JpegLoaderInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders.TiffLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.sources.StreamSource;
import com.aspose.html.internal.ms.lang.Operators;

public class JpegLoader
implements IImageLoader {
    private JFIFData a;

    protected JFIFData getJFIF() {
        return this.a;
    }

    protected void setJFIF(JFIFData jFIFData) {
        this.a = jFIFData;
    }

    public static byte readJpegSegmentHeader(StreamContainer streamContainer) {
        boolean bl2;
        byte by2 = 0;
        byte[] byArray = new byte[]{0};
        boolean bl3 = !JpegLoader.a(streamContainer, byArray);
        by2 = byArray[0];
        if (bl3) {
            return -1;
        }
        while ((by2 & 0xFF) != 255) {
            byArray[0] = by2;
            bl2 = !JpegLoader.a(streamContainer, byArray);
            by2 = byArray[0];
            if (!bl2) continue;
            return -1;
        }
        do {
            byArray[0] = by2;
            bl2 = !JpegLoader.a(streamContainer, byArray);
            by2 = byArray[0];
            if (!bl2) continue;
            return -1;
        } while ((by2 & 0xFF) == 255);
        if (Enum.isDefined(Operators.typeOf(JpegMarkers.class), Operators.boxing(by2))) {
            return by2;
        }
        return -1;
    }

    public static JpegExifData getExif(JpegRawDataReader jpegRawDataReader) {
        byte[] byArray;
        int n2;
        int n3 = 0;
        int[] nArray = new int[]{0};
        jpegRawDataReader.getTwoBytes(nArray);
        n3 = nArray[0];
        MemoryStream memoryStream = new MemoryStream();
        for (int i2 = n3 -= 2; i2 > 0; i2 -= n2) {
            byArray = new byte[n3];
            if (!jpegRawDataReader.makeByteAvailable()) {
                throw new FrameworkException("Cannot parse file.", new ImageLoadException("Not enough data in stream."));
            }
            n2 = jpegRawDataReader.getBytes(byArray, i2);
            memoryStream.write(byArray, 0, n2);
        }
        memoryStream.seek(0L, 0);
        byArray = new byte[6];
        memoryStream.read(byArray, 0, byArray.length);
        String string = Encoding.getUTF8().getString(byArray, 0, byArray.length);
        JpegExifData jpegExifData = null;
        if (StringExtensions.startsWith(string, "Exif")) {
            try {
                TiffStream tiffStream = TiffLoader.readExifHeader(memoryStream);
                jpegExifData = TiffLoader.getJpegExifDataOnly(tiffStream);
                jpegExifData.setBigEndian(Operators.is(tiffStream, TiffBigEndianStream.class));
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }
        return jpegExifData;
    }

    public static boolean readJpegFileHeader(StreamContainer streamContainer) {
        int n2 = streamContainer.readByte();
        int n3 = streamContainer.readByte();
        return n2 == 255 || n3 == 216;
    }

    public static JpegImage readJpegHead(StreamContainer streamContainer, LoadOptions loadOptions) {
        JpegLoaderInfo jpegLoaderInfo = JpegLoader.getJpegInfo(streamContainer, loadOptions);
        JpegImage jpegImage = new JpegImage(jpegLoaderInfo.getWidth(), jpegLoaderInfo.getHeight(), jpegLoaderInfo.getPixelFormat(), jpegLoaderInfo.getJpegDataReader());
        jpegImage.setCMYKColorProfile(jpegLoaderInfo.getCmykColorProfile());
        jpegImage.setRGBColorProfile(jpegLoaderInfo.getRgbColorProfile());
        jpegLoaderInfo.getJpegDataReader().setRasterImage(jpegImage);
        jpegImage.setJfif(jpegLoaderInfo.getJfifData());
        jpegImage.setExifData(jpegLoaderInfo.getExifData());
        jpegImage.setComment(jpegLoaderInfo.getComment());
        return jpegImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JpegLoaderInfo getJpegInfo(StreamContainer streamContainer, LoadOptions loadOptions) {
        JpegLoaderInfo jpegLoaderInfo = new JpegLoaderInfo();
        IccSegment iccSegment = new IccSegment();
        streamContainer.seek(0L, 0);
        if (!JpegLoader.readJpegFileHeader(streamContainer)) {
            throw new FrameworkException("Cannot parse file.", new ImageLoadException("Not a jpeg data."));
        }
        JpegDecodingController jpegDecodingController = new JpegDecodingController();
        jpegDecodingController.setDecoderState(new JpegDecoderState(streamContainer));
        if (Operators.is(loadOptions, JpegLoadOptions.class)) {
            jpegDecodingController.getDecoderState().setJpegLoadOptions(Operators.as(loadOptions, JpegLoadOptions.class));
        }
        jpegDecodingController.getDecoderState().setIccProfile(iccSegment.getProfileStream());
        jpegDecodingController.setInitialDataPosition(streamContainer.getPosition());
        JpegExifData jpegExifData = null;
        JFIFData jFIFData = null;
        AdobeApp14Segment adobeApp14Segment = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        char[] cArray = null;
        block31: while (true) {
            if (bl4) {
                jpegLoaderInfo.setJfifData(jFIFData);
                jpegLoaderInfo.setExifData(jpegExifData);
                jpegLoaderInfo.setComment(StringExtensions.newString(cArray));
                return jpegLoaderInfo;
            }
            byte by2 = jpegDecodingController.getDecoderState().getRawDataReader().consumeMarker();
            switch (by2) {
                case -39: {
                    throw new FrameworkException("Cannot parse file.", new ImageLoadException("Not enough data in stream."));
                }
                case -38: {
                    bl4 = true;
                    continue block31;
                }
                case -64: 
                case -63: 
                case -62: {
                    PixelDataFormat pixelDataFormat;
                    int n2;
                    byte by3 = by2 == -62 ? (byte)-62 : -64;
                    JpegFrame jpegFrame = JpegFrame.read(jpegDecodingController.getDecoderState().getRawDataReader(), by3);
                    jpegLoaderInfo.setFrame(jpegFrame);
                    if (Operators.is(loadOptions, JpegLoadOptions.class)) {
                        int n3 = Operators.as(loadOptions, JpegLoadOptions.class).getColorMode();
                        switch (n3) {
                            case 0: {
                                n2 = 0;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                            case 2: {
                                n2 = 4;
                                break;
                            }
                            case 3: {
                                n2 = 5;
                                break;
                            }
                            case 4: {
                                n2 = 2;
                                break;
                            }
                            default: {
                                n2 = 1;
                                break;
                            }
                        }
                    } else {
                        n2 = JpegLoader.a(jpegFrame, adobeApp14Segment, jFIFData);
                    }
                    switch (n2) {
                        case 0: {
                            pixelDataFormat = PixelDataFormat.getGrayscale();
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 1;
                            pixelDataFormat = jpegFrame.getComponentInfos().length == 4 ? PixelDataFormat.getRgb32Bpp() : PixelDataFormat.getRgb24BppPng();
                            break;
                        }
                        case 3: {
                            pixelDataFormat = PixelDataFormat.getYCbCr();
                            break;
                        }
                        case 4: {
                            pixelDataFormat = PixelDataFormat.getCMYK();
                            break;
                        }
                        case 5: {
                            pixelDataFormat = PixelDataFormat.getYcck();
                            break;
                        }
                        default: {
                            throw new ArgumentOutOfRangeException();
                        }
                    }
                    jpegLoaderInfo.setPixelFormat(n2);
                    jpegDecodingController.setColorFormat(n2);
                    jpegDecodingController.setRawDataSettings(new RawDataSettings());
                    jpegDecodingController.getRawDataSettings().setColorPalette(null);
                    jpegDecodingController.getRawDataSettings().setDitheringMethod(0);
                    jpegDecodingController.getRawDataSettings().setIndexedColorConverter(null);
                    jpegDecodingController.getRawDataSettings().setLineSize((jpegFrame.getBitsPerSample() & 0xFF) * jpegFrame.getComponentInfos().length * (jpegFrame.getX() & 0xFFFF));
                    jpegDecodingController.getRawDataSettings().setPixelDataFormat(pixelDataFormat);
                    jpegDecodingController.getDecoderState().setJpegFrame(jpegFrame);
                    jpegLoaderInfo.setWidth(jpegFrame.getX() & 0xFFFF);
                    jpegLoaderInfo.setHeight(jpegFrame.getY() & 0xFFFF);
                    jpegLoaderInfo.setJpegDataReader(new JpegDataReader(jpegDecodingController));
                    if (jpegDecodingController.getDecoderState().getIccProfile().getLength() <= 0L) continue block31;
                    jpegDecodingController.getDecoderState().getIccProfile().seek(0L, 0);
                    jpegLoaderInfo.setCmykColorProfile(new StreamSource(jpegDecodingController.getDecoderState().getIccProfile()));
                    jpegLoaderInfo.setRgbColorProfile(IccProfileHelper.getDefaultRGBProfile());
                    continue block31;
                }
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    throw new NotSupportedException(StringExtensions.format("Format {0} is not supported", by2));
                }
                case -2: {
                    int n4 = 0;
                    int[] nArray = new int[]{0};
                    jpegDecodingController.getDecoderState().getRawDataReader().getTwoBytes(nArray);
                    n4 = nArray[0];
                    cArray = new char[n4 -= 2];
                    int i2 = 0;
                    while (true) {
                        if (i2 >= n4) continue block31;
                        int n5 = 0;
                        int[] nArray2 = new int[]{0};
                        jpegDecodingController.getDecoderState().getRawDataReader().getByte(nArray2);
                        n5 = nArray2[0];
                        cArray[i2] = (char)n5;
                        ++i2;
                    }
                }
                case -32: {
                    if (!bl3) {
                        jFIFData = JFIFData.read(jpegDecodingController.getDecoderState().getRawDataReader());
                        bl3 = true;
                        continue block31;
                    }
                    JpegLoader.jumpOverSegment(jpegDecodingController.getDecoderState().getRawDataReader());
                    continue block31;
                }
                case -18: {
                    adobeApp14Segment = AdobeApp14Segment.read(jpegDecodingController.getDecoderState().getRawDataReader());
                    continue block31;
                }
                case -17: {
                    JpegLoader.jumpOverSegment(jpegDecodingController.getDecoderState().getRawDataReader());
                    continue block31;
                }
                case -1: {
                    JpegLoader.jumpOverSegment(jpegDecodingController.getDecoderState().getRawDataReader());
                    continue block31;
                }
                case -31: {
                    try {
                        boolean bl5;
                        try {
                            if (!bl2) {
                                jpegExifData = JpegLoader.getExif(jpegDecodingController.getDecoderState().getRawDataReader());
                            } else {
                                JpegLoader.jumpOverSegment(jpegDecodingController.getDecoderState().getRawDataReader());
                            }
                            bl5 = jpegExifData != null;
                        }
                        catch (RuntimeException runtimeException) {
                            bl2 = jpegExifData != null;
                            continue block31;
                        }
                        bl2 = bl5;
                        continue block31;
                    }
                    catch (Throwable throwable) {
                        bl2 = jpegExifData != null;
                        throw throwable;
                    }
                }
                case -30: {
                    iccSegment.readIccChunk(jpegDecodingController.getDecoderState().getRawDataReader());
                    continue block31;
                }
            }
            JpegLoader.jumpOverSegment(jpegDecodingController.getDecoderState().getRawDataReader());
        }
    }

    public static void jumpOverSegment(JpegRawDataReader jpegRawDataReader) {
        int n2 = 0;
        int[] nArray = new int[]{0};
        jpegRawDataReader.getTwoBytes(nArray);
        n2 = nArray[0];
        jpegRawDataReader.skipInputData(n2 - 2);
    }

    public static boolean findFirstSOS(StreamContainer streamContainer) {
        boolean bl2 = false;
        while (streamContainer.getPosition() < streamContainer.getLength()) {
            byte by2 = JpegLoader.readJpegSegmentHeader(streamContainer);
            if (by2 == -38) {
                bl2 = true;
                break;
            }
            int n2 = streamContainer.readByte() << 8 | streamContainer.readByte();
            streamContainer.seek(n2 - 2, 1);
        }
        return bl2;
    }

    @Override
    public Image load(StreamContainer streamContainer, LoadOptions loadOptions) {
        return JpegLoader.readJpegHead(streamContainer, loadOptions);
    }

    private static boolean a(StreamContainer streamContainer, byte[] byArray) {
        int n2 = streamContainer.readByte();
        if (n2 == -1) {
            byArray[0] = 0;
            return false;
        }
        byArray[0] = (byte)n2;
        return true;
    }

    private static int a(JpegFrame jpegFrame, AdobeApp14Segment adobeApp14Segment, JFIFData jFIFData) {
        int n2;
        block0 : switch (jpegFrame.getComponentInfos().length) {
            case 1: {
                n2 = 0;
                break;
            }
            case 3: {
                if (jFIFData != null) {
                    n2 = 3;
                    break;
                }
                if (adobeApp14Segment != null) {
                    n2 = (adobeApp14Segment.getTransform() & 0xFF) == 0 ? 1 : 3;
                    break;
                }
                if ((jpegFrame.getComponentInfos()[0].getId() & 0xFF) == 82 && (jpegFrame.getComponentInfos()[1].getId() & 0xFF) == 71 && (jpegFrame.getComponentInfos()[2].getId() & 0xFF) == 66) {
                    n2 = 2;
                    break;
                }
                n2 = 3;
                break;
            }
            case 4: {
                if (adobeApp14Segment != null) {
                    switch (adobeApp14Segment.getTransform()) {
                        case 0: {
                            n2 = 4;
                            break block0;
                        }
                        case 2: {
                            n2 = 5;
                            break block0;
                        }
                    }
                    n2 = 5;
                    break;
                }
                n2 = 4;
                break;
            }
            default: {
                throw new NotSupportedException("Following jpeg colorspace is not supported yet.");
            }
        }
        return n2;
    }
}

