/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.ocsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1GeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERGeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.BasicOCSPResponse;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.CertStatus;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.ResponseData;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.RevokedInfo;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.SingleResponse;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.CRLReason;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.BasicOCSPResp;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.CertificateID;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.CertificateStatus;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPException;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.RespID;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.RevokedStatus;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.UnknownStatus;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespBuilder {
    private List list = new ArrayList();
    private Extensions responseExtensions = null;
    private RespID responderID;

    public BasicOCSPRespBuilder(RespID respID) {
        this.responderID = respID;
    }

    public BasicOCSPRespBuilder(SubjectPublicKeyInfo subjectPublicKeyInfo, DigestCalculator digestCalculator) throws OCSPException {
        this.responderID = new RespID(subjectPublicKeyInfo, digestCalculator);
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus) {
        this.addResponse(certificateID, certificateStatus, new Date(), null, null);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Extensions extensions) {
        this.addResponse(certificateID, certificateStatus, new Date(), null, extensions);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Extensions extensions) {
        this.addResponse(certificateID, certificateStatus, new Date(), date, extensions);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Date date2) {
        this.addResponse(certificateID, certificateStatus, date, date2, null);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Date date2, Extensions extensions) {
        this.list.add(new ResponseObject(certificateID, certificateStatus, date, date2, extensions));
        return this;
    }

    public BasicOCSPRespBuilder setResponseExtensions(Extensions extensions) {
        this.responseExtensions = extensions;
        return this;
    }

    public BasicOCSPResp build(ContentSigner contentSigner, X509CertificateHolder[] x509CertificateHolderArray, Date date) throws OCSPException {
        DERBitString dERBitString;
        Object object;
        Iterator iterator = this.list.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            try {
                aSN1EncodableVector.add(((ResponseObject)iterator.next()).toResponse());
            }
            catch (Exception exception) {
                throw new OCSPException("exception creating Request", exception);
            }
        }
        ResponseData responseData = new ResponseData(this.responderID.toASN1Primitive(), new ASN1GeneralizedTime(date), new DERSequence(aSN1EncodableVector), this.responseExtensions);
        try {
            object = contentSigner.getOutputStream();
            ((OutputStream)object).write(responseData.getEncoded("DER"));
            ((OutputStream)object).close();
            dERBitString = new DERBitString(contentSigner.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing TBSRequest: " + exception.getMessage(), exception);
        }
        object = contentSigner.getAlgorithmIdentifier();
        DERSequence dERSequence = null;
        if (x509CertificateHolderArray != null && x509CertificateHolderArray.length > 0) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                aSN1EncodableVector2.add(x509CertificateHolderArray[i2].toASN1Structure());
            }
            dERSequence = new DERSequence(aSN1EncodableVector2);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(responseData, (AlgorithmIdentifier)object, dERBitString, dERSequence));
    }

    private class ResponseObject {
        CertificateID certId;
        CertStatus certStatus;
        ASN1GeneralizedTime thisUpdate;
        ASN1GeneralizedTime nextUpdate;
        Extensions extensions;

        public ResponseObject(CertificateID certificateID, CertificateStatus certificateStatus, Date date, Date date2, Extensions extensions) {
            RevokedStatus revokedStatus;
            this.certId = certificateID;
            this.certStatus = certificateStatus == null ? new CertStatus() : (certificateStatus instanceof UnknownStatus ? new CertStatus(2, DERNull.INSTANCE) : ((revokedStatus = (RevokedStatus)certificateStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(revokedStatus.getRevocationTime()), CRLReason.lookup(revokedStatus.getRevocationReason()))) : new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(revokedStatus.getRevocationTime()), null))));
            this.thisUpdate = new DERGeneralizedTime(date);
            this.nextUpdate = date2 != null ? new DERGeneralizedTime(date2) : null;
            this.extensions = extensions;
        }

        public SingleResponse toResponse() throws Exception {
            return new SingleResponse(this.certId.toASN1Primitive(), this.certStatus, this.thisUpdate, this.nextUpdate, this.extensions);
        }
    }
}

