/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ecc.ECCCMSSharedInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ecc.MQVuserKeyingMaterial;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.KeyAgreeRecipient;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.DefaultJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.EnvelopedDataHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.KeyMaterialGenerator;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.NamedJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.ProviderJcaJceExtHelper;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.RFC5753KeyMaterialGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.MQVParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.html.internal.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.util.Pack;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public abstract class JceKeyAgreeRecipient
implements KeyAgreeRecipient {
    private static final Set possibleOldMessages = new HashSet();
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    private SecretKeySizeProvider keySizeProvider;
    private AlgorithmIdentifier privKeyAlgID;
    private static KeyMaterialGenerator old_ecc_cms_Generator;
    private static KeyMaterialGenerator simple_ecc_cmsGenerator;
    private static KeyMaterialGenerator ecc_cms_Generator;

    public JceKeyAgreeRecipient(PrivateKey privateKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.keySizeProvider = new DefaultSecretKeySizeProvider();
        this.privKeyAlgID = null;
        this.recipientKey = CMSUtils.cleanPrivateKey(privateKey);
    }

    public JceKeyAgreeRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(String string) {
        this.contentHelper = CMSUtils.createContentHelper(string);
        return this;
    }

    public JceKeyAgreeRecipient setPrivateKeyAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.privKeyAlgID = algorithmIdentifier;
        return this;
    }

    private SecretKey calculateAgreedWrapKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, PublicKey publicKey, ASN1OctetString aSN1OctetString, PrivateKey privateKey, KeyMaterialGenerator keyMaterialGenerator) throws CMSException, GeneralSecurityException, IOException {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        if (CMSUtils.isMQV(algorithmIdentifier.getAlgorithm())) {
            byte[] byArray;
            MQVuserKeyingMaterial mQVuserKeyingMaterial = MQVuserKeyingMaterial.getInstance(aSN1OctetString.getOctets());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(this.getPrivateKeyAlgorithmIdentifier(), mQVuserKeyingMaterial.getEphemeralPublicKey().getPublicKey().getBytes());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithmIdentifier.getAlgorithm());
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            KeyAgreement keyAgreement = this.helper.createKeyAgreement(algorithmIdentifier.getAlgorithm());
            byte[] byArray2 = byArray = mQVuserKeyingMaterial.getAddedukm() != null ? mQVuserKeyingMaterial.getAddedukm().getOctets() : null;
            if (keyMaterialGenerator == old_ecc_cms_Generator) {
                byArray = old_ecc_cms_Generator.generateKDFMaterial(algorithmIdentifier2, this.keySizeProvider.getKeySize(algorithmIdentifier2), byArray);
            }
            keyAgreement.init((Key)privateKey, new MQVParameterSpec(privateKey, publicKey2, byArray));
            keyAgreement.doPhase(publicKey, true);
            return keyAgreement.generateSecret(algorithmIdentifier2.getAlgorithm().getId());
        }
        KeyAgreement keyAgreement = this.helper.createKeyAgreement(algorithmIdentifier.getAlgorithm());
        UserKeyingMaterialSpec userKeyingMaterialSpec = null;
        if (CMSUtils.isEC(algorithmIdentifier.getAlgorithm())) {
            if (aSN1OctetString != null) {
                byte[] byArray = keyMaterialGenerator.generateKDFMaterial(algorithmIdentifier2, this.keySizeProvider.getKeySize(algorithmIdentifier2), aSN1OctetString.getOctets());
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(byArray);
            } else {
                byte[] byArray = keyMaterialGenerator.generateKDFMaterial(algorithmIdentifier2, this.keySizeProvider.getKeySize(algorithmIdentifier2), null);
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(byArray);
            }
        } else if (CMSUtils.isRFC2631(algorithmIdentifier.getAlgorithm())) {
            if (aSN1OctetString != null) {
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(aSN1OctetString.getOctets());
            }
        } else if (CMSUtils.isGOST(algorithmIdentifier.getAlgorithm())) {
            if (aSN1OctetString != null) {
                userKeyingMaterialSpec = new UserKeyingMaterialSpec(aSN1OctetString.getOctets());
            }
        } else {
            throw new CMSException("Unknown key agreement algorithm: " + algorithmIdentifier.getAlgorithm());
        }
        keyAgreement.init((Key)privateKey, userKeyingMaterialSpec);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret(algorithmIdentifier2.getAlgorithm().getId());
    }

    protected Key unwrapSessionKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SecretKey secretKey, ASN1ObjectIdentifier aSN1ObjectIdentifier2, byte[] byArray) throws CMSException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = this.helper.createCipher(aSN1ObjectIdentifier);
        cipher.init(4, secretKey);
        return cipher.unwrap(byArray, this.helper.getBaseCipherName(aSN1ObjectIdentifier2), 3);
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        try {
            AlgorithmIdentifier algorithmIdentifier3 = AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = this.helper.createKeyFactory(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            try {
                SecretKey secretKey = this.calculateAgreedWrapKey(algorithmIdentifier, algorithmIdentifier3, publicKey, aSN1OctetString, this.recipientKey, ecc_cms_Generator);
                return this.unwrapSessionKey(algorithmIdentifier3.getAlgorithm(), secretKey, algorithmIdentifier2.getAlgorithm(), byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                if (possibleOldMessages.contains(algorithmIdentifier.getAlgorithm())) {
                    SecretKey secretKey = this.calculateAgreedWrapKey(algorithmIdentifier, algorithmIdentifier3, publicKey, aSN1OctetString, this.recipientKey, old_ecc_cms_Generator);
                    return this.unwrapSessionKey(algorithmIdentifier3.getAlgorithm(), secretKey, algorithmIdentifier2.getAlgorithm(), byArray);
                }
                if (aSN1OctetString != null) {
                    try {
                        SecretKey secretKey = this.calculateAgreedWrapKey(algorithmIdentifier, algorithmIdentifier3, publicKey, aSN1OctetString, this.recipientKey, simple_ecc_cmsGenerator);
                        return this.unwrapSessionKey(algorithmIdentifier3.getAlgorithm(), secretKey, algorithmIdentifier2.getAlgorithm(), byArray);
                    }
                    catch (InvalidKeyException invalidKeyException2) {
                        throw invalidKeyException;
                    }
                }
                throw invalidKeyException;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception) {
            throw new CMSException("originator key invalid.", exception);
        }
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithmIdentifier() {
        if (this.privKeyAlgID == null) {
            this.privKeyAlgID = PrivateKeyInfo.getInstance(this.recipientKey.getEncoded()).getPrivateKeyAlgorithm();
        }
        return this.privKeyAlgID;
    }

    static {
        possibleOldMessages.add(X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme);
        possibleOldMessages.add(X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme);
        old_ecc_cms_Generator = new KeyMaterialGenerator(){

            public byte[] generateKDFMaterial(AlgorithmIdentifier algorithmIdentifier, int n2, byte[] byArray) {
                ECCCMSSharedInfo eCCCMSSharedInfo = new ECCCMSSharedInfo(new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE), byArray, Pack.intToBigEndian(n2));
                try {
                    return eCCCMSSharedInfo.getEncoded("DER");
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unable to create KDF material: " + iOException);
                }
            }
        };
        simple_ecc_cmsGenerator = new KeyMaterialGenerator(){

            public byte[] generateKDFMaterial(AlgorithmIdentifier algorithmIdentifier, int n2, byte[] byArray) {
                return byArray;
            }
        };
        ecc_cms_Generator = new RFC5753KeyMaterialGenerator();
    }
}

