/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.sec.ECPrivateKey;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X962Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParametersID;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;

public final class AsymmetricECPrivateKey
extends AsymmetricECKey
implements AsymmetricPrivateKey,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] publicKey;
    private int hashCode;
    private BigInteger d;

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, BigInteger bigInteger) {
        this(algorithm, eCDomainParametersID, bigInteger, null);
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, BigInteger bigInteger) {
        this(algorithm, eCDomainParameters, bigInteger, null);
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, BigInteger bigInteger, ECPoint eCPoint) {
        super(algorithm, eCDomainParameters);
        this.d = bigInteger;
        this.publicKey = this.extractPublicKeyBytes(eCPoint);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, BigInteger bigInteger, ECPoint eCPoint) {
        super(algorithm, eCDomainParametersID);
        this.d = bigInteger;
        this.publicKey = this.extractPublicKeyBytes(eCPoint);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricECPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private AsymmetricECPrivateKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, ECPrivateKey eCPrivateKey) {
        super(algorithm, algorithmIdentifier);
        this.d = eCPrivateKey.getKey();
        DERBitString dERBitString = eCPrivateKey.getPublicKey();
        this.publicKey = dERBitString == null ? null : dERBitString.getBytes();
        this.hashCode = this.calculateHashCode();
    }

    private static ECPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ECPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse EC private key: " + iOException.getMessage(), iOException);
        }
    }

    private byte[] extractPublicKeyBytes(ECPoint eCPoint) {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        if (eCPoint == null) {
            return null;
        }
        return eCPoint.getEncoded(false);
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        X962Parameters x962Parameters = KeyUtils.buildCurveParameters(this.getDomainParameters());
        int n2 = KeyUtils.getOrderBitLength(this.getDomainParameters());
        ECPrivateKey eCPrivateKey = this.publicKey != null ? new ECPrivateKey(n2, this.getS(), new DERBitString(this.publicKey), x962Parameters) : new ECPrivateKey(n2, this.getS(), x962Parameters);
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), eCPrivateKey);
    }

    public final Algorithm getAlgorithm() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public final ECDomainParameters getDomainParameters() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        return super.getDomainParameters();
    }

    public BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return this.d;
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.d = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECPrivateKey)) {
            return false;
        }
        AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)object;
        if (this.isDestroyed() || asymmetricECPrivateKey.isDestroyed()) {
            return false;
        }
        if (!this.d.equals(asymmetricECPrivateKey.d)) {
            return false;
        }
        return this.getDomainParameters().equals(asymmetricECPrivateKey.getDomainParameters());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.d.hashCode();
        n2 = 31 * n2 + this.getDomainParameters().hashCode();
        return n2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

