/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410Key;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410DomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricGOST3410PrivateKey
extends AsymmetricGOST3410Key<GOST3410DomainParameters>
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters, BigInteger bigInteger) {
        super(algorithm, gOST3410Parameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_94, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricGOST3410PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey());
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[byArray.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray2[i2] = byArray[byArray.length - 1 - i2];
            }
            return new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final GOST3410Parameters<GOST3410DomainParameters> getParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getParameters();
    }

    @Override
    public final byte[] getEncoded() {
        byte[] byArray = this.getX().toByteArray();
        byte[] byArray2 = byArray[0] == 0 ? new byte[byArray.length - 1] : new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - 1 - i2];
        }
        GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters = this.getParameters();
        if (gOST3410Parameters.getEncryptionParamSet() != null) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(gOST3410Parameters.getPublicKeyParamSet(), gOST3410Parameters.getDigestParamSet(), gOST3410Parameters.getEncryptionParamSet())), new DEROctetString(byArray2));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(gOST3410Parameters.getPublicKeyParamSet(), gOST3410Parameters.getDigestParamSet())), new DEROctetString(byArray2));
    }

    public BigInteger getX() {
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return this.x;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.x.hashCode();
        n2 = 31 * n2 + this.getParameters().hashCode();
        return n2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricGOST3410PrivateKey)) {
            return false;
        }
        AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)object;
        if (this.isDestroyed() || asymmetricGOST3410PrivateKey.isDestroyed()) {
            return false;
        }
        return this.x.equals(asymmetricGOST3410PrivateKey.x) && this.getParameters().equals(asymmetricGOST3410PrivateKey.getParameters());
    }
}

