/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.KDFCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedKDFOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.SCryptImpl;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.util.Arrays;

public final class KDF {
    public static final ScryptParametersBuilder SCRYPT = new ScryptParametersBuilder(new GeneralAlgorithm("SCrypt"));

    private KDF() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SCryptFactory
    extends GuardedKDFOperatorFactory<ScryptParameters> {
        @Override
        public KDFCalculator createKDFCalculator(final ScryptParameters scryptParameters) {
            return new KDFCalculator(){

                public ScryptParameters getParameters() {
                    Utils.approveModeCheck(SCRYPT.getAlgorithm());
                    return scryptParameters;
                }

                public void generateBytes(byte[] byArray) {
                    Utils.approveModeCheck(SCRYPT.getAlgorithm());
                    byte[] byArray2 = SCryptImpl.generate(scryptParameters.seed, scryptParameters.salt, scryptParameters.n, scryptParameters.r, scryptParameters.p, byArray.length);
                    System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                    Arrays.fill(byArray2, (byte)0);
                }

                public void generateBytes(byte[] byArray, int n2, int n3) {
                    Utils.approveModeCheck(SCRYPT.getAlgorithm());
                    byte[] byArray2 = SCryptImpl.generate(scryptParameters.seed, scryptParameters.salt, scryptParameters.n, scryptParameters.r, scryptParameters.p, n3);
                    System.arraycopy(byArray2, 0, byArray, n2, n3);
                    Arrays.fill(byArray2, (byte)0);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScryptParameters
    extends GeneralParameters<GeneralAlgorithm> {
        final int n;
        final int r;
        final int p;
        final byte[] salt;
        final byte[] seed;

        private ScryptParameters(int n2, byte[] byArray, int n3, int n4, byte[] byArray2) {
            super(SCRYPT.getAlgorithm());
            this.seed = byArray;
            this.n = n2;
            this.r = n3;
            this.p = n4;
            this.salt = byArray2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScryptParametersBuilder
    extends GeneralParameters<GeneralAlgorithm> {
        ScryptParametersBuilder(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }

        public ScryptParameters using(byte[] byArray, int n2, int n3, int n4, byte[] byArray2) {
            return new ScryptParameters(n2, Arrays.clone(byArray2), n3, n4, Arrays.clone(byArray));
        }

        public ScryptParameters using(byte[] byArray, int n2, int n3, int n4, PasswordConverter passwordConverter, char[] cArray) {
            return new ScryptParameters(n2, passwordConverter.convert(cArray), n3, n4, Arrays.clone(byArray));
        }
    }
}

