/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.OperationError;
import com.aspose.html.internal.ms.core.bc.crypto.general.VariantKatTest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.test.BasicKatTest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.test.ConsistencyTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelfTestExecutor {
    SelfTestExecutor() {
    }

    static <T> T validate(Algorithm algorithm, T t2, BasicKatTest<T> basicKatTest) {
        try {
            if (!basicKatTest.hasTestPassed(t2)) {
                throw new OperationError("Self test failed: " + algorithm.getName());
            }
            return t2;
        }
        catch (Exception exception) {
            throw new OperationError("Exception on self test: " + algorithm.getName(), exception);
        }
    }

    static <T> T validate(Algorithm algorithm, T t2, ConsistencyTest<T> consistencyTest) {
        try {
            if (!consistencyTest.hasTestPassed(t2)) {
                throw new OperationError("Consistency test failed: " + algorithm.getName());
            }
            return t2;
        }
        catch (Exception exception) {
            throw new OperationError("Consistency test exception: " + algorithm.getName(), exception);
        }
    }

    static <T> T validate(Algorithm algorithm, T t2, VariantKatTest<T> variantKatTest) {
        try {
            variantKatTest.evaluate(t2);
            return t2;
        }
        catch (TestFailedException testFailedException) {
            throw new OperationError(testFailedException.getMessage() + ": " + algorithm.getName());
        }
        catch (Exception exception) {
            throw new OperationError("Exception on self test: " + algorithm.getName(), exception);
        }
    }

    static class TestFailedException
    extends RuntimeException {
        public TestFailedException(String string) {
            super(string);
        }
    }
}

