/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.SignedData;
import com.aspose.html.internal.ms.core.bc.util.io.pem.PemObject;
import com.aspose.html.internal.ms.core.bc.util.io.pem.PemWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;

class PKIXCertPath
extends CertPath {
    static final List certPathEncodings;
    private final Provider fipsProvider;
    private List certificates;

    private List sortCerts(List list) {
        int n2;
        Serializable serializable;
        if (list.size() < 2) {
            return list;
        }
        X500Principal x500Principal = ((X509Certificate)list.get(0)).getIssuerX500Principal();
        boolean bl2 = true;
        for (int i2 = 1; i2 != list.size(); ++i2) {
            serializable = (X509Certificate)list.get(i2);
            if (!x500Principal.equals(serializable.getSubjectX500Principal())) {
                bl2 = false;
                break;
            }
            x500Principal = ((X509Certificate)list.get(i2)).getIssuerX500Principal();
        }
        if (bl2) {
            return list;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        serializable = new ArrayList(list);
        for (n2 = 0; n2 < list.size(); ++n2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(n2);
            boolean bl3 = false;
            X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
            for (int i3 = 0; i3 != list.size(); ++i3) {
                X509Certificate x509Certificate2 = (X509Certificate)list.get(i3);
                if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal2)) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            arrayList.add(x509Certificate);
            list.remove(n2);
        }
        if (arrayList.size() > 1) {
            return serializable;
        }
        block3: for (n2 = 0; n2 != arrayList.size(); ++n2) {
            x500Principal = ((X509Certificate)arrayList.get(n2)).getIssuerX500Principal();
            for (int i4 = 0; i4 < list.size(); ++i4) {
                X509Certificate x509Certificate = (X509Certificate)list.get(i4);
                if (!x500Principal.equals(x509Certificate.getSubjectX500Principal())) continue;
                arrayList.add(x509Certificate);
                list.remove(i4);
                continue block3;
            }
        }
        if (list.size() > 0) {
            return serializable;
        }
        return arrayList;
    }

    PKIXCertPath(Provider provider, List list) {
        super("X.509");
        this.fipsProvider = provider;
        this.certificates = this.sortCerts(new ArrayList(list));
    }

    PKIXCertPath(Provider provider, InputStream inputStream, String string) throws CertificateException {
        block7: {
            super("X.509");
            this.fipsProvider = provider;
            try {
                if (string.equalsIgnoreCase("PkiPath")) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
                    ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
                    if (!(aSN1Primitive instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration enumeration = ((ASN1Sequence)aSN1Primitive).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", provider);
                    while (enumeration.hasMoreElements()) {
                        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
                        byte[] byArray = aSN1Encodable.toASN1Primitive().getEncoded("DER");
                        this.certificates.add(0, certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                    }
                    break block7;
                }
                if (string.equalsIgnoreCase("PKCS7") || string.equalsIgnoreCase("PEM")) {
                    inputStream = new BufferedInputStream(inputStream);
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", provider);
                    while (inputStream.available() > 0) {
                        this.certificates.add(certificateFactory.generateCertificate(inputStream));
                    }
                    break block7;
                }
                throw new CertificateException("unsupported encoding: " + string);
            }
            catch (IOException iOException) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + iOException.toString());
            }
        }
        this.certificates = this.sortCerts(this.certificates);
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Object e2;
        Iterator iterator = this.getEncodings();
        if (iterator.hasNext() && (e2 = iterator.next()) instanceof String) {
            return this.getEncoded((String)e2);
        }
        return null;
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (string.equalsIgnoreCase("PkiPath")) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ListIterator listIterator = this.certificates.listIterator(this.certificates.size());
            while (listIterator.hasPrevious()) {
                aSN1EncodableVector.add(this.toASN1Object((X509Certificate)listIterator.previous()));
            }
            return this.toDEREncoded(new DERSequence(aSN1EncodableVector));
        }
        if (string.equalsIgnoreCase("PKCS7")) {
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int i2 = 0; i2 != this.certificates.size(); ++i2) {
                aSN1EncodableVector.add(this.toASN1Object((X509Certificate)this.certificates.get(i2)));
            }
            SignedData signedData = new SignedData(new ASN1Integer(1L), new DERSet(), contentInfo, new DERSet(aSN1EncodableVector), null, new DERSet());
            return this.toDEREncoded(new ContentInfo(PKCSObjectIdentifiers.signedData, signedData));
        }
        if (string.equalsIgnoreCase("PEM")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter(new ByteArrayWriter(byteArrayOutputStream));
            try {
                for (int i3 = 0; i3 != this.certificates.size(); ++i3) {
                    pemWriter.writeObject(new PemObject("CERTIFICATE", ((X509Certificate)this.certificates.get(i3)).getEncoded()));
                }
                pemWriter.close();
            }
            catch (Exception exception) {
                throw new CertificateEncodingException("can't encode certificate for PEM encoded path");
            }
            return byteArrayOutputStream.toByteArray();
        }
        throw new CertificateEncodingException("unsupported encoding: " + string);
    }

    public List getCertificates() {
        return Collections.unmodifiableList(new ArrayList(this.certificates));
    }

    private ASN1Primitive toASN1Object(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            return ASN1Primitive.fromByteArray(x509Certificate.getEncoded());
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + exception.toString());
        }
    }

    private byte[] toDEREncoded(ASN1Encodable aSN1Encodable) throws CertificateEncodingException {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("Exception thrown: " + iOException);
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        arrayList.add("PEM");
        arrayList.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(arrayList);
    }

    private static class ByteArrayWriter
    extends Writer {
        private final ByteArrayOutputStream bOut;

        ByteArrayWriter(ByteArrayOutputStream byteArrayOutputStream) {
            this.bOut = byteArrayOutputStream;
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            for (int i2 = n2; i2 != n2 + n3; ++i2) {
                this.bOut.write(cArray[i2]);
            }
        }

        public void flush() throws IOException {
            this.bOut.flush();
        }

        public void close() throws IOException {
            this.bOut.close();
        }
    }
}

