/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ECUtil;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyUtil;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvKey;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvECPublicKey
implements ProvKey<AsymmetricECPublicKey>,
ECPublicKey {
    private static final long serialVersionUID = -569596969144472700L;
    private transient AsymmetricECPublicKey baseKey;

    ProvECPublicKey(Algorithm algorithm, ECPublicKey eCPublicKey) {
        ECDomainParameters eCDomainParameters = ECUtil.convertFromSpec(eCPublicKey.getParams());
        this.baseKey = new AsymmetricECPublicKey(algorithm, eCDomainParameters, ECUtil.convertPoint(eCDomainParameters.getCurve(), eCPublicKey.getW()));
    }

    ProvECPublicKey(Algorithm algorithm, ECPublicKeySpec eCPublicKeySpec) {
        ECDomainParameters eCDomainParameters = ECUtil.convertFromSpec(eCPublicKeySpec.getParams());
        this.baseKey = new AsymmetricECPublicKey(algorithm, eCDomainParameters, ECUtil.convertPoint(eCDomainParameters.getCurve(), eCPublicKeySpec.getW()));
    }

    ProvECPublicKey(AsymmetricECPublicKey asymmetricECPublicKey) {
        this.baseKey = asymmetricECPublicKey;
    }

    @Override
    public AsymmetricECPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return ECUtil.convertToSpec(this.baseKey.getDomainParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("EC", this.baseKey.getW(), this.baseKey.getDomainParameters());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPublicKey)) {
            return false;
        }
        if (object instanceof ProvECPublicKey) {
            ProvECPublicKey provECPublicKey = (ProvECPublicKey)object;
            return this.baseKey.equals(provECPublicKey.baseKey);
        }
        ECPublicKey eCPublicKey = (ECPublicKey)object;
        return Arrays.areEqual(this.getEncoded(), eCPublicKey.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricECPublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

