/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.edec.EdECObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricXDHPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricXDHPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.general.EdEC;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AsymmetricAlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseAgreement;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseSignature;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PrivateKeyConverter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvEdDSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvEdDSAPublicKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvXDHPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvXDHPublicKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PublicKeyConverter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.EdDSAParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.XDHParameterSpec;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

class ProvEdEC
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalEdDSAAttributes = new HashMap<String, String>();
    private static final Map<String, String> generalXDHAttributes = new HashMap<String, String>();
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.";
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    private static final PublicKeyConverter<AsymmetricEdDSAPublicKey> edPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricEdDSAPrivateKey> edPrivateKeyConverter;
    private static final PublicKeyConverter<AsymmetricXDHPublicKey> xPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricXDHPrivateKey> xPrivateKeyConverter;

    ProvEdEC() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.XDH", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyFactorySpi$XDH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi.XDH();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.X448", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyFactorySpi$X448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi.X448();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.X25519", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyFactorySpi$X25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi.X25519();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.EDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyFactorySpi$EdDH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi.EdDSA();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ED448", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi.Ed448();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ED25519", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi.Ed25519();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.EDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$EdDSA", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, false, null);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ED448", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, false, EdEC.Ed448);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ED25519", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, false, EdEC.Ed25519);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.XDH", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$XDH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, true, null);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.X448", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, true, EdEC.X448);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.X25519", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, true, EdEC.X25519);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.EDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.Signature$EDDSA", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.EdDSA);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.ED448", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.Signature$Ed448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.Ed448);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Signature", "ED448", EdECObjectIdentifiers.id_Ed448);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.ED25519", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.Signature$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.Ed25519);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Signature", "ED25519", EdECObjectIdentifiers.id_Ed25519);
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "XDH", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyAgreementSpi$XDH", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X448));
            }
        }));
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "X448", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X448));
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyAgreement", "X448", EdECObjectIdentifiers.id_X448);
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "X25519", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X25519));
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyAgreement", "X25519", EdECObjectIdentifiers.id_X25519);
        this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_X448, "X448", new KeyFactorySpi.X448());
        this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_X25519, "X25519", new KeyFactorySpi.X25519());
        this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_Ed448, "ED448", new KeyFactorySpi.Ed448());
        this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_Ed25519, "ED25519", new KeyFactorySpi.Ed25519());
    }

    static {
        generalEdDSAAttributes.put("SupportedKeyClasses", "com.aspose.html.internal.ms.core.bc.interfaces.EdDSAKey");
        generalEdDSAAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        generalXDHAttributes.put("SupportedKeyClasses", "com.aspose.html.internal.ms.core.bc.interfaces.XDHKey");
        generalXDHAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        edPublicKeyConverter = new PublicKeyConverter<AsymmetricEdDSAPublicKey>(){

            @Override
            public AsymmetricEdDSAPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ProvEdDSAPublicKey) {
                    return ((ProvEdDSAPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPublicKey(Utils.getKeyEncoding(publicKey));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EdDSA public key: " + exception.getMessage(), exception);
                }
            }
        };
        edPrivateKeyConverter = new PrivateKeyConverter<AsymmetricEdDSAPrivateKey>(){

            @Override
            public AsymmetricEdDSAPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ProvEdDSAPrivateKey) {
                    return ((ProvEdDSAPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EdDSA private key: " + exception.getMessage(), exception);
                }
            }
        };
        xPublicKeyConverter = new PublicKeyConverter<AsymmetricXDHPublicKey>(){

            @Override
            public AsymmetricXDHPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ProvXDHPublicKey) {
                    return ((ProvXDHPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricXDHPublicKey(Utils.getKeyEncoding(publicKey));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify XDH public key: " + exception.getMessage(), exception);
                }
            }
        };
        xPrivateKeyConverter = new PrivateKeyConverter<AsymmetricXDHPrivateKey>(){

            @Override
            public AsymmetricXDHPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ProvXDHPrivateKey) {
                    return ((ProvXDHPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricXDHPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify XDH private key: " + exception.getMessage(), exception);
                }
            }
        };
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        String algorithm;
        private final boolean isXdh;
        private final int specificBase;

        public KeyFactorySpi(String string, boolean bl2, int n2) {
            this.algorithm = string;
            this.isXdh = bl2;
            this.specificBase = n2;
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                if (this.isXdh) {
                    GeneralAlgorithm generalAlgorithm = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new ProvXDHPublicKey((AsymmetricXDHPublicKey)xPublicKeyConverter.convertKey(generalAlgorithm, (PublicKey)key));
                }
                GeneralAlgorithm generalAlgorithm = key.getAlgorithm().equals("Ed448") ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519;
                return new ProvEdDSAPublicKey((AsymmetricEdDSAPublicKey)edPublicKeyConverter.convertKey(generalAlgorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                if (this.isXdh) {
                    GeneralAlgorithm generalAlgorithm = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new ProvXDHPrivateKey((AsymmetricXDHPrivateKey)xPrivateKeyConverter.convertKey(generalAlgorithm, (PrivateKey)key));
                }
                GeneralAlgorithm generalAlgorithm = key.getAlgorithm().equals("Ed448") ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519;
                return new ProvEdDSAPrivateKey((AsymmetricEdDSAPrivateKey)edPrivateKeyConverter.convertKey(generalAlgorithm, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            return super.engineGetKeySpec(key, clazz);
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                if (this.specificBase == 0 || this.specificBase == byArray[8]) {
                    switch (byArray[8]) {
                        case 111: {
                            return new ProvXDHPublicKey(byArray);
                        }
                        case 110: {
                            return new ProvXDHPublicKey(byArray);
                        }
                        case 113: {
                            return new ProvEdDSAPublicKey(byArray);
                        }
                        case 112: {
                            return new ProvEdDSAPublicKey(byArray);
                        }
                    }
                    return super.engineGeneratePublic(keySpec);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                    return new ProvXDHPrivateKey(privateKeyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new ProvXDHPrivateKey(privateKeyInfo);
                }
            } else if (aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new ProvEdDSAPrivateKey(privateKeyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new ProvEdDSAPrivateKey(privateKeyInfo);
                }
            }
            throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                    return new ProvXDHPublicKey(subjectPublicKeyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new ProvXDHPublicKey(subjectPublicKeyInfo.getEncoded());
                }
            } else if (aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new ProvEdDSAPublicKey(subjectPublicKeyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new ProvEdDSAPublicKey(subjectPublicKeyInfo.getEncoded());
                }
            }
            throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
        }

        static class Ed25519
        extends KeyFactorySpi {
            public Ed25519() {
                super("Ed25519", false, 112);
            }
        }

        static class Ed448
        extends KeyFactorySpi {
            public Ed448() {
                super("Ed448", false, 113);
            }
        }

        static class EdDSA
        extends KeyFactorySpi {
            public EdDSA() {
                super("EdDSA", false, 0);
            }
        }

        static class X25519
        extends KeyFactorySpi {
            public X25519() {
                super("X25519", true, 110);
            }
        }

        static class X448
        extends KeyFactorySpi {
            public X448() {
                super("X448", true, 111);
            }
        }

        static class XDH
        extends KeyFactorySpi {
            public XDH() {
                super("XDH", true, 0);
            }
        }
    }

    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        private final boolean isXDH;
        private EdEC.Parameters params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider, boolean bl2, EdEC.Parameters parameters) {
            super(parameters != null ? ((GeneralAlgorithm)parameters.getAlgorithm()).getName() : (bl2 ? "XDH" : "EdDSA"));
            this.params = parameters;
            this.provider = bouncyCastleFipsProvider;
            this.isXDH = bl2;
        }

        public void initialize(int n2) {
            this.initialize(n2, this.provider.getDefaultSecureRandom());
        }

        public void initialize(int n2, SecureRandom secureRandom) {
            this.random = secureRandom;
            switch (n2) {
                case 255: 
                case 256: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X25519) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X25519;
                        break;
                    }
                    if (this.params != null && this.params != EdEC.Ed25519) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = EdEC.Ed25519;
                    break;
                }
                case 448: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X448) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X448;
                        break;
                    }
                    if (this.params != null && this.params != EdEC.Ed448) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = EdEC.Ed448;
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown key size.");
                }
            }
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.provider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                this.params = this.getParams(((ECGenParameterSpec)algorithmParameterSpec).getName());
            } else if (!this.isXDH && algorithmParameterSpec instanceof EdDSAParameterSpec) {
                this.params = this.getParams(((EdDSAParameterSpec)algorithmParameterSpec).getCurveName());
            } else if (this.isXDH && algorithmParameterSpec instanceof XDHParameterSpec) {
                this.params = this.getParams(((XDHParameterSpec)algorithmParameterSpec).getCurveName());
            } else {
                if (algorithmParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("parameterSpec cannot be null");
                }
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            this.random = secureRandom;
        }

        private EdEC.Parameters getParams(String string) throws InvalidAlgorithmParameterException {
            if (this.isXDH) {
                if (string.equalsIgnoreCase("X448") || string.equals(EdECObjectIdentifiers.id_X448.getId())) {
                    return EdEC.X448;
                }
                if (string.equalsIgnoreCase("X25519") || string.equals(EdECObjectIdentifiers.id_X25519.getId())) {
                    return EdEC.X25519;
                }
                throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
            }
            if (string.equalsIgnoreCase("Ed448") || string.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
                return EdEC.Ed448;
            }
            if (string.equalsIgnoreCase("Ed25519") || string.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
                return EdEC.Ed25519;
            }
            throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                if (this.params == null) {
                    throw new IllegalStateException("generator not correctly initialized");
                }
                if (this.random == null) {
                    this.random = this.provider.getDefaultSecureRandom();
                }
                this.engine = this.isXDH ? new EdEC.XDHKeyPairGenerator(this.params, this.random) : new EdEC.EdDSAKeyPairGenerator(this.params, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            if (this.isXDH) {
                AsymmetricXDHPublicKey asymmetricXDHPublicKey = (AsymmetricXDHPublicKey)asymmetricKeyPair.getPublicKey();
                AsymmetricXDHPrivateKey asymmetricXDHPrivateKey = (AsymmetricXDHPrivateKey)asymmetricKeyPair.getPrivateKey();
                return new KeyPair(new ProvXDHPublicKey(asymmetricXDHPublicKey), new ProvXDHPrivateKey(asymmetricXDHPrivateKey));
            }
            AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey = (AsymmetricEdDSAPublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey = (AsymmetricEdDSAPrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvEdDSAPublicKey(asymmetricEdDSAPublicKey), new ProvEdDSAPrivateKey(asymmetricEdDSAPrivateKey));
        }
    }

    static class XDHParametersCreator
    implements ParametersCreator {
        private final EdEC.Parameters params;

        XDHParametersCreator(EdEC.Parameters parameters) {
            this.params = parameters;
        }

        public Parameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("unable to take parameter specs");
            }
            return this.params;
        }
    }
}

