/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.spec;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.KTSKeySpec;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;

public class KTSExtractKeySpec
extends KTSKeySpec {
    private final PrivateKey privateKey;
    private final byte[] encapsulation;

    private KTSExtractKeySpec(PrivateKey privateKey, byte[] byArray, String string, int n2, String string2, int n3, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray2) {
        super(string, n2, string2, n3, algorithmParameterSpec, algorithmIdentifier, byArray2);
        this.privateKey = privateKey;
        this.encapsulation = byArray;
    }

    public byte[] getEncapsulation() {
        return Arrays.clone(this.encapsulation);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public static final class Builder {
        private final PrivateKey privateKey;
        private final String algorithmName;
        private final int keySizeInBits;
        private final byte[] encapsulation;
        private final byte[] otherInfo;
        private String macAlgorithm;
        private int macKeySizeInBits;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;

        public Builder(PrivateKey privateKey, byte[] byArray, String string, int n2) {
            this(privateKey, byArray, string, n2, null);
        }

        public Builder(PrivateKey privateKey, byte[] byArray, String string, int n2, byte[] byArray2) {
            this.privateKey = privateKey;
            this.algorithmName = string;
            this.keySizeInBits = n2;
            this.encapsulation = Arrays.clone(byArray);
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KTSKeySpec.KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(byArray2);
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(agreementKDFParametersBuilder);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            this.kdfAlgorithm = algorithmIdentifier;
            return this;
        }

        public Builder withMac(String string, int n2) {
            this.macAlgorithm = string;
            this.macKeySizeInBits = n2;
            if (string != null && n2 <= 0) {
                throw new IllegalArgumentException("macKeySizeInBits must be greater than zero");
            }
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            this.parameterSpec = algorithmParameterSpec;
            return this;
        }

        public KTSExtractKeySpec build() {
            return new KTSExtractKeySpec(this.privateKey, this.encapsulation, this.algorithmName, this.keySizeInBits, this.macAlgorithm, this.macKeySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo);
        }
    }
}

