/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.math.ec.custom.sec;

import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECFieldElement;
import com.aspose.html.internal.ms.core.bc.math.ec.ECLookupTable;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.math.ec.custom.sec.SecT113FieldElement;
import com.aspose.html.internal.ms.core.bc.math.ec.custom.sec.SecT113R1Point;
import com.aspose.html.internal.ms.core.bc.math.internal.Nat128;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;

public class SecT113R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT113R1_DEFAULT_COORDS = 6;
    protected SecT113R1Point infinity = new SecT113R1Point(this, null, null);

    public SecT113R1Curve() {
        super(113, 9, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("003088250CA6E7C7FE649CE85820F7")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("00E8BEE4D3E2260744188BE0E9C723")));
        this.order = new BigInteger(1, Hex.decode("0100000000000000D9CCEC8A39E56F"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT113R1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 113;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT113FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT113R1Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT113R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 113;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        final long[] lArray = new long[n3 * 2 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat128.copy64(((SecT113FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat128.copy64(((SecT113FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 2);
            n4 += 2;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n3;
            }

            public ECPoint lookup(int n2) {
                long[] lArray3 = Nat128.create64();
                long[] lArray2 = Nat128.create64();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    long l2 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 2; ++i3) {
                        int n4 = i3;
                        lArray3[n4] = lArray3[n4] ^ lArray[n32 + i3] & l2;
                        int n5 = i3;
                        lArray2[n5] = lArray2[n5] ^ lArray[n32 + 2 + i3] & l2;
                    }
                    n32 += 4;
                }
                return SecT113R1Curve.this.createRawPoint(new SecT113FieldElement(lArray3), new SecT113FieldElement(lArray2));
            }
        };
    }
}

