/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.math.ec.endo;

import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPointMap;
import com.aspose.html.internal.ms.core.bc.math.ec.ScaleXPointMap;
import com.aspose.html.internal.ms.core.bc.math.ec.endo.GLVEndomorphism;
import com.aspose.html.internal.ms.core.bc.math.ec.endo.GLVTypeBParameters;
import java.math.BigInteger;

public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final ECCurve curve;
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        this.curve = eCCurve;
        this.parameters = gLVTypeBParameters;
        this.pointMap = new ScaleXPointMap(eCCurve.fromBigInteger(gLVTypeBParameters.getBeta()));
    }

    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        int n2 = this.parameters.getBits();
        BigInteger bigInteger2 = this.calculateB(bigInteger, this.parameters.getG1(), n2);
        BigInteger bigInteger3 = this.calculateB(bigInteger, this.parameters.getG2(), n2);
        GLVTypeBParameters gLVTypeBParameters = this.parameters;
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2.multiply(gLVTypeBParameters.getV1A()).add(bigInteger3.multiply(gLVTypeBParameters.getV2A())));
        BigInteger bigInteger5 = bigInteger2.multiply(gLVTypeBParameters.getV1B()).add(bigInteger3.multiply(gLVTypeBParameters.getV2B())).negate();
        return new BigInteger[]{bigInteger4, bigInteger5};
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }

    protected BigInteger calculateB(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        boolean bl2 = bigInteger2.signum() < 0;
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2.abs());
        boolean bl3 = bigInteger3.testBit(n2 - 1);
        bigInteger3 = bigInteger3.shiftRight(n2);
        if (bl3) {
            bigInteger3 = bigInteger3.add(ECConstants.ONE);
        }
        return bl2 ? bigInteger3.negate() : bigInteger3;
    }
}

