/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.IDisposable;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.RenderingOptions;
import com.aspose.html.utils.QB;
import com.aspose.html.utils.QD;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.abI;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Collections.Generic.Stack;
import com.aspose.html.utils.ms.System.Drawing.PointF;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.SizeF;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public abstract class Device<TGraphicContext extends GraphicContext, TRenderingOptions extends RenderingOptions>
implements IDevice {
    private Stack<TGraphicContext> fZK;
    private Stream fZL;
    private final List<Document> fZM = new List();
    boolean fZN;
    private Document fZO;
    private TRenderingOptions euy;
    private int fZP;
    private ICreateStreamProvider fZQ;

    protected DeviceConfiguration Qt() {
        DeviceConfiguration deviceConfiguration = new DeviceConfiguration();
        deviceConfiguration.setPageWritingStrategy(0);
        return deviceConfiguration;
    }

    public final Document Qu() {
        return this.fZO;
    }

    public final void v(Document document) {
        this.fZO = document;
    }

    public final TGraphicContext getGraphicContext() {
        return (TGraphicContext)((GraphicContext)this.fZK.peek());
    }

    public final TRenderingOptions getOptions() {
        return this.euy;
    }

    private void a(TRenderingOptions TRenderingOptions) {
        this.euy = TRenderingOptions;
    }

    public final Stream Qv() {
        QB qB2 = Operators.as(this.fZL, QB.class);
        if (qB2 != null) {
            return qB2.abq();
        }
        return this.fZL;
    }

    protected final Stream getOutputStream() {
        return this.fZL;
    }

    private void Q(Stream stream) {
        this.fZL = stream == null ? null : new QB(stream);
    }

    public final int getPageIndex() {
        return this.fZP;
    }

    public final void setPageIndex(int n2) {
        this.fZP = n2;
    }

    protected final ICreateStreamProvider Qw() {
        return this.fZQ;
    }

    private void a(ICreateStreamProvider iCreateStreamProvider) {
        this.fZQ = iCreateStreamProvider;
    }

    public Device(TRenderingOptions TRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        this.fZK = new Stack();
        this.a(RenderingOptions.a.b(TRenderingOptions));
        this.a(iCreateStreamProvider);
    }

    public Device(TRenderingOptions TRenderingOptions, Stream stream) {
        this(TRenderingOptions, new b(stream));
    }

    public Device(TRenderingOptions TRenderingOptions, String string) {
        this(TRenderingOptions, new abI(string));
    }

    protected abstract TGraphicContext ry();

    @Override
    public abstract void addRect(RectangleF var1);

    @Override
    public void beginDocument(Document document) {
        this.initialize();
        this.v(document);
        this.fZM.addItem(this.Qu());
        if (this.Qt().getPageWritingStrategy() == 0 && !this.fZN) {
            this.Q(this.Qw().getStream(this.Qx(), this.getExtension()));
        }
        if (!this.fZN) {
            this.setPageIndex(0);
            this.fZN = true;
        }
    }

    @Override
    public abstract boolean beginElement(Element var1, RectangleF var2);

    @Override
    public void beginPage(SizeF sizeF) {
        this.setPageIndex(this.getPageIndex() + 1);
        if (this.Qt().getPageWritingStrategy() == 1) {
            this.Q(this.Qw().getStream(this.Qx(), this.getExtension(), this.getPageIndex()));
        }
    }

    @Override
    public abstract void clip(int var1);

    @Override
    public abstract void closePath();

    private String Qx() {
        if ("about:".equals(this.Qu().getLocation().getProtocol())) {
            return "document";
        }
        String string = Path.getFileNameWithoutExtension(Url.a.c(this.Qu().getLocation()));
        return StringExtensions.isNullOrEmpty(string) ? "document" : string;
    }

    @Override
    public abstract void cubicBezierTo(PointF var1, PointF var2, PointF var3);

    @Override
    public final void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void dispose(boolean bl2) {
    }

    @Override
    public abstract void drawImage(byte[] var1, int var2, RectangleF var3);

    @Override
    public void endDocument() {
        this.v(null);
    }

    @Override
    public abstract void endElement(Element var1);

    @Override
    public void endPage() {
        if (this.Qt().getPageWritingStrategy() == 1) {
            IDisposable iDisposable = QD.b.c(this.Qu(), (Stream)Operators.as(this.getOutputStream(), QB.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.Qw().releaseStream(this.Qv());
            this.Q(null);
        }
    }

    @Override
    public abstract void fill(int var1);

    @Override
    public abstract void fillText(String var1, PointF var2);

    @Override
    public void flush() {
        this.fZN = false;
        if (this.Qt().getPageWritingStrategy() == 0) {
            IDisposable iDisposable = QD.b.c(this.fZM, (Stream)Operators.as(this.getOutputStream(), QB.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.Qw().releaseStream(this.Qv());
            this.Q(null);
        } else if (this.getOutputStream() != null && this.Qt().getPageWritingStrategy() == 1) {
            IDisposable iDisposable = QD.b.c(this.fZM.get_Item(this.fZM.size() - 1), (Stream)Operators.as(this.getOutputStream(), QB.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.Qw().releaseStream(this.Qv());
            this.Q(null);
        }
        this.fZM.clear();
    }

    protected abstract String getExtension();

    public void initialize() {
        this.fZK.clear();
        this.fZK.push(this.ry());
    }

    @Override
    public abstract void lineTo(PointF var1);

    @Override
    public abstract void moveTo(PointF var1);

    @Override
    public void restoreGraphicContext() {
        if (this.fZK.size() > 1) {
            this.fZK.pop();
        }
    }

    @Override
    public void saveGraphicContext() {
        this.fZK.push(((GraphicContext)this.fZK.peek()).deepClone());
    }

    @Override
    public abstract void stroke();

    @Override
    public abstract void strokeAndFill(int var1);

    @Override
    public abstract void strokeText(String var1, PointF var2);

    public static class b
    implements ICreateStreamProvider {
        private Stream stream;

        public b(Stream stream) {
            this.stream = stream;
        }

        @Override
        public final void dispose() {
            this.stream = null;
        }

        @Override
        public final Stream getStream(String string, String string2) {
            return this.stream;
        }

        @Override
        public final Stream getStream(String string, String string2, int n2) {
            return this.stream;
        }

        @Override
        public final void releaseStream(Stream stream) {
        }
    }

    public static class a {
        public static <TGraphicContext, TRenderingOptions> Document a(Device device) {
            return device.Qu();
        }

        public static <TGraphicContext, TRenderingOptions> boolean b(Device device) {
            return device.fZN;
        }

        public static <TGraphicContext, TRenderingOptions> int c(Device device) {
            return device.getPageIndex();
        }
    }
}

