/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.IO;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.Decimal;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.IO.EndOfStreamException;
import com.aspose.html.utils.ms.System.IO.IOException;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Decoder;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;

public class BinaryReader
implements IDisposable {
    private Stream b;
    private Encoding c;
    private byte[] d;
    private Decoder e;
    private char[] f;
    private byte[] g;
    private static final int h = 128;
    private boolean i;
    private static final boolean j = false;

    public BinaryReader(Stream stream) {
        this(stream, Encoding.getUTF8());
    }

    public BinaryReader(Stream stream, Encoding encoding) {
        if (stream == null || encoding == null) {
            throw new ArgumentNullException("Input or Encoding is a null reference.");
        }
        if (!stream.canRead()) {
            throw new ArgumentException("The stream doesn't support reading.");
        }
        this.b = stream;
        this.c = encoding;
        this.e = encoding.getDecoder();
        this.d = new byte[Math.max(16, encoding.getMaxByteCount(1))];
    }

    public Stream getBaseStream() {
        return this.b;
    }

    public void close() {
        this.dispose(true);
        this.i = true;
    }

    protected void dispose(boolean bl2) {
        if (bl2 && this.b != null) {
            this.b.close();
        }
        this.i = true;
        this.d = null;
        this.c = null;
        this.b = null;
        this.f = null;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    protected void fillBuffer(int n2) {
        int n3;
        if (n2 > this.d.length) {
            throw new ArgumentOutOfRangeException("numBytes");
        }
        if (this.i) {
            throw new ObjectDisposedException("BinaryReader", "Cannot read from a closed BinaryReader.");
        }
        if (this.b == null) {
            throw new IOException("Stream is invalid");
        }
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = this.b.read(this.d, i2, n2 - i2);
            if (n3 != 0) continue;
            throw new EndOfStreamException();
        }
    }

    public int peekChar() {
        if (this.b == null) {
            if (this.i) {
                throw new ObjectDisposedException("BinaryReader", "Cannot read from a closed BinaryReader.");
            }
            throw new IOException("Stream is invalid");
        }
        if (!this.b.canSeek()) {
            return -1;
        }
        char[] cArray = new char[1];
        int n2 = 0;
        int[] nArray = new int[]{0};
        int n3 = this.a(cArray, 0, 1, nArray);
        n2 = nArray[0];
        this.b.setPosition(this.b.getPosition() - (long)n2);
        if (n3 == 0) {
            return -1;
        }
        return cArray[0];
    }

    public int read() {
        int n2;
        if (this.f == null) {
            this.f = new char[128];
        }
        if ((n2 = this.read(this.f, 0, 1)) == 0) {
            return -1;
        }
        return this.f[0];
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.b == null) {
            if (this.i) {
                throw new ObjectDisposedException("BinaryReader", "Cannot read from a closed BinaryReader.");
            }
            throw new IOException("Stream is invalid");
        }
        if (byArray == null) {
            throw new ArgumentNullException("buffer is null");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index is less than 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count is less than 0");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("buffer is too small");
        }
        int n4 = this.b.read(byArray, n2, n3);
        return n4;
    }

    public int read(char[] cArray, int n2, int n3) {
        if (this.b == null) {
            if (this.i) {
                throw new ObjectDisposedException("BinaryReader", "Cannot read from a closed BinaryReader.");
            }
            throw new IOException("Stream is invalid");
        }
        if (cArray == null) {
            throw new ArgumentNullException("buffer is null");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index is less than 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count is less than 0");
        }
        if (cArray.length - n2 < n3) {
            throw new ArgumentException("buffer is too small");
        }
        int n4 = 0;
        int[] nArray = new int[]{0};
        int n5 = this.a(cArray, n2, n3, nArray);
        n4 = nArray[0];
        return n5;
    }

    private int a(char[] cArray, int n2, int n3, int[] nArray) {
        int n4;
        nArray[0] = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            int n5;
            int n6 = 0;
            do {
                this.a(n6 + 1);
                int n7 = this.b.readByte();
                if (n7 == -1) {
                    return n4;
                }
                this.d[n6++] = (byte)n7;
                nArray[0] = nArray[0] + 1;
            } while ((n5 = this.c.getChars(this.d, 0, n6, cArray, n2 + n4)) == 1 && cArray[n2 + n4] == '\ufffd' || n5 <= 0);
        }
        return n4;
    }

    protected int read7BitEncodedInt() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            byte by2 = this.readByte();
            n3 |= (by2 & 0xFF & 0x7F) << n4;
            n4 += 7;
            if ((by2 & 0xFF & 0x80) == 0) break;
        }
        if (n2 < 5) {
            return n3;
        }
        throw new FormatException("Too many bytes in what should have been a 7 bit encoded Int32.");
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        this.fillBuffer(1);
        return this.d[0];
    }

    public byte readSByte() {
        this.fillBuffer(1);
        return this.d[0];
    }

    public byte[] readBytes(int n2) {
        int n3;
        int n4;
        if (this.b == null) {
            if (this.i) {
                throw new ObjectDisposedException("BinaryReader", "Cannot read from a closed BinaryReader.");
            }
            throw new IOException("Stream is invalid");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count is less than 0");
        }
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = this.b.read(byArray, n3, n2 - n3)) != 0; n3 += n4) {
        }
        if (n3 != n2) {
            byte[] byArray2 = new byte[n3];
            Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public char readChar() {
        char[] cArray = this.readChars(1);
        assert (cArray.length == 1);
        return cArray[0];
    }

    public char[] readChars(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count is less than 0");
        }
        if (n2 == 0) {
            return new char[0];
        }
        char[] cArray = new char[n2];
        int n3 = this.read(cArray, 0, n2);
        if (n3 == 0) {
            throw new EndOfStreamException();
        }
        if (n3 != cArray.length) {
            char[] cArray2 = new char[n3];
            Array.copy(Array.boxing(cArray), 0, Array.boxing(cArray2), 0, n3);
            return cArray2;
        }
        return cArray;
    }

    public char[] readChars(int n2, Encoding encoding) {
        assert (encoding != null);
        Encoding encoding2 = this.c;
        this.c = encoding;
        char[] cArray = this.readChars(n2);
        this.c = encoding2;
        return cArray;
    }

    public Decimal readDecimal() {
        this.fillBuffer(16);
        int n2 = this.d[0] & 0xFF | (this.d[1] & 0xFF) << 8 | (this.d[2] & 0xFF) << 16 | (this.d[3] & 0xFF) << 24;
        int n3 = this.d[4] & 0xFF | (this.d[5] & 0xFF) << 8 | (this.d[6] & 0xFF) << 16 | (this.d[7] & 0xFF) << 24;
        int n4 = this.d[8] & 0xFF | (this.d[9] & 0xFF) << 8 | (this.d[10] & 0xFF) << 16 | (this.d[11] & 0xFF) << 24;
        int n5 = this.d[12] & 0xFF | (this.d[13] & 0xFF) << 8 | (this.d[14] & 0xFF) << 16 | (this.d[15] & 0xFF) << 24;
        int[] nArray = new int[]{n2, n3, n4, n5};
        return new Decimal(nArray);
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readInt64());
    }

    public short readInt16() {
        this.fillBuffer(2);
        return (short)(this.d[0] & 0xFF | (this.d[1] & 0xFF) << 8);
    }

    public int readInt32() {
        this.fillBuffer(4);
        return this.d[0] & 0xFF | (this.d[1] & 0xFF) << 8 | (this.d[2] & 0xFF) << 16 | (this.d[3] & 0xFF) << 24;
    }

    public long readInt64() {
        long l2 = this.readUInt32();
        long l3 = this.readUInt32();
        return l3 << 32 | l2;
    }

    public String readString() {
        int n2;
        int n3 = this.read7BitEncodedInt();
        if (n3 < 0) {
            throw new IOException("Invalid binary file (string len < 0)");
        }
        if (n3 == 0) {
            return StringExtensions.Empty;
        }
        if (this.g == null) {
            this.f = new char[this.c.getMaxByteCount(128)];
            this.g = new byte[128];
        }
        msStringBuilder msStringBuilder2 = null;
        do {
            int n4;
            if ((n4 = this.b.read(this.g, 0, n2 = Math.min(128, n3))) == 0) {
                throw new EndOfStreamException();
            }
            int n5 = this.e.getChars(this.g, 0, n4, this.f, 0);
            if (msStringBuilder2 == null && n2 == n3) {
                return StringExtensions.newString(this.f, 0, n5);
            }
            if (msStringBuilder2 == null) {
                msStringBuilder2 = new msStringBuilder(n3);
            }
            msStringBuilder2.append(this.f, 0, n5);
        } while ((n3 -= n2) > 0);
        return msStringBuilder2.toString();
    }

    public float readSingle() {
        return Float.intBitsToFloat(this.readInt32());
    }

    public int readUInt16() {
        this.fillBuffer(2);
        return this.d[0] & 0xFF | (this.d[1] & 0xFF) << 8;
    }

    public long readUInt32() {
        return (long)this.readInt32() & 0xFFFFFFFFL;
    }

    public long readUInt64() {
        this.fillBuffer(8);
        long l2 = this.d[0] & 0xFF | (this.d[1] & 0xFF) << 8 | (this.d[2] & 0xFF) << 16 | (this.d[3] & 0xFF) << 24;
        long l3 = this.d[4] & 0xFF | (this.d[5] & 0xFF) << 8 | (this.d[6] & 0xFF) << 16 | (this.d[7] & 0xFF) << 24;
        return (l3 & 0xFFFFFFFFL) << 32 | l2 & 0xFFFFFFFFL;
    }

    private void a(int n2) {
        if (this.d.length <= n2) {
            byte[] byArray = new byte[n2];
            Buffer.blockCopy(Array.boxing(this.d), 0, Array.boxing(byArray), 0, this.d.length);
            this.d = byArray;
        }
    }
}

