/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Net.Sockets;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.AsyncCallback;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.IAsyncResult;
import com.aspose.html.utils.ms.System.IO.IOException;
import com.aspose.html.utils.ms.System.Net.Sockets.Socket;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.ObjectDisposedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.Threading.Timeout;
import com.aspose.html.utils.ms.System.Timers.ElapsedEventArgs;
import com.aspose.html.utils.ms.System.Timers.ElapsedEventHandler;
import com.aspose.html.utils.ms.System.Timers.Timer;
import com.aspose.html.utils.ms.lang.Operators;

public class NetworkStream
extends Stream
implements IDisposable {
    private int a;
    private Socket b;
    private boolean c;
    private boolean d;
    private boolean e;
    private boolean f = false;

    public NetworkStream(Socket socket) {
        this(socket, 3, false);
    }

    public NetworkStream(Socket socket, boolean bl2) {
        this(socket, 3, bl2);
    }

    public NetworkStream(Socket socket, int n2) {
        this(socket, n2, false);
    }

    public NetworkStream(Socket socket, int n2, boolean bl2) {
        if (socket == null) {
            throw new ArgumentNullException("socket is null");
        }
        if (socket.getSocketType() != 1) {
            throw new ArgumentException("Socket is not of type Stream", "socket");
        }
        if (!socket.getConnected()) {
            throw new IOException("Not connected");
        }
        if (!socket.getBlocking()) {
            throw new IOException("Operation not allowed on a non-blocking socket.");
        }
        this.b = socket;
        this.c = bl2;
        this.a = n2;
        this.d = this.canRead();
        this.e = this.canWrite();
    }

    @Override
    public boolean canRead() {
        return this.a == 3 || this.a == 1;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canTimeout() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return this.a == 3 || this.a == 2;
    }

    public boolean getDataAvailable() {
        this.a();
        return this.b.getAvailable() > 0;
    }

    @Override
    public long getLength() {
        return this.b.getReceiveBufferSize();
    }

    @Override
    public long getPosition() {
        throw new NotSupportedException();
    }

    @Override
    public void setPosition(long l2) {
        throw new NotSupportedException();
    }

    protected boolean getReadable() {
        return this.d;
    }

    protected void setReadable(boolean bl2) {
        this.d = bl2;
    }

    @Override
    public int getReadTimeout() {
        int n2 = this.b.getReceiveTimeout();
        return n2 <= 0 ? Timeout.Infinite : n2;
    }

    @Override
    public void setReadTimeout(int n2) {
        if (n2 <= 0 && n2 != Timeout.Infinite) {
            throw new ArgumentOutOfRangeException("value", "The value specified is less than or equal to zero and is not Infinite.");
        }
        this.b.setReceiveTimeout(n2);
    }

    protected Socket getSocket() {
        return this.b;
    }

    protected boolean getWriteable() {
        return this.e;
    }

    protected void setWriteable(boolean bl2) {
        this.e = bl2;
    }

    @Override
    public int getWriteTimeout() {
        int n2 = this.b.getSendTimeout();
        return n2 <= 0 ? Timeout.Infinite : n2;
    }

    @Override
    public void setWriteTimeout(int n2) {
        if (n2 <= 0 && n2 != Timeout.Infinite) {
            throw new ArgumentOutOfRangeException("value", "The value specified is less than or equal to zero and is not Infinite");
        }
        this.b.setSendTimeout(n2);
    }

    @Override
    public IAsyncResult beginRead(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        IAsyncResult iAsyncResult;
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("buffer is null");
        }
        int n4 = Array.boxing(byArray).getLength();
        if (n2 < 0 || n2 > n4) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (n3 < 0 || n2 + n3 > n4) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            iAsyncResult = socket.beginReceive(byArray, n2, n3, 0, asyncCallback, object);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("BeginReceive failure", runtimeException);
        }
        return iAsyncResult;
    }

    @Override
    public IAsyncResult beginWrite(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        IAsyncResult iAsyncResult;
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("buffer is null");
        }
        int n4 = Array.boxing(byArray).getLength();
        if (n2 < 0 || n2 > n4) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (n3 < 0 || n2 + n3 > n4) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            iAsyncResult = socket.beginSend(byArray, n2, n3, 0, asyncCallback, object);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("BeginWrite failure", runtimeException);
        }
        return iAsyncResult;
    }

    protected void finalize() {
        this.dispose(false);
    }

    public void close(int n2) {
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("timeout", "timeout is less than -1");
        }
        Timer timer = new Timer();
        timer.Elapsed.add(new ElapsedEventHandler(){

            @Override
            public void invoke(Object object, ElapsedEventArgs elapsedEventArgs) {
                NetworkStream.this.a(object, elapsedEventArgs);
            }
        });
        timer.setInterval(Operators.castToDouble(n2, 9));
        timer.setAutoReset(false);
        timer.setEnabled(true);
    }

    private void a(Object object, ElapsedEventArgs elapsedEventArgs) {
        this.close();
    }

    @Override
    public void dispose(boolean bl2) {
        Socket socket;
        if (this.f) {
            return;
        }
        this.f = true;
        if (this.c && (socket = this.b) != null) {
            socket.close();
        }
        this.b = null;
        this.a = 0;
        if (bl2) {
            GC.suppressFinalize(this);
        }
    }

    @Override
    public int endRead(IAsyncResult iAsyncResult) {
        int n2;
        this.a();
        if (iAsyncResult == null) {
            throw new ArgumentNullException("async result is null");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            n2 = socket.endReceive(iAsyncResult);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("EndRead failure", runtimeException);
        }
        return n2;
    }

    @Override
    public void endWrite(IAsyncResult iAsyncResult) {
        this.a();
        if (iAsyncResult == null) {
            throw new ArgumentNullException("async result is null");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            socket.endSend(iAsyncResult);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("EndWrite failure", runtimeException);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("buffer is null");
        }
        if (n2 < 0 || n2 > Array.boxing(byArray).getLength()) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (n3 < 0 || n2 + n3 > Array.boxing(byArray).getLength()) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            n4 = socket.receive(byArray, n2, n3, 0);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Read failure", runtimeException);
        }
        return n4;
    }

    @Override
    public long seek(long l2, int n2) {
        throw new NotSupportedException();
    }

    @Override
    public void setLength(long l2) {
        throw new NotSupportedException();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.a();
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0 || n2 > Array.boxing(byArray).getLength()) {
            throw new ArgumentOutOfRangeException("offset exceeds the size of buffer");
        }
        if (n3 < 0 || n3 > Array.boxing(byArray).getLength() - n2) {
            throw new ArgumentOutOfRangeException("offset+size exceeds the size of buffer");
        }
        Socket socket = this.b;
        if (socket == null) {
            throw new IOException("Connection closed");
        }
        try {
            int n4 = 0;
            while (n3 - n4 > 0) {
                n4 += socket.send(byArray, n2 + n4, n3 - n4, 0);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Write failure", runtimeException);
        }
    }

    private void a() {
        if (this.f) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }

    public void changeToSSLSocket() {
        this.b.changeToSSL();
    }

    public boolean changeToSSLSocket_internal() {
        return this.b.changeToSSL_internal();
    }
}

