/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.Security.Cryptography.DeriveBytes;
import com.aspose.html.utils.ms.System.Security.Cryptography.HMACSHA1;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.l;

public class Rfc2898DeriveBytes
extends DeriveBytes {
    private static final int a = 1000;
    private int b;
    private byte[] c;
    private HMACSHA1 d;
    private byte[] e;
    private int f;
    private int g;

    public Rfc2898DeriveBytes(String string, byte[] byArray) {
        this(string, byArray, 1000);
    }

    public Rfc2898DeriveBytes(String string, byte[] byArray, int n2) {
        if (string == null) {
            throw new ArgumentNullException("password");
        }
        this.setSalt(byArray);
        this.setIterationCount(n2);
        this.d = new HMACSHA1(Encoding.getUTF8().getBytes(string));
    }

    public Rfc2898DeriveBytes(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("password");
        }
        this.setSalt(byArray2);
        this.setIterationCount(n2);
        this.d = new HMACSHA1(byArray);
    }

    public Rfc2898DeriveBytes(String string, int n2) {
        this(string, n2, 1000);
    }

    public Rfc2898DeriveBytes(String string, int n2, int n3) {
        if (string == null) {
            throw new ArgumentNullException("password");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("saltSize", "invalid salt length");
        }
        this.setSalt(l.a(n2));
        this.setIterationCount(n3);
        this.d = new HMACSHA1(Encoding.getUTF8().getBytes(string));
    }

    public int getIterationCount() {
        return this.b;
    }

    public void setIterationCount(int n2) {
        if (n2 < 1) {
            throw new ArgumentOutOfRangeException("value", "IterationCount < 1");
        }
        this.b = n2;
    }

    public byte[] getSalt() {
        return (byte[])this.c.clone();
    }

    public void setSalt(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("Salt");
        }
        if (byArray.length < 8) {
            throw new ArgumentException("Salt < 8 bytes");
        }
        this.c = (byte[])byArray.clone();
    }

    private byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        byArray[byArray.length - 4] = (byte)(n3 >> 24);
        byArray[byArray.length - 3] = (byte)(n3 >> 16);
        byArray[byArray.length - 2] = (byte)(n3 >> 8);
        byArray[byArray.length - 1] = (byte)n3;
        byte[] byArray3 = byArray2 = this.d.computeHash(byArray);
        for (int i2 = 1; i2 < n2; ++i2) {
            byte[] byArray4 = this.d.computeHash(byArray3);
            for (int i3 = 0; i3 < 20; ++i3) {
                byArray2[i3] = (byte)(byArray2[i3] & 0xFF ^ byArray4[i3] & 0xFF);
            }
            byArray3 = byArray4;
        }
        return byArray2;
    }

    @Override
    public byte[] getBytes(int n2) {
        if (n2 < 1) {
            throw new ArgumentOutOfRangeException("cb");
        }
        int n3 = n2 / 20;
        int n4 = n2 % 20;
        if (n4 != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n5 = 0;
        if (this.f > 0) {
            int n6 = Math.min(20 - this.f, n2);
            Buffer.blockCopy(Array.boxing(this.e), this.f, Array.boxing(byArray), 0, n6);
            if (n6 >= n2) {
                return byArray;
            }
            if ((n3 - 1) * 20 + n6 > byArray.length) {
                --n3;
            }
            this.f = 0;
            n5 = n6;
        }
        byte[] byArray2 = new byte[this.c.length + 4];
        Buffer.blockCopy(Array.boxing(this.c), 0, Array.boxing(byArray2), 0, this.c.length);
        for (int i2 = 1; i2 <= n3; ++i2) {
            this.e = this.a(byArray2, this.b, ++this.g);
            int n7 = i2 == n3 ? byArray.length - n5 : 20;
            Buffer.blockCopy(Array.boxing(this.e), this.f, Array.boxing(byArray), n5, n7);
            n5 += this.f + n7;
            this.f = n7 == 20 ? 0 : n7;
        }
        return byArray;
    }

    @Override
    public void reset() {
        this.e = null;
        this.f = 0;
        this.g = 0;
    }
}

