/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Threading;

import com.aspose.html.utils.TimeSpan;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Threading.EventWaitHandle;
import com.aspose.html.utils.ms.System.Threading.SynchronizationLockException;
import com.aspose.html.utils.ms.System.Threading.ThreadInterruptedException;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class Monitor {
    private static final Hashtable<Object, MonitorInfo> a = new Hashtable(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enter(Object object) {
        if (object == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(object)) {
                    ReentrantLock reentrantLock = a.get(object).a();
                    reentrantLock.lock();
                } else {
                    ReentrantLock reentrantLock = new ReentrantLock();
                    reentrantLock.lock();
                    a.put(object, new MonitorInfo(reentrantLock));
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Monitor.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Object object) {
        if (object == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(object)) {
                    ReentrantLock reentrantLock = a.get(object).a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        reentrantLock.unlock();
                        if (!reentrantLock.hasQueuedThreads() && !reentrantLock.isLocked()) {
                            a.remove(object);
                        }
                    } else {
                        Monitor.a();
                    }
                } else {
                    Monitor.a();
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Monitor.a();
        }
    }

    private static void a() {
        throw new SynchronizationLockException("Object synchronization method was called from an unsynchronized block of code.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pulse(Object object) {
        if (object == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(object)) {
                    MonitorInfo monitorInfo = a.get(object);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        monitorInfo.b().set();
                    } else {
                        Monitor.a();
                    }
                } else {
                    Monitor.a();
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pulseAll(Object object) {
        if (object == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(object)) {
                    MonitorInfo monitorInfo = a.get(object);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        monitorInfo.b().a();
                    } else {
                        Monitor.a();
                    }
                } else {
                    Monitor.a();
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
    }

    public static boolean wait(Object object) {
        return Monitor.wait(object, -1, false);
    }

    public static boolean wait(Object object, int n2) {
        return Monitor.wait(object, n2, false);
    }

    public static boolean wait(Object object, TimeSpan timeSpan) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        return Monitor.wait(object, (int)l2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object object, int n2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("obj");
        }
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        boolean bl3 = true;
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(object)) {
                    MonitorInfo monitorInfo = a.get(object);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        reentrantLock.unlock();
                        bl3 = monitorInfo.b().waitOne(n2);
                        reentrantLock.lock();
                    } else {
                        Monitor.a();
                    }
                } else {
                    ReentrantLock reentrantLock = new ReentrantLock();
                    reentrantLock.lock();
                    a.put(object, new MonitorInfo(reentrantLock));
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
        return bl3;
    }

    public static boolean wait(Object object, TimeSpan timeSpan, boolean bl2) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        return Monitor.wait(object, (int)l2, bl2);
    }

    public static boolean tryEnter(Object object) {
        return Monitor.tryEnter(object, 0);
    }

    public static boolean tryEnter(Object object, TimeSpan timeSpan) {
        long l2 = (long)timeSpan.getTotalMilliseconds();
        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        return Monitor.tryEnter(object, (int)l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryEnter(Object object, int n2) {
        if (object == null) {
            throw new ArgumentNullException("obj");
        }
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        boolean bl2 = true;
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(object)) {
                    MonitorInfo monitorInfo = a.get(object);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    bl2 = reentrantLock.tryLock(n2, TimeUnit.MILLISECONDS);
                } else {
                    ReentrantLock reentrantLock = new ReentrantLock();
                    bl2 = reentrantLock.tryLock(n2, TimeUnit.MILLISECONDS);
                    a.put(object, new MonitorInfo(reentrantLock));
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException.getMessage());
        }
        return bl2;
    }

    static class MonitorInfo {
        private ReentrantLock a;
        private LockEventHandler b;

        private MonitorInfo(ReentrantLock reentrantLock) {
            this.a = reentrantLock;
            this.b = new LockEventHandler(false);
        }

        public ReentrantLock a() {
            return this.a;
        }

        public LockEventHandler b() {
            return this.b;
        }

        class LockEventHandler
        extends EventWaitHandle {
            LockEventHandler(boolean bl2) {
                super(bl2, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean set() {
                Object object = this.syncObj;
                synchronized (object) {
                    this.isReady = true;
                    this.syncObj.notify();
                    this.b().countDown();
                    return true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean a() {
                Object object = this.syncObj;
                synchronized (object) {
                    this.isReady = true;
                    this.syncObj.notifyAll();
                    this.b().countDown();
                    return true;
                }
            }
        }
    }
}

