/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.lang.Operators;
import java.util.HashMap;
import java.util.Map;

public final class RgbEntriesPaletteHash
implements IColorPalette {
    private final IColorPalette a;
    private final OptimizedHasher b;

    public RgbEntriesPaletteHash(IColorPalette iColorPalette) {
        this.b = iColorPalette.getEntriesCount() <= 256 ? new OptimizedHasherUsingMap(iColorPalette) : (iColorPalette.getEntriesCount() <= 65536 ? new OptimizedHasher16(iColorPalette) : new OptimizedHasher32(iColorPalette));
        this.a = iColorPalette;
    }

    @Override
    public int getEntriesCount() {
        return this.a.getEntriesCount();
    }

    @Override
    public int[] getArgb32Entries() {
        return this.a.getArgb32Entries();
    }

    @Override
    public Color[] getEntries() {
        return this.a.getEntries();
    }

    @Override
    public boolean isCompactPalette() {
        return this.a.isCompactPalette();
    }

    @Override
    public int getNearestColorIndex(int n2) {
        return this.b.getNearestColorIndex(n2);
    }

    @Override
    public int getNearestColorIndex(Color color) {
        return this.getNearestColorIndex(color);
    }

    @Override
    public int getArgb32Color(int n2) {
        return this.a.getArgb32Color(n2);
    }

    @Override
    public Color getColor(int n2) {
        return this.a.getColor(n2);
    }

    static class OptimizedHasherUsingMap
    extends OptimizedHasher {
        private final Map<Integer, Integer> a = new HashMap<Integer, Integer>();

        public OptimizedHasherUsingMap(IColorPalette iColorPalette) {
            super(iColorPalette);
        }

        @Override
        public int getNearestColorIndex(int n2) {
            Integer n3 = this.a.get(n2);
            if (n3 == null) {
                n3 = this.Palette.getNearestColorIndex(n2);
                this.a.put(n2, n3);
            }
            return n3;
        }
    }

    static class OptimizedHasher8
    extends OptimizedHasher {
        private final byte[] a = new byte[0x1000000];
        private final byte[] b = new byte[0x1000000];

        public OptimizedHasher8(IColorPalette iColorPalette) {
            super(iColorPalette);
        }

        @Override
        public int getNearestColorIndex(int n2) {
            byte by2;
            int n3 = n2 & 0xFFFFFF;
            if (Operators.castToInt32(this.b[n3], 6) > 0) {
                by2 = this.a[n3];
            } else {
                by2 = Operators.castToByte(this.Palette.getNearestColorIndex(n2), 9);
                this.b[n3] = 1;
                this.a[n3] = by2;
            }
            return Operators.castToInt32(by2, 6);
        }
    }

    static class OptimizedHasher16
    extends OptimizedHasher {
        private final short[] a = new short[0x1000000];
        private final byte[] b = new byte[0x1000000];

        public OptimizedHasher16(IColorPalette iColorPalette) {
            super(iColorPalette);
        }

        @Override
        public int getNearestColorIndex(int n2) {
            short s2;
            int n3 = n2 & 0xFFFFFF;
            if (Operators.castToInt32(this.b[n3], 6) > 0) {
                s2 = this.a[n3];
            } else {
                s2 = Operators.castToInt16(this.Palette.getNearestColorIndex(n2), 9);
                this.b[n3] = 1;
                this.a[n3] = s2;
            }
            return s2;
        }
    }

    static class OptimizedHasher32
    extends OptimizedHasher {
        private final int[] a = new int[0x1000000];
        private final byte[] b = new byte[0x1000000];

        public OptimizedHasher32(IColorPalette iColorPalette) {
            super(iColorPalette);
        }

        @Override
        public int getNearestColorIndex(int n2) {
            int n3;
            int n4 = n2 & 0xFFFFFF;
            if (Operators.castToInt32(this.b[n4], 6) > 0) {
                n3 = this.a[n4];
            } else {
                n3 = this.Palette.getNearestColorIndex(n2);
                this.b[n4] = 1;
                this.a[n4] = n3;
            }
            return n3;
        }
    }

    static abstract class OptimizedHasher {
        protected final IColorPalette Palette;

        protected OptimizedHasher(IColorPalette iColorPalette) {
            this.Palette = iColorPalette;
        }

        public abstract int getNearestColorIndex(int var1);
    }
}

