/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.TiffUtils;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.IChannelExtractor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.IRawDataToColorConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.CachedIccCmm;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccCmm;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import java.awt.Color;

public abstract class TiffCodec {
    private final TiffOptions a;
    private final int b;
    private final int c;
    private final int d;

    protected TiffCodec(TiffOptions tiffOptions, int n2, int n3) {
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        if (tiffOptions.getBitsPerPixel() == 0) {
            throw new IllegalArgumentException("The bits per sample are not defined.");
        }
        if (tiffOptions.getPlanarConfiguration() != 1) {
            throw new IllegalArgumentException("Only contiguous planar configuration is supported at the moment.");
        }
        this.b = tiffOptions.getCompression();
        this.a = tiffOptions;
        this.c = n2;
        this.d = n3;
    }

    public int getWidth() {
        return this.c;
    }

    public int getHeight() {
        return this.d;
    }

    public TiffOptions getOptions() {
        return this.a;
    }

    public int getCompression() {
        return this.b;
    }

    public int getRowsPerStrip() {
        return TiffCodec.getRowsPerStrip(this.a);
    }

    public static int getRowsPerStrip(TiffOptions tiffOptions) {
        int n2 = (int)(tiffOptions.getImageLength() & 0xFFFFFFFFL);
        long l2 = tiffOptions.getRowsPerStrip();
        int n3 = (l2 & 0xFFFFFFFFL) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(l2 & 0xFFFFFFFFL);
        if (n3 == 0 || n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public static int[][] buildLutTable(TiffOptions tiffOptions) {
        int[][] nArray = null;
        switch (tiffOptions.getPhotometric()) {
            case 0: 
            case 1: {
                nArray = TiffCodec.a(tiffOptions);
                break;
            }
            case 3: {
                nArray = TiffCodec.buildPalete(tiffOptions);
            }
        }
        return nArray;
    }

    public IRawDataToColorConverter createConverter(TiffOptions tiffOptions, int[][] nArray, Rectangle rectangle) {
        IRawDataToColorConverter iRawDataToColorConverter = null;
        switch (tiffOptions.getPhotometric()) {
            case 0: 
            case 1: 
            case 3: {
                iRawDataToColorConverter = this.a(tiffOptions, nArray, rectangle.Clone());
                break;
            }
            case 2: {
                iRawDataToColorConverter = this.a(tiffOptions, rectangle.Clone());
                break;
            }
            case 5: {
                if (tiffOptions.getInkNames() != null) break;
                iRawDataToColorConverter = this.b(tiffOptions, rectangle.Clone());
                break;
            }
            case 8: {
                iRawDataToColorConverter = this.c(tiffOptions, rectangle.Clone());
            }
        }
        if (iRawDataToColorConverter == null) {
            iRawDataToColorConverter = new RawConverter(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone());
        }
        return iRawDataToColorConverter;
    }

    public static void reverseBits(byte[] byArray, int n2, int n3) {
        while (n3-- > 0) {
            byArray[n2] = TiffUtils.ByteReversalLUT[byArray[n2] & 0xFF];
            ++n2;
        }
    }

    public static int[][] buildPalete(TiffOptions tiffOptions) {
        int[][] nArrayArray;
        boolean bl2;
        int n2 = tiffOptions.getBitsPerPixel();
        int n3 = 8 / n2;
        int n4 = 256;
        int n5 = 8;
        if (n2 == 16) {
            n3 = 1;
            n4 = 65536;
            n5 = 16;
        }
        int n6 = (int)msMath.pow(2.0, n2);
        IColorPalette iColorPalette = tiffOptions.getPalette();
        if (iColorPalette == null) {
            throw new InvalidOperationException("The color map is not defined in the palettized image.");
        }
        if (iColorPalette.getEntriesCount() != n6) {
            throw new InvalidOperationException("Color map entries must contain 2**(bits per sample) values.");
        }
        int[] nArray = iColorPalette.getArgb32Entries();
        boolean bl3 = bl2 = n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16;
        if (tiffOptions.getPredictor() == 2 || !bl2) {
            nArrayArray = new int[][]{new int[n6]};
            for (int i2 = 0; i2 < n6; ++i2) {
                nArrayArray[0][i2] = nArray[i2];
            }
        } else {
            nArrayArray = new int[n4][];
            int n7 = (1 << n2) - 1;
            for (int i3 = 0; i3 < n4; ++i3) {
                nArrayArray[i3] = new int[n3];
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n8 = i3 >> n5 - (i4 + 1) * n2 & n7;
                    nArrayArray[i3][i4] = nArray[n8];
                }
            }
        }
        return nArrayArray;
    }

    private static int[][] a(TiffOptions tiffOptions) {
        int[][] nArrayArray;
        int n2;
        int n3;
        int n4 = tiffOptions.getBitsPerPixel();
        int n5 = (int)msMath.pow(2.0, n4);
        int n6 = 8 / n4;
        double d2 = 1.0;
        int n7 = 256;
        int n8 = 8;
        int n9 = 255;
        if (n4 == 16) {
            d2 = 257.0;
            n6 = 1;
            n7 = 65536;
            n8 = 16;
            n9 = 65536;
        }
        int[] nArray = new int[n5];
        double d3 = -(255.0 * d2) / (double)(n5 - 1);
        if (tiffOptions.getPhotometric() == 1) {
            n9 = 0;
            d3 *= -1.0;
        }
        double d4 = n9;
        for (int i2 = 0; i2 < n5; ++i2) {
            n3 = (int)(d4 / d2 + 0.5);
            nArray[i2] = n2 = n3 << 8 | n3 << 16 | n3 | 0xFF000000;
            d4 += d3;
        }
        int n10 = n3 = n4 == 1 || n4 == 2 || n4 == 4 || n4 == 8 || n4 == 16 ? 1 : 0;
        if (tiffOptions.getPredictor() == 2 || n3 == 0) {
            nArrayArray = new int[][]{nArray};
        } else {
            nArrayArray = new int[n7][];
            n2 = (1 << n4) - 1;
            for (int i3 = 0; i3 < n7; ++i3) {
                nArrayArray[i3] = new int[n6];
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n11 = i3 >> n8 - (i4 + 1) * n4 & n2;
                    nArrayArray[i3][i4] = nArray[n11];
                }
            }
        }
        return nArrayArray;
    }

    private IRawDataToColorConverter a(TiffOptions tiffOptions, int[][] nArray, Rectangle rectangle) {
        if (nArray == null) {
            throw new ArgumentNullException("lut");
        }
        int[] nArray2 = tiffOptions.getBitsPerSample();
        Converter converter = null;
        if (tiffOptions.getBitsPerPixel() == 16 && nArray2.length == 1) {
            converter = tiffOptions.getPredictor() == 2 ? new LutColorConverter16Predictor(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray[0], rectangle.Clone()) : new LutColorConverter16(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray, rectangle.Clone());
        } else if (tiffOptions.getBitsPerPixel() == 16 && nArray2.length == 2) {
            converter = tiffOptions.getPredictor() == 2 ? new Grayscale2ChannelsColorConverterPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray[0], rectangle.Clone()) : new Grayscale2ChannelsColorConverter(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray, rectangle.Clone());
        } else if (tiffOptions.getBitsPerPixel() == 1 || tiffOptions.getBitsPerPixel() == 2 || tiffOptions.getBitsPerPixel() == 4 || tiffOptions.getBitsPerPixel() == 8) {
            converter = tiffOptions.getPredictor() == 2 ? new LutColorConverterPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray[0], rectangle.Clone()) : new LutColorConverter(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray, rectangle.Clone());
        } else {
            if (nArray2.length > 2) {
                throw new InvalidOperationException(StringExtensions.concat("The grayscale color converter supports 1 or 2 channels. Found ", nArray2.length, " channels instead."));
            }
            converter = new GrayscaleColorConverter(tiffOptions.getBitsPerPixel(), this.c, this.d, nArray[0], rectangle.Clone(), this.a(tiffOptions, nArray2, new double[]{1.0}));
        }
        return converter;
    }

    private IRawDataToColorConverter a(TiffOptions tiffOptions, Rectangle rectangle) {
        Converter converter = null;
        int[] nArray = tiffOptions.getBitsPerSample();
        int n2 = tiffOptions.getBitsPerPixel();
        if (tiffOptions.getAlphaStorage() == 1 && nArray.length >= 4) {
            int n3 = n2;
            converter = n3 >= 32 && n3 % 8 == 0 && (nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8 && (nArray[3] & 0xFFFF) == 8 ? (tiffOptions.getPredictor() == 2 ? new RgbaAssociatedConverter4FastPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone()) : new RgbaAssociatedConverter4Fast(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone())) : new RgbaAssociatedConverter4(n2, this.c, this.d, rectangle.Clone(), this.a(tiffOptions, nArray, this.a(nArray)));
        } else if (nArray.length >= 4 && tiffOptions.getAlphaStorage() == 2) {
            int n4 = n2;
            converter = n4 >= 32 && n4 % 8 == 0 && (nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8 && (nArray[3] & 0xFFFF) == 8 ? (tiffOptions.getPredictor() == 2 ? new RgbConverter4FastPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone()) : new RgbConverter4Fast(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone())) : new RgbConverter4(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone(), this.a(tiffOptions, nArray, this.a(nArray)));
        } else if (nArray.length >= 3) {
            int n5 = n2;
            converter = n5 >= 24 && n5 % 8 == 0 && (nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8 ? (tiffOptions.getPredictor() == 2 ? new RgbConverter3FastPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone()) : new RgbConverter3Fast(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone())) : new RgbConverter3(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone(), this.a(tiffOptions, nArray, this.a(nArray)));
        }
        return converter;
    }

    private IRawDataToColorConverter b(TiffOptions tiffOptions, Rectangle rectangle) {
        Converter converter = null;
        int[] nArray = tiffOptions.getBitsPerSample();
        if ((tiffOptions.getAlphaStorage() == 1 || tiffOptions.getAlphaStorage() == 2) && Array.boxing(nArray).getLength() >= 4) {
            int n2 = tiffOptions.getBitsPerPixel();
            if (n2 >= 32 && n2 % 8 == 0 && (nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8 && (nArray[3] & 0xFFFF) == 8) {
                converter = tiffOptions.getPredictor() == 2 ? new CmykAssociatedConverter4FastPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone()) : new CmykAssociatedConverter4Fast(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone());
            }
        } else if (nArray.length >= 4 && tiffOptions.getAlphaStorage() == 0) {
            int n3 = tiffOptions.getBitsPerPixel();
            converter = n3 >= 32 && n3 % 8 == 0 && (nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8 && (nArray[3] & 0xFFFF) == 8 ? (tiffOptions.getPredictor() == 2 ? new CmykConverter4FastPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone()) : new CmykIccConverter(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone(), tiffOptions.getIccProfile())) : new CmykConverter4(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone(), this.a(tiffOptions, nArray, this.a(nArray)));
        }
        return converter;
    }

    private IRawDataToColorConverter c(TiffOptions tiffOptions, Rectangle rectangle) {
        Converter converter = null;
        int[] nArray = tiffOptions.getBitsPerSample();
        if (nArray.length >= 3 && tiffOptions.getAlphaStorage() == 0) {
            int n2 = tiffOptions.getBitsPerPixel();
            converter = n2 >= 24 && n2 % 8 == 0 && (nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8 ? (tiffOptions.getPredictor() == 2 ? new CielabConverter3FastPredictor(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone()) : new CielabConverter3Fast(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone())) : new CielabConverter3(tiffOptions.getBitsPerPixel(), this.c, this.d, rectangle.Clone(), this.a(tiffOptions, nArray, this.a(nArray)));
        }
        return converter;
    }

    private double[] a(int[] nArray) {
        double[] dArray = new double[nArray.length];
        double d2 = 255.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = 255.0 / (msMath.pow(2.0, nArray[i2]) - 1.0);
        }
        return dArray;
    }

    private IChannelExtractor a(TiffOptions tiffOptions, int[] nArray, double[] dArray) {
        ChannelExtractor channelExtractor = tiffOptions.getPredictor() == 2 ? new ChannelExtractorPredictor(nArray, dArray) : new ChannelExtractor(nArray, dArray);
        return channelExtractor;
    }

    static class RawConverter
    extends Converter {
        protected final int fixedBytesShift;

        protected RawConverter(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle);
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                for (int i3 = 0; i3 < this.fixedBytesShift; ++i3) {
                    int n5 = 24 - 8 * i3;
                    int n6 = nArray2[0];
                    nArray[n6] = nArray[n6] | (byArray[n2++] & 0xFF) << n5;
                }
                nArray2[0] = nArray2[0] + 1;
            }
        }
    }

    static class LutColorConverter16Predictor
    extends Converter {
        private final int[] a;
        private int b;

        public LutColorConverter16Predictor(int n2, int n3, int n4, int[] nArray, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = nArray;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.b = (this.b & 0xFFFF) + (byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = this.a[this.b & 0xFFFF];
                n2 += 2;
            }
        }

        @Override
        protected void onLineStarted() {
            this.b = 0;
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.b = (this.b & 0xFFFF) + (byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
                n2 += 2;
            }
        }
    }

    static class LutColorConverter16
    extends Converter {
        private final int[][] a;

        public LutColorConverter16(int n2, int n3, int n4, int[][] nArray, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = nArray;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
                int[] nArray3 = this.a[n5 & 0xFFFF];
                int n6 = nArray2[0];
                nArray2[0] = n6 + 1;
                nArray[n6] = nArray3[0];
                n2 += 2;
            }
        }
    }

    static class LutColorConverterPredictor
    extends Converter {
        private byte a;
        private final byte b;
        private final int[] c;

        public LutColorConverterPredictor(int n2, int n3, int n4, int[] nArray, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.b = (byte)((1 << n2) - 1);
            this.c = nArray;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            int n5 = this.getBitsCount();
            while (n4 > 0) {
                int n6 = msMath.min(n4, (8 - n3) / n5);
                byte by2 = byArray[n2];
                for (int i2 = 1; i2 <= n6; ++i2) {
                    byte by3 = (byte)((by2 & 0xFF) >> 8 - n3 - i2 * n5 & (this.b & 0xFF));
                    this.a = (byte)((this.a & 0xFF) + (by3 & 0xFF));
                    this.a = (byte)(this.a & this.b);
                    int n7 = nArray2[0];
                    nArray2[0] = n7 + 1;
                    nArray[n7] = this.c[this.a & 0xFF];
                }
                if ((n3 += n6 * n5) == 8) {
                    n3 = 0;
                    ++n2;
                }
                n4 -= n6;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a = 0;
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            int n5 = this.getBitsCount();
            while (n4 > 0) {
                int n6 = msMath.min(n4, (8 - n3) / n5);
                byte by2 = byArray[n2];
                for (int i2 = 1; i2 <= n6; ++i2) {
                    byte by3 = (byte)((by2 & 0xFF) >> 8 - n3 - i2 * n5 & (this.b & 0xFF));
                    this.a = (byte)((this.a & 0xFF) + (by3 & 0xFF));
                    this.a = (byte)(this.a & this.b);
                }
                if ((n3 += n6 * n5) == 8) {
                    n3 = 0;
                    ++n2;
                }
                n4 -= n6;
            }
        }
    }

    static class Grayscale2ChannelsColorConverterPredictor
    extends Converter {
        private final int[] a;
        private int b;

        public Grayscale2ChannelsColorConverterPredictor(int n2, int n3, int n4, int[] nArray, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = nArray;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.b = (this.b & 0xFFFF) + (byArray[n2 + 1] & 0xFF | (byArray[n2] & 0xFF) << 8);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = this.a[this.b & 0xFFFF];
                n2 += 2;
            }
        }

        @Override
        protected void onLineStarted() {
            this.b = 0;
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.b = (this.b & 0xFFFF) + (byArray[n2 + 1] & 0xFF | (byArray[n2] & 0xFF) << 8);
                n2 += 2;
            }
        }
    }

    static class Grayscale2ChannelsColorConverter
    extends Converter {
        private final int[][] a;

        public Grayscale2ChannelsColorConverter(int n2, int n3, int n4, int[][] nArray, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = nArray;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = byArray[n2 + 1] & 0xFF | (byArray[n2] & 0xFF) << 8;
                int[] nArray3 = this.a[n5 & 0xFFFF];
                int n6 = nArray2[0];
                nArray2[0] = n6 + 1;
                nArray[n6] = nArray3[0];
                n2 += 2;
            }
        }
    }

    static class GrayscaleColorConverter
    extends Converter {
        private final int[] a;
        private final IChannelExtractor b;

        public GrayscaleColorConverter(int n2, int n3, int n4, int[] nArray, Rectangle rectangle, IChannelExtractor iChannelExtractor) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = nArray;
            this.b = iChannelExtractor;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray3 = new int[]{n2};
                byte[] byArray2 = this.b.extractChannels(byArray, nArray3);
                n2 = nArray3[0];
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = this.a[byArray2[0] & 0xFF];
            }
        }

        @Override
        protected void onLineStarted() {
            this.b.clear();
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            this.b.skipBytes(byArray, n2, n3, n4);
        }
    }

    static class LutColorConverter
    extends Converter {
        private final int[][] a;

        public LutColorConverter(int n2, int n3, int n4, int[][] nArray, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = nArray;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            int n5 = 0;
            while (n5 < n4) {
                int n6 = msMath.min(n4 - n5, (8 - n3) / this.getBitsCount());
                int[] nArray3 = this.a[byArray[n2] & 0xFF];
                int n7 = n3 / this.getBitsCount();
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = nArray2[0];
                    nArray2[0] = n8 + 1;
                    nArray[n8] = nArray3[n7++];
                }
                n5 += n6;
                if ((n3 += n6 * this.getBitsCount()) != 8) continue;
                n3 = 0;
                ++n2;
            }
        }
    }

    static class CielabConverter3FastPredictor
    extends CielabConverter3Fast {
        private byte a;
        private byte b;
        private byte c;

        public CielabConverter3FastPredictor(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                byte by2 = (byte)(0.5 + 100.0 * (double)(this.a & 0xFF) / 255.0);
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                byte[] byArray2 = new byte[3];
                Buffer.blockCopy(Array.boxing(new byte[]{by2, this.b, this.c}), 0, Array.boxing(byArray2), 0, 3);
                Color color = super.cielab2RGB(byArray2[0], byArray2[1], byArray2[2]);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = ColorHelper.toArgb(color);
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a = 0;
            this.b = 0;
            this.c = 0;
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class CielabConverter3Fast
    extends Converter {
        protected final int fixedBytesShift;
        private double[] a;

        public CielabConverter3Fast(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray[n2] = (byte)(0.5 + 100.0 * (double)(byArray[n2] & 0xFF) / 255.0);
                byte[] byArray2 = new byte[3];
                Buffer.blockCopy(Array.boxing(new byte[]{byArray[n2], byArray[n2 + 1], byArray[n2 + 2]}), 0, Array.boxing(byArray2), 0, 3);
                Color color = this.cielab2RGB(byArray2[0], byArray2[1], byArray2[2]);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = ColorHelper.toArgb(color);
                n2 += this.fixedBytesShift;
            }
        }

        protected Color cielab2RGB(double d2, double d3, double d4) {
            this.a(d2, d3, d4);
            return this.b(this.a[0], this.a[1], this.a[2]);
        }

        private void a(double d2, double d3, double d4) {
            double d5 = (d2 + 16.0) / 116.0;
            double d6 = d3 / 500.0 + d5;
            double d7 = d5 - d4 / 200.0;
            d5 = msMath.pow(d5, 3.0) > 0.008856 ? msMath.pow(d5, 3.0) : (d5 - 0.13793103448275862) / 7.787;
            d6 = msMath.pow(d6, 3.0) > 0.008856 ? msMath.pow(d6, 3.0) : (d6 - 0.13793103448275862) / 7.787;
            d7 = msMath.pow(d7, 3.0) > 0.008856 ? msMath.pow(d7, 3.0) : (d7 - 0.13793103448275862) / 7.787;
            double d8 = 95.047;
            double d9 = 100.0;
            double d10 = 108.883;
            double d11 = d8 * d6;
            double d12 = d9 * d5;
            double d13 = d10 * d7;
            this.a = new double[]{d11, d12, d13};
        }

        private Color b(double d2, double d3, double d4) {
            double d5 = d2 / 100.0;
            double d6 = d3 / 100.0;
            double d7 = d4 / 100.0;
            double d8 = 3.2406 * d5 + -1.5372 * d6 + -0.4986 * d7;
            double d9 = -0.9689 * d5 + 1.8758 * d6 + 0.0415 * d7;
            double d10 = 0.0557 * d5 + -0.204 * d6 + 1.057 * d7;
            d8 = d8 > 0.0031308 ? 1.055 * msMath.pow(d8, 0.4166666666666667) - 0.055 : 12.92 * d8;
            d9 = d9 > 0.0031308 ? 1.055 * msMath.pow(d9, 0.4166666666666667) - 0.055 : 12.92 * d9;
            d10 = d10 > 0.0031308 ? 1.055 * msMath.pow(d10, 0.4166666666666667) - 0.055 : 12.92 * d10;
            double d11 = d8 * 255.0;
            double d12 = d9 * 255.0;
            double d13 = d10 * 255.0;
            if (d11 >= 255.0) {
                d11 = 255.0;
            }
            if (d12 >= 255.0) {
                d12 = 255.0;
            }
            if (d13 >= 255.0) {
                d13 = 255.0;
            }
            if (d11 < 0.0) {
                d11 = 0.0;
            }
            if (d12 < 0.0) {
                d12 = 0.0;
            }
            if (d13 < 0.0) {
                d13 = 0.0;
            }
            return ColorHelper.fromArgb((byte)d11 & 0xFF, (byte)d12 & 0xFF, (byte)d13 & 0xFF);
        }
    }

    static class CielabConverter3
    extends Converter {
        private final IChannelExtractor a;
        private double[] b;

        public CielabConverter3(int n2, int n3, int n4, Rectangle rectangle, IChannelExtractor iChannelExtractor) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = iChannelExtractor;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray3 = new int[]{n2};
                byte[] byArray2 = this.a.extractChannels(byArray, nArray3);
                n2 = nArray3[0];
                byArray2[0] = (byte)(0.5 + 100.0 * (double)(byArray2[0] & 0xFF) / 255.0);
                byte[] byArray3 = new byte[Array.boxing(byArray2).getLength()];
                Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray3), 0, Array.boxing(byArray2).getLength());
                Color color = this.a(byArray3[0], byArray3[1], byArray3[2]);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = ColorHelper.toArgb(color);
            }
        }

        @Override
        protected void onLineStarted() {
            this.a.clear();
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            this.a.skipBytes(byArray, n2, n3, n4);
        }

        private Color a(double d2, double d3, double d4) {
            this.b(d2, d3, d4);
            return this.c(this.b[0], this.b[1], this.b[2]);
        }

        private void b(double d2, double d3, double d4) {
            double d5 = (d2 + 16.0) / 116.0;
            double d6 = d3 / 500.0 + d5;
            double d7 = d5 - d4 / 200.0;
            d5 = msMath.pow(d5, 3.0) > 0.008856 ? msMath.pow(d5, 3.0) : (d5 - 0.13793103448275862) / 7.787;
            d6 = msMath.pow(d6, 3.0) > 0.008856 ? msMath.pow(d6, 3.0) : (d6 - 0.13793103448275862) / 7.787;
            d7 = msMath.pow(d7, 3.0) > 0.008856 ? msMath.pow(d7, 3.0) : (d7 - 0.13793103448275862) / 7.787;
            double d8 = 95.047;
            double d9 = 100.0;
            double d10 = 108.883;
            double d11 = d8 * d6;
            double d12 = d9 * d5;
            double d13 = d10 * d7;
            this.b = new double[]{d11, d12, d13};
        }

        private Color c(double d2, double d3, double d4) {
            double d5 = d2 / 100.0;
            double d6 = d3 / 100.0;
            double d7 = d4 / 100.0;
            double d8 = 3.2406 * d5 + -1.5372 * d6 + -0.4986 * d7;
            double d9 = -0.9689 * d5 + 1.8758 * d6 + 0.0415 * d7;
            double d10 = 0.0557 * d5 + -0.204 * d6 + 1.057 * d7;
            d8 = d8 > 0.0031308 ? 1.055 * msMath.pow(d8, 0.4166666666666667) - 0.055 : 12.92 * d8;
            d9 = d9 > 0.0031308 ? 1.055 * msMath.pow(d9, 0.4166666666666667) - 0.055 : 12.92 * d9;
            d10 = d10 > 0.0031308 ? 1.055 * msMath.pow(d10, 0.4166666666666667) - 0.055 : 12.92 * d10;
            double d11 = d8 * 255.0;
            double d12 = d9 * 255.0;
            double d13 = d10 * 255.0;
            if (d11 >= 255.0) {
                d11 = 255.0;
            }
            if (d12 >= 255.0) {
                d12 = 255.0;
            }
            if (d13 >= 255.0) {
                d13 = 255.0;
            }
            if (d11 < 0.0) {
                d11 = 0.0;
            }
            if (d12 < 0.0) {
                d12 = 0.0;
            }
            if (d13 < 0.0) {
                d13 = 0.0;
            }
            return ColorHelper.fromArgb((byte)d11 & 0xFF, (byte)d12 & 0xFF, (byte)d13 & 0xFF);
        }
    }

    static class CmykAssociatedConverter4Fast
    extends Converter {
        protected final int fixedBytesShift;

        public CmykAssociatedConverter4Fast(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = byArray[n2 + 4];
                if (by2 == 0) {
                    int n5 = nArray2[0];
                    nArray2[0] = n5 + 1;
                    nArray[n5] = 0;
                } else {
                    double d2 = 255.0 / (double)(by2 & 0xFF);
                    int n6 = byArray[n2] & 0xFF;
                    int n7 = byArray[n2 + 1] & 0xFF;
                    int n8 = byArray[n2 + 2] & 0xFF;
                    int n9 = byArray[n2 + 3] & 0xFF;
                    int n10 = (int)(d2 * 255.0 * (1.0 - (double)n6 / 255.0) * (1.0 - (double)n9 / 255.0));
                    int n11 = (int)(d2 * 255.0 * (1.0 - (double)n7 / 255.0) * (1.0 - (double)n9 / 255.0));
                    int n12 = (int)(d2 * 255.0 * (1.0 - (double)n8 / 255.0) * (1.0 - (double)n9 / 255.0));
                    if (n10 > 255) {
                        n10 = 255;
                    }
                    if (n11 > 255) {
                        n11 = 255;
                    }
                    if (n12 > 255) {
                        n12 = 255;
                    }
                    int n13 = nArray2[0];
                    nArray2[0] = n13 + 1;
                    nArray[n13] = (by2 & 0xFF) << 24 | (n10 & 0xFF) << 16 | (n11 & 0xFF) << 8 | n12 & 0xFF;
                }
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class CmykAssociatedConverter4FastPredictor
    extends CmykAssociatedConverter4Fast {
        private byte a;
        private byte b;
        private byte c;
        private byte d;
        private byte e;

        public CmykAssociatedConverter4FastPredictor(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                this.e = (byte)((byArray[n2 + 4] & 0xFF) + (this.e & 0xFF));
                double d2 = 1.0;
                int n5 = (int)(d2 * (255.0 * (1.0 - (double)(this.a & 0xFF) / 255.0) * (1.0 - (double)(this.d & 0xFF) / 255.0)));
                int n6 = (int)(d2 * (255.0 * (1.0 - (double)(this.b & 0xFF) / 255.0) * (1.0 - (double)(this.d & 0xFF) / 255.0)));
                int n7 = (int)(d2 * (255.0 * (1.0 - (double)(this.c & 0xFF) / 255.0) * (1.0 - (double)(this.d & 0xFF) / 255.0)));
                int n8 = (int)(d2 * (255.0 * (1.0 - (double)(this.e & 0xFF) / 255.0) * (1.0 - (double)(this.d & 0xFF) / 255.0)));
                if (n5 > 255) {
                    n5 = 255;
                }
                if (n6 > 255) {
                    n6 = 255;
                }
                if (n7 > 255) {
                    n7 = 255;
                }
                int n9 = nArray2[0];
                nArray2[0] = n9 + 1;
                nArray[n9] = (n8 & 0xFF) << 24 | (n5 & 0xFF) << 16 | (n6 & 0xFF) << 8 | n7 & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                this.e = (byte)((byArray[n2 + 4] & 0xFF) + (this.e & 0xFF));
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void onLineStarted() {
            this.d = 0;
            this.a = 0;
            this.b = 0;
            this.c = 0;
            this.e = 0;
        }
    }

    static class CmykConverter4FastPredictor
    extends CmykConverter4Fast {
        private byte a;
        private byte b;
        private byte c;
        private byte d;
        protected IccCmm converter = new CachedIccCmm();

        public CmykConverter4FastPredictor(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.converter.addXform(IccProfileHelper.getDefaultCmykProfile().getStream());
            this.converter.addXform(IccProfileHelper.getDefaultRGBProfile().getStream());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                double d2 = (double)(this.a & 0xFF) / 255.0;
                double d3 = (double)(this.b & 0xFF) / 255.0;
                double d4 = (double)(this.c & 0xFF) / 255.0;
                double d5 = (double)(this.d & 0xFF) / 255.0;
                double[] dArray = new double[]{d2, d3, d4, d5};
                double[] dArray2 = new double[3];
                this.converter.apply(dArray, dArray2);
                this.a = (byte)(d2 * 255.0);
                this.b = (byte)(d3 * 255.0);
                this.c = (byte)(d4 * 255.0);
                this.d = (byte)(d5 * 255.0);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = (this.a & 0xFF) << 24 | (this.b & 0xFF) << 16 | (this.c & 0xFF) << 8 | this.d & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a = 0;
            this.b = 0;
            this.c = 0;
            this.d = 0;
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class CmykIccConverter
    extends Converter {
        protected IccCmm converter = new CachedIccCmm();

        protected CmykIccConverter(int n2, int n3, int n4, Rectangle rectangle, byte[] byArray) {
            super(n2, n3, n4, rectangle);
            this.converter.addXform(IccProfileHelper.getDefaultCmykProfile().getStream());
            this.converter.addXform(IccProfileHelper.getDefaultRGBProfile().getStream());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                double d2 = (double)(byArray[n2++] & 0xFF) / 255.0;
                double d3 = (double)(byArray[n2++] & 0xFF) / 255.0;
                double d4 = (double)(byArray[n2++] & 0xFF) / 255.0;
                double d5 = (double)(byArray[n2++] & 0xFF) / 255.0;
                double[] dArray = new double[]{d2, d3, d4, d5};
                double[] dArray2 = new double[3];
                this.converter.apply(dArray, dArray2);
                byte by2 = (byte)(dArray2[0] * 255.0);
                byte by3 = (byte)(dArray2[1] * 255.0);
                byte by4 = (byte)(dArray2[2] * 255.0);
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = 0xFF000000 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
            }
        }
    }

    static class CmykConverter4Fast
    extends Converter {
        protected final int fixedBytesShift;

        public CmykConverter4Fast(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = (byte)(255.0 * (1.0 - (double)(byArray[n2] & 0xFF) / 255.0) * (1.0 - (double)(byArray[n2 + 3] & 0xFF) / 255.0));
                byte by3 = (byte)(255.0 * (1.0 - (double)(byArray[n2 + 1] & 0xFF) / 255.0) * (1.0 - (double)(byArray[n2 + 3] & 0xFF) / 255.0));
                byte by4 = (byte)(255.0 * (1.0 - (double)(byArray[n2 + 2] & 0xFF) / 255.0) * (1.0 - (double)(byArray[n2 + 3] & 0xFF) / 255.0));
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = 0xFF000000 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class CmykConverter4
    extends Converter {
        private final IChannelExtractor a;

        public CmykConverter4(int n2, int n3, int n4, Rectangle rectangle, IChannelExtractor iChannelExtractor) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = iChannelExtractor;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray3 = new int[]{n2};
                byte[] byArray2 = this.a.extractChannels(byArray, nArray3);
                n2 = nArray3[0];
                byte by2 = byArray2[0];
                byte by3 = byArray2[1];
                byte by4 = byArray2[2];
                byte by5 = byArray2[3];
                byte by6 = (byte)(255.0 * (1.0 - (double)(by2 & 0xFF) / 255.0) * (1.0 - (double)(by5 & 0xFF) / 255.0));
                byte by7 = (byte)(255.0 * (1.0 - (double)(by3 & 0xFF) / 255.0) * (1.0 - (double)(by5 & 0xFF) / 255.0));
                byte by8 = (byte)(255.0 * (1.0 - (double)(by4 & 0xFF) / 255.0) * (1.0 - (double)(by5 & 0xFF) / 255.0));
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = 0xFF000000 | (by6 & 0xFF) << 16 | (by7 & 0xFF) << 8 | by8 & 0xFF;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a.clear();
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            this.a.skipBytes(byArray, n2, n3, n4);
        }
    }

    static class RgbConverter4
    extends Converter {
        private final IChannelExtractor a;

        public RgbConverter4(int n2, int n3, int n4, Rectangle rectangle, IChannelExtractor iChannelExtractor) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = iChannelExtractor;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray3 = new int[]{n2};
                byte[] byArray2 = this.a.extractChannels(byArray, nArray3);
                n2 = nArray3[0];
                int n5 = byArray2[3] & 0xFF;
                int n6 = byArray2[0] & 0xFF;
                int n7 = byArray2[1] & 0xFF;
                int n8 = byArray2[2] & 0xFF;
                int n9 = nArray2[0];
                nArray2[0] = n9 + 1;
                nArray[n9] = n5 << 24 | n6 << 16 | n7 << 8 | n8;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a.clear();
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            this.a.skipBytes(byArray, n2, n3, n4);
        }
    }

    static class RgbConverter4FastPredictor
    extends RgbConverter4Fast {
        private byte a;
        private byte b;
        private byte c;
        private byte d;

        public RgbConverter4FastPredictor(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = (this.d & 0xFF) << 24 | (this.a & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.c & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a = 0;
            this.b = 0;
            this.c = 0;
            this.d = 0;
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class RgbConverter4Fast
    extends Converter {
        protected final int fixedBytesShift;

        public RgbConverter4Fast(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class RgbConverter3
    extends Converter {
        private final IChannelExtractor a;

        public RgbConverter3(int n2, int n3, int n4, Rectangle rectangle, IChannelExtractor iChannelExtractor) {
            super(n2, n3, n4, rectangle.Clone());
            this.a = iChannelExtractor;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray3 = new int[]{n2};
                byte[] byArray2 = this.a.extractChannels(byArray, nArray3);
                n2 = nArray3[0];
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = 0xFF000000 | (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a.clear();
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            this.a.skipBytes(byArray, n2, n3, n4);
        }
    }

    static class RgbConverter3FastPredictor
    extends RgbConverter3Fast {
        private byte a;
        private byte b;
        private byte c;

        public RgbConverter3FastPredictor(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = 0xFF000000 | (this.a & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.c & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void onLineStarted() {
            this.a = 0;
            this.b = 0;
            this.c = 0;
        }
    }

    static class RgbConverter3Fast
    extends Converter {
        protected final int fixedBytesShift;

        public RgbConverter3Fast(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = nArray2[0];
                nArray2[0] = n5 + 1;
                nArray[n5] = 0xFF000000 | (byArray[n2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF;
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class RgbaAssociatedConverter4
    extends Converter {
        private final double a;
        private final IChannelExtractor b;

        public RgbaAssociatedConverter4(int n2, int n3, int n4, Rectangle rectangle, IChannelExtractor iChannelExtractor) {
            super(n2, n3, n4, rectangle.Clone());
            this.b = iChannelExtractor;
            this.a = (1 << (iChannelExtractor.getChannelBits()[3] & 0xFFFF)) - 1;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray3 = new int[]{n2};
                byte[] byArray2 = this.b.extractChannels(byArray, nArray3);
                n2 = nArray3[0];
                int n5 = byArray2[3];
                if (n5 == 0) {
                    int n6 = nArray2[0];
                    nArray2[0] = n6 + 1;
                    nArray[n6] = 0;
                    continue;
                }
                double d2 = this.a / (double)(n5 & 0xFF);
                int n7 = (int)((double)(byArray2[0] & 0xFF) * d2 + 0.5);
                int n8 = (int)((double)(byArray2[1] & 0xFF) * d2 + 0.5);
                int n9 = (int)((double)(byArray2[2] & 0xFF) * d2 + 0.5);
                if (n7 > 255) {
                    n7 = 255;
                }
                if (n8 > 255) {
                    n8 = 255;
                }
                if (n9 > 255) {
                    n9 = 255;
                }
                if ((n5 & 0xFF) > 255) {
                    n5 = -1;
                }
                int n10 = nArray2[0];
                nArray2[0] = n10 + 1;
                nArray[n10] = (n5 & 0xFF) << 24 | n7 << 16 | n8 << 8 | n9;
            }
        }

        @Override
        protected void onLineStarted() {
            this.b.clear();
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            this.b.skipBytes(byArray, n2, n3, n4);
        }
    }

    static class RgbaAssociatedConverter4FastPredictor
    extends RgbaAssociatedConverter4Fast {
        private byte a;
        private byte b;
        private byte c;
        private byte d;

        public RgbaAssociatedConverter4FastPredictor(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                double d2 = 0.0;
                if (this.d != 0) {
                    d2 = 255.0 / (double)(this.d & 0xFF);
                }
                int n5 = (int)((double)(this.a & 0xFF) * d2 + 0.5);
                int n6 = (int)((double)(this.b & 0xFF) * d2 + 0.5);
                int n7 = (int)((double)(this.c & 0xFF) * d2 + 0.5);
                if (n5 > 255) {
                    n5 = 255;
                }
                if (n6 > 255) {
                    n6 = 255;
                }
                if (n7 > 255) {
                    n7 = 255;
                }
                int n8 = nArray2[0];
                nArray2[0] = n8 + 1;
                nArray[n8] = (this.d & 0xFF) << 24 | n5 << 16 | n6 << 8 | n7;
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.d = (byte)((byArray[n2 + 3] & 0xFF) + (this.d & 0xFF));
                this.a = (byte)((byArray[n2] & 0xFF) + (this.a & 0xFF));
                this.b = (byte)((byArray[n2 + 1] & 0xFF) + (this.b & 0xFF));
                this.c = (byte)((byArray[n2 + 2] & 0xFF) + (this.c & 0xFF));
                n2 += this.fixedBytesShift;
            }
        }

        @Override
        protected void onLineStarted() {
            this.d = 0;
            this.a = 0;
            this.b = 0;
            this.c = 0;
        }
    }

    static class RgbaAssociatedConverter4Fast
    extends Converter {
        protected final int fixedBytesShift;

        public RgbaAssociatedConverter4Fast(int n2, int n3, int n4, Rectangle rectangle) {
            super(n2, n3, n4, rectangle.Clone());
            this.fixedBytesShift = n2 / 8;
        }

        @Override
        protected void fillPixels(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = byArray[n2 + 3];
                if (by2 == 0) {
                    int n5 = nArray2[0];
                    nArray2[0] = n5 + 1;
                    nArray[n5] = 0;
                } else {
                    double d2 = 255.0 / (double)(by2 & 0xFF);
                    int n6 = (int)((double)(byArray[n2] & 0xFF) * d2 + 0.5);
                    int n7 = (int)((double)(byArray[n2 + 1] & 0xFF) * d2 + 0.5);
                    int n8 = (int)((double)(byArray[n2 + 2] & 0xFF) * d2 + 0.5);
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    if (n7 > 255) {
                        n7 = 255;
                    }
                    if (n8 > 255) {
                        n8 = 255;
                    }
                    int n9 = nArray2[0];
                    nArray2[0] = n9 + 1;
                    nArray[n9] = (by2 & 0xFF) << 24 | n6 << 16 | n7 << 8 | n8;
                }
                n2 += this.fixedBytesShift;
            }
        }
    }

    static class ChannelExtractorPredictor
    extends ChannelExtractor {
        private final byte[] a;

        public ChannelExtractorPredictor(int[] nArray, double[] dArray) {
            super(nArray, dArray);
            this.a = new byte[nArray.length];
        }

        @Override
        public void clear() {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = 0;
            }
            super.clear();
        }

        @Override
        protected int getPredictorValue(int n2) {
            return this.a[n2] & 0xFF;
        }

        @Override
        protected void setPredictorValue(int n2, byte by2) {
            this.a[n2] = by2;
        }

        @Override
        public void skipBytes(byte[] byArray, int n2, int n3, int n4) {
            int[] nArray = new int[]{n2};
            this.extractChannels(null, byArray, nArray, n3, n4);
            n2 = nArray[0];
        }
    }

    static class ChannelExtractor
    implements IChannelExtractor {
        private final int[] a;
        private final double[] b;
        private int c;
        private int d;
        private int e;
        private int f;

        public ChannelExtractor(int[] nArray, double[] dArray) {
            if (nArray.length != dArray.length) {
                throw new ArgumentException("The channelBits and channelConversionFunction lengths are different.");
            }
            this.a = nArray;
            this.b = dArray;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.c += nArray[i2] & 0xFFFF;
            }
        }

        @Override
        public void clear() {
            this.d = 0;
            this.e = 0;
            this.f = 0;
        }

        @Override
        public byte[] extractChannels(byte[] byArray, int[] nArray) {
            byte[] byArray2 = new byte[this.a.length];
            this.extractChannels(byArray2, byArray, nArray, this.f, 1);
            return byArray2;
        }

        @Override
        public int[] getChannelBits() {
            return this.a;
        }

        @Override
        public void skipBytes(byte[] byArray, int n2, int n3, int n4) {
            this.f = (n4 * this.c + n3) % 8;
        }

        protected int getPredictorValue(int n2) {
            return 0;
        }

        protected void setPredictorValue(int n2, byte by2) {
        }

        protected void extractChannels(byte[] byArray, byte[] byArray2, int[] nArray, int n2, int n3) {
            int n4 = (1 << 8 - n2) - 1;
            int n5 = n3 * this.c;
            while (n5 > 0) {
                int n6 = 0;
                block1: while (n6 < this.a.length) {
                    int n7;
                    int n8 = this.a[n6] & 0xFFFF;
                    while (this.d < n8) {
                        this.e <<= 8 - n2;
                        this.e |= byArray2[nArray[0]] & 0xFF & n4;
                        n7 = msMath.min(8 - n2, n5);
                        if (n2 + n7 < 8) {
                            this.e >>= 8 - n2 - n7;
                        }
                        this.d += n7;
                        n5 -= n7;
                        if ((n2 += n7) == 8) {
                            n2 = 0;
                            n4 = 255;
                            nArray[0] = nArray[0] + 1;
                            continue;
                        }
                        n4 = (1 << 8 - n2) - 1;
                    }
                    while (this.d >= n8) {
                        n7 = this.e >> this.d - n8 & (1 << n8) - 1;
                        n7 = (int)(this.b[n6] * (double)n7 + 0.5);
                        byte by2 = (byte)(n7 + this.getPredictorValue(n6));
                        this.setPredictorValue(n6, by2);
                        if (byArray != null) {
                            byArray[n6] = by2;
                        }
                        this.d -= n8;
                        if (++n6 == this.a.length) continue block1;
                        n8 = this.a[n6] & 0xFFFF;
                    }
                }
            }
            this.f = n2;
        }
    }

    public static abstract class Converter
    implements IRawDataToColorConverter {
        private final int a;
        private final int b;
        private final int c;
        private final long d;
        private final long e;
        private byte[] f;
        private int g;
        private int h;
        private int i;
        private long j;
        private int k;
        private long l;
        private Rectangle m = new Rectangle();
        private int n;
        private long o;

        protected Converter(int n2, int n3, int n4, Rectangle rectangle) {
            this.b = n3;
            this.c = n4;
            this.e = (8 - this.b * n2 % 8) % 8;
            this.d = (this.b * n2 + 7) / 8 * 8;
            this.a = n2;
            rectangle.CloneTo(this.m);
            this.k = (int)((long)this.m.getTop() * this.d / 8L);
        }

        @Override
        public Point getCurrentLocation() {
            int n2 = (int)(this.o / this.d);
            int n3 = (int)(this.o % this.d / (long)this.a);
            return new Point(n3, n2);
        }

        @Override
        public int getProcessedBytes() {
            return this.n;
        }

        protected int getBitsCount() {
            return this.a;
        }

        @Override
        public boolean hasIncompleteData() {
            return this.f != null;
        }

        @Override
        public void fillLeftValues(int[] nArray, int[] nArray2) {
            if (this.f != null && this.j >= (long)this.a) {
                this.a(nArray, nArray2, this.f, this.h, this.g);
            }
        }

        @Override
        public void setInitialXYPositionExact(int n2, int n3) {
            this.o = (long)n3 * this.d + (long)n2 * (long)this.a;
            this.k = 0;
        }

        @Override
        public void setInitialRowIndex(int n2) {
            this.o = (long)n2 * this.d;
            this.k = (int)(((long)this.m.getTop() - (long)n2) * this.d / 8L);
        }

        @Override
        public void convert(byte[] byArray, int n2, int[] nArray, int[] nArray2) {
            if (nArray == null) {
                throw new ArgumentNullException("colors");
            }
            if (nArray.length - nArray2[0] <= 0) {
                throw new ArgumentOutOfRangeException("colors", "Cannot fill colors. Check the incoming array.");
            }
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("endOffset", "Expected positive integer.");
            }
            int n3 = 0;
            if (this.k > 0) {
                int n4 = msMath.min(n2, this.k);
                n3 += n4;
                this.o += (long)(n4 * 8);
                this.k -= n4;
            } else if (this.f != null) {
                if (this.j < (long)this.a) {
                    int n5;
                    long l2 = ((long)this.a - this.j + 7L) / 8L;
                    long l3 = msMath.min((long)(n2 - n3), l2);
                    long l4 = (long)this.g + l3;
                    byte[] byArray2 = new byte[(int)l4];
                    for (n5 = 0; n5 < this.g; ++n5) {
                        byArray2[n5] = this.f[n5];
                    }
                    while ((long)n5 < l4) {
                        byArray2[n5] = byArray[n3++];
                        ++this.g;
                        ++n5;
                    }
                    this.f = byArray2;
                    this.j += l3 * 8L;
                    if (l3 == l2) {
                        int n6 = (int)(this.o / this.d);
                        int n7 = (int)(this.o % this.d / (long)this.a);
                        int n8 = (int)(this.j / (long)this.a);
                        n8 = this.m.isEmpty() ? msMath.min(this.b - n7, n8) : msMath.min(this.m.getRight() - n7, n8);
                        if (n7 == 0) {
                            this.onLineStarted();
                        }
                        if (n7 < this.m.getLeft()) {
                            int n9 = msMath.min(this.m.getLeft() - n7, n8);
                            this.skipPixels(byArray2, this.h, this.i, n9);
                            this.o += (long)(n9 * this.a);
                        } else {
                            n8 = msMath.min(n8, Array.boxing(nArray).getLength() - nArray2[0]);
                            this.fillPixels(nArray, nArray2, byArray2, this.h, this.i, n8);
                            this.o = (n7 += n8) == this.b ? (long)(++n6) * this.d : (this.o += (long)(n8 * this.a));
                        }
                        if (this.o % 8L > 0L) {
                            --n3;
                        }
                        this.f = null;
                        this.h = 0;
                        this.g = 0;
                        this.i = 0;
                        this.j = 0L;
                    }
                } else {
                    throw new InvalidOperationException("The method Convert was called incorrectly. Method FillLeftValues should be called first as there is some data pending to fill.");
                }
            }
            if (n3 < n2) {
                this.a(nArray, nArray2, byArray, n3, n2);
            }
            this.n += n2;
        }

        protected void onLineStarted() {
        }

        protected void skipPixels(byte[] byArray, int n2, int n3, int n4) {
        }

        protected abstract void fillPixels(int[] var1, int[] var2, byte[] var3, int var4, int var5, int var6);

        private void a(int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3) {
            int n4 = (int)(this.o / this.d);
            int n5 = (int)(this.o % this.d / (long)this.a);
            if (n4 < this.c && n5 < this.b) {
                int n6 = (int)(this.o % 8L);
                long l2 = ((long)n3 - (long)n2) * 8L - (long)n6;
                while (l2 >= (long)this.a && nArray2[0] < nArray.length) {
                    int n7 = 0;
                    if (this.m.isEmpty()) {
                        n7 = msMath.min(this.b - n5, (int)(l2 / (long)this.a));
                    } else {
                        int[] nArray3 = new int[]{n2};
                        int[] nArray4 = new int[]{n5};
                        int[] nArray5 = new int[]{n4};
                        this.a(byArray, nArray3, l2, nArray4, nArray5);
                        n2 = nArray3[0];
                        n5 = nArray4[0];
                        n4 = nArray5[0];
                        if (this.o == this.l) {
                            n6 = (int)(this.o % 8L);
                            n7 = this.a(n2, n3, n6, n5);
                        }
                    }
                    n7 = msMath.min(n7, nArray.length - nArray2[0]);
                    if (n7 > 0) {
                        if (n5 == 0) {
                            this.onLineStarted();
                        }
                        this.fillPixels(nArray, nArray2, byArray, n2, n6, n7);
                        int n8 = (n7 * this.a + n6) / 8;
                        n2 += n8;
                        this.o += (long)(n7 * this.a);
                        if ((n5 += n7) == this.b) {
                            n5 = 0;
                            ++n4;
                            if (this.e > 0L) {
                                ++n2;
                                this.o += this.e;
                            }
                        }
                    }
                    n6 = (int)(this.o % 8L);
                    l2 = (n3 - n2) * 8 - n6;
                }
                this.a(byArray, n2, n3, n6, l2, n5, n4);
            }
        }

        private void a(byte[] byArray, int[] nArray, long l2, int[] nArray2, int[] nArray3) {
            if (this.m.contains(nArray2[0], nArray3[0])) {
                this.l = this.o;
            } else {
                long l3;
                if (this.o >= this.l) {
                    this.l = nArray3[0] < this.m.getTop() ? (long)this.m.getTop() * this.d + (long)(this.m.getLeft() * this.a) : (nArray3[0] >= this.m.getBottom() ? (long)this.c * this.d : (nArray2[0] < this.m.getLeft() ? (long)nArray3[0] * this.d + (long)(this.m.getLeft() * this.a) : (nArray3[0] + 1 == this.m.getBottom() ? (long)this.c * this.d : (long)(nArray3[0] + 1) * this.d + (long)(this.m.getLeft() * this.a))));
                }
                if ((l3 = msMath.min(this.o + l2 / this.d * this.d, this.l)) % this.d + (l2 -= l3 - this.o) >= this.d) {
                    long l4 = this.d - l3 % this.d;
                    long l5 = msMath.min(l3 + l4, this.l);
                    l2 -= l5 - l3;
                    l3 = l5;
                }
                l3 = msMath.min(l3 + l2 / (long)this.a * (long)this.a, this.l);
                int n2 = (int)(l3 / this.d);
                int n3 = (int)(l3 % this.d / (long)this.a);
                int n4 = (int)(l3 / 8L - this.o / 8L);
                nArray[0] = nArray[0] + n4;
                if (n2 >= this.m.getTop() && n2 < this.m.getBottom() && n3 < this.m.getRight() && n3 > 0) {
                    if (nArray3[0] < n2) {
                        int n5 = (int)((l3 - (long)n2 * this.d) / 8L);
                        this.onLineStarted();
                        this.skipPixels(byArray, nArray[0] - n5, 0, n3);
                    } else {
                        if (nArray2[0] == 0) {
                            this.onLineStarted();
                        }
                        this.skipPixels(byArray, nArray[0] - n4, (int)(this.o % 8L), n3 - nArray2[0]);
                    }
                }
                nArray2[0] = n3;
                nArray3[0] = n2;
                this.o = l3;
            }
        }

        private int a(long l2, long l3, long l4, int n2) {
            int n3 = (int)(((l3 - l2) * 8L - l4) / (long)this.a);
            int n4 = this.m.getRight() - n2;
            return msMath.min(n3, n4);
        }

        private void a(byte[] byArray, int n2, int n3, int n4, long l2, int n5, int n6) {
            if (n3 == n2) {
                this.f = null;
                this.g = 0;
                this.h = 0;
                this.i = 0;
                this.j = 0L;
            } else if (l2 < (long)this.a) {
                if (this.m.isEmpty() || this.m.contains(n5, n6) || n6 >= this.m.getTop() && n6 < this.m.getBottom() && n5 < this.m.getRight()) {
                    this.g = (int)((long)n3 - (long)n2);
                    this.f = new byte[this.g];
                    for (int i2 = 0; i2 < this.g; ++i2) {
                        this.f[i2] = byArray[n2++];
                    }
                    this.h = 0;
                    this.i = n4;
                    this.j = l2;
                } else {
                    this.o += l2;
                    this.k = (int)((this.d - this.o % this.d) / 8L);
                    this.f = null;
                    this.g = 0;
                    this.h = 0;
                    this.i = 0;
                    this.j = 0L;
                }
            } else if (l2 >= (long)this.a) {
                this.g = n3;
                this.f = byArray;
                this.h = n2;
                this.i = n4;
                this.j = l2;
            }
        }
    }
}

