/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffCcittReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffDeflateReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffJpegReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffLzwReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffOJpegReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffPackBitsReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffUncompressedReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffCompressions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.utils.ms.lang.Operators;

public class TiffDataReader
implements IRasterImageArgb32PixelLoader {
    private final int a;
    private final int b;
    private final TiffOptions c;
    private final Stream d;
    private final LoadOptions e;
    private final TiffCodecDataReader f;

    public TiffDataReader(TiffOptions tiffOptions, int n2, int n3, Stream stream, LoadOptions loadOptions) {
        if (tiffOptions == null) {
            throw new ArgumentNullException("dataOptions");
        }
        if (stream == null) {
            throw new ArgumentNullException("dataStream");
        }
        this.c = tiffOptions;
        this.d = stream;
        this.a = n2;
        this.b = n3;
        this.e = loadOptions;
        this.f = this.a();
    }

    @Override
    public boolean isRawDataAvailable() {
        return false;
    }

    @Override
    public RawDataSettings getRawDataSettings() {
        throw new NotImplementedException();
    }

    public TiffCodecDataReader getCodec() {
        return this.f;
    }

    @Override
    public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.d.seek(0L, 0);
        TiffStream tiffStream = TiffStreamFactory.getTiffStream(this.d, this.c.getByteOrder());
        this.getCodec().decode(tiffStream, rectangle.Clone(), iPartialArgb32PixelLoader);
    }

    @Override
    public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        throw new NotImplementedException();
    }

    private TiffCodecDataReader a() {
        TiffCodecDataReader tiffCodecDataReader;
        switch (this.c.getCompression()) {
            case 1: {
                tiffCodecDataReader = new TiffUncompressedReader(this.c, this.a, this.b, this.e);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                tiffCodecDataReader = new TiffCcittReader(this.c, this.a, this.b, this.e);
                break;
            }
            case 5: {
                TiffLzwReader tiffLzwReader = new TiffLzwReader(this.c, this.a, this.b, this.e);
                tiffLzwReader.setPredictor(this.c.getPredictor());
                tiffLzwReader.setSamplesPerPixel(Operators.castToInt32(this.c.getSamplesPerPixel(), 8));
                tiffLzwReader.setBitsPerSample(Operators.castToInt32(this.c.getBitsPerSample()[0], 8));
                tiffLzwReader.setRowSize(this.a * Operators.castToInt32(this.c.getSamplesPerPixel(), 8));
                tiffLzwReader.setCodeLength(8);
                tiffCodecDataReader = tiffLzwReader;
                break;
            }
            case 8: 
            case 32946: {
                boolean bl2 = true;
                TiffDeflateReader tiffDeflateReader = new TiffDeflateReader(this.c, this.a, this.b, this.e, true);
                tiffDeflateReader.setPredictor(this.c.getPredictor());
                tiffDeflateReader.setSamplesPerPixel(Operators.castToInt32(this.c.getSamplesPerPixel(), 8));
                tiffDeflateReader.setBitsPerSample(Operators.castToInt32(this.c.getBitsPerSample()[0], 8));
                tiffDeflateReader.setRowSize(this.a * Operators.castToInt32(this.c.getSamplesPerPixel(), 8));
                tiffCodecDataReader = tiffDeflateReader;
                break;
            }
            case 6: {
                tiffCodecDataReader = new TiffOJpegReader(this.c, this.a, this.b);
                break;
            }
            case 7: {
                tiffCodecDataReader = new TiffJpegReader(this.c, this.a, this.b);
                break;
            }
            case 32773: {
                TiffPackBitsReader tiffPackBitsReader = new TiffPackBitsReader(this.c, this.a, this.b, this.e);
                tiffPackBitsReader.setPredictor(this.c.getPredictor());
                tiffPackBitsReader.setSamplesPerPixel(Operators.castToInt32(this.c.getSamplesPerPixel(), 8));
                tiffPackBitsReader.setBitsPerSample(Operators.castToInt32(this.c.getBitsPerSample()[0], 8));
                tiffPackBitsReader.setRowSize(this.a * Operators.castToInt32(this.c.getSamplesPerPixel(), 8));
                tiffCodecDataReader = tiffPackBitsReader;
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException(StringExtensions.concat("codec not supported - Codec #", Enum.getName(TiffCompressions.class, this.c.getCompression())));
            }
        }
        return tiffCodecDataReader;
    }

    public TiffOptions getCompressedDataOptions() {
        return this.c;
    }
}

