/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.utils.ms.System.DoubleExtensions;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.lang.Operators;

public class TiffSRational {
    public static final double EPSILON = 1.0E-6;
    private int a;
    private int b;

    public TiffSRational() {
    }

    public TiffSRational(int n2) {
        this.b = n2;
        this.a = 1;
    }

    public TiffSRational(int n2, int n3) {
        this.b = n2;
        this.a = n3;
    }

    public int getDenominator() {
        return this.a;
    }

    public int getNominator() {
        return this.b;
    }

    public float getValue() {
        return Operators.castToFloat(this.b, 9) / (float)this.a;
    }

    public double getValueD() {
        return Operators.castToDouble(this.b, 9) / (double)this.a;
    }

    public static TiffSRational approximateFraction(double d2, double d3) {
        int n2 = 1;
        int n3 = 1;
        double d4 = n2 / n3;
        while (msMath.abs(d4 - d2) > d3) {
            n2 = d4 < d2 ? ++n2 : Operators.castToInt32(msMath.round(d2 * (double)(++n3)), 14);
            d4 = (double)n2 / Operators.castToDouble(n3, 9);
        }
        return new TiffSRational(n2, n3);
    }

    public static TiffSRational approximateFraction(double d2) {
        return TiffSRational.approximateFraction(d2, 1.0E-6);
    }

    public static TiffSRational approximateFraction(float f2, double d2) {
        int n2 = 1;
        int n3 = 1;
        double d3 = n2 / n3;
        while (msMath.abs(d3 - (double)f2) > d2) {
            n2 = d3 < (double)f2 ? ++n2 : Operators.castToInt32(msMath.round(f2 * (float)(++n3)), 14);
            d3 = (double)n2 / Operators.castToDouble(n3, 9);
        }
        return new TiffSRational(n2, n3);
    }

    public static TiffSRational approximateFraction(float f2) {
        return TiffSRational.approximateFraction(f2, 1.0E-6);
    }

    public String toString() {
        return StringExtensions.concat(DoubleExtensions.toString(this.getValueD(), "F2"), " (", Int32Extensions.toString(this.b), "/", Int32Extensions.toString(this.a), Operators.boxing(Character.valueOf(')')));
    }

    public static boolean op_Equality(TiffSRational tiffSRational, TiffSRational tiffSRational2) {
        boolean bl2 = !ObjectExtensions.referenceEquals(tiffSRational, null) && !ObjectExtensions.referenceEquals(tiffSRational2, null) ? tiffSRational.b == tiffSRational2.b && tiffSRational.a == tiffSRational2.a : ObjectExtensions.referenceEquals(tiffSRational, null) && ObjectExtensions.referenceEquals(tiffSRational2, null);
        return bl2;
    }

    public static boolean op_Inequality(TiffSRational tiffSRational, TiffSRational tiffSRational2) {
        return !TiffSRational.op_Equality(tiffSRational, tiffSRational2);
    }

    public boolean equals(Object object) {
        return TiffSRational.op_Equality(this, Operators.as(object, TiffSRational.class));
    }

    public int hashCode() {
        return this.b ^ this.a;
    }
}

