/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.loaders;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageLoadException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.PngImageException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngFileSettings;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.ColorBackgroundChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.DataChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.FileEndChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.HeaderChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PaletteChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PixelSizeChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.PngChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.TransparencyChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.loaderdescriptor.PngChunkLoaderDescriptor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.chunks.loaderdescriptor.PngChunkRegistry;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.png.coder.PngImagePixelLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IImageLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.utils.ms.lang.Operators;

public class PngLoader
implements IImageLoader {
    private static final double a = 39.3701;
    private static final byte[] b = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public static byte[] getSignature() {
        return b;
    }

    public static boolean readPngSignature(StreamContainer streamContainer) {
        boolean bl2 = true;
        byte[] byArray = new byte[8];
        streamContainer.read(byArray, 0, byArray.length);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (Operators.castToInt32(byArray[i2], 6) == Operators.castToInt32(PngLoader.getSignature()[i2], 6)) continue;
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public Image load(StreamContainer streamContainer, LoadOptions loadOptions) {
        streamContainer.seekBegin();
        boolean bl2 = PngLoader.readPngSignature(streamContainer);
        if (!bl2) {
            throw new ImageLoadException("Not a valid png image.");
        }
        PngStream pngStream = new PngStream(streamContainer.getStream());
        List<PngChunk> list = new List<PngChunk>();
        List<DataChunk> list2 = new List<DataChunk>();
        PngFileSettings pngFileSettings = new PngFileSettings();
        while (streamContainer.getPosition() < streamContainer.getLength()) {
            PngChunkLoaderDescriptor pngChunkLoaderDescriptor = PngChunkRegistry.getFirstSupportedDescriptor(pngStream);
            if (pngChunkLoaderDescriptor != null) {
                Object object;
                Object object2;
                PngChunk pngChunk = pngChunkLoaderDescriptor.load(pngStream);
                list.addItem(pngChunk);
                if (Operators.is(pngChunk, HeaderChunk.class)) {
                    object2 = (HeaderChunk)pngChunk;
                    pngFileSettings.setColorType(((HeaderChunk)object2).getColorType());
                    pngFileSettings.setBitDepth(((HeaderChunk)object2).getBitDepth());
                    pngFileSettings.setHeight(((HeaderChunk)object2).getHeight());
                    pngFileSettings.setWidth(((HeaderChunk)object2).getWidth());
                    pngFileSettings.setInterlace(((HeaderChunk)object2).getInterlaceMethod());
                }
                if (Operators.is(pngChunk, PaletteChunk.class)) {
                    object2 = (PaletteChunk)pngChunk;
                    pngFileSettings.setPalette(((PaletteChunk)object2).getPalette());
                }
                if (Operators.is(pngChunk, TransparencyChunk.class) && (pngFileSettings.getColorType() == 0 || pngFileSettings.getColorType() == 2)) {
                    object2 = (TransparencyChunk)pngChunk;
                    pngFileSettings.setWriteTransparentColor(true);
                    switch (pngFileSettings.getColorType()) {
                        case 0: {
                            object = ((TransparencyChunk)object2).getBytes();
                            if (((byte[])object).length != 2) {
                                throw new FrameworkException(StringExtensions.Empty, new PngImageException("Corrupt transparency chunk."));
                            }
                            short s2 = Operators.castToInt16(Operators.castToInt32(object[0], 6) << 8 & Operators.castToInt32(object[1], 6), 9);
                            pngFileSettings.setTransparentColor(ColorHelper.toArgb(s2, s2, s2));
                            break;
                        }
                        case 2: {
                            object = ((TransparencyChunk)object2).getBytes();
                            if (((byte[])object).length != 6) {
                                throw new FrameworkException(StringExtensions.Empty, new PngImageException("Corrupt transparency chunk."));
                            }
                            short s3 = Operators.castToInt16(Operators.castToInt32(object[0], 6) << 8 & Operators.castToInt32(object[1], 6), 9);
                            short s4 = Operators.castToInt16(Operators.castToInt32((byte)object[2], 6) << 8 & Operators.castToInt32((byte)object[3], 6), 9);
                            short s5 = Operators.castToInt16(Operators.castToInt32((byte)object[4], 6) << 8 & Operators.castToInt32((byte)object[5], 6), 9);
                            pngFileSettings.setTransparentColor(ColorHelper.toArgb(s3, s4, s5));
                            break;
                        }
                        default: {
                            throw new ArgumentOutOfRangeException();
                        }
                    }
                }
                if (Operators.is(pngChunk, ColorBackgroundChunk.class)) {
                    object2 = (ColorBackgroundChunk)pngChunk;
                    pngFileSettings.setBackgroundColor(true);
                    pngFileSettings.setBackgroundColor(((ColorBackgroundChunk)object2).getBackgroundColor());
                }
                if (Operators.is(pngChunk, PixelSizeChunk.class)) {
                    object2 = Operators.as(pngChunk, PixelSizeChunk.class);
                    pngFileSettings.setWriteResolution(true);
                    pngFileSettings.setHorizontalResolution(msMath.ceiling((double)((PixelSizeChunk)object2).getPPUx() / 39.3701));
                    pngFileSettings.setVerticalResolution(msMath.ceiling((double)((PixelSizeChunk)object2).getPPUy() / 39.3701));
                }
                if (Operators.is(pngChunk, DataChunk.class)) {
                    list2.addItem((DataChunk)pngChunk);
                }
                if (!Operators.is(pngChunk, FileEndChunk.class)) continue;
                object2 = new PngImagePixelLoader(pngFileSettings, list.toArray(new PngChunk[0]), loadOptions);
                object = new PngImage(pngFileSettings, (IRasterImageArgb32PixelLoader)object2);
                ((PngImage)object).setPngFileSettings(pngFileSettings);
                return object;
            }
            int n2 = pngStream.read4Bytes();
            pngStream.seek(n2 + 8, 1);
        }
        return null;
    }
}

