/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkBKGD;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkCHRM;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkFactoryMethod;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkGAMA;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkHIST;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkICCP;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIDAT;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIEND;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIHDR;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkITXT;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkOFFS;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkPHYS;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkPLTE;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSBIT;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSPLT;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSRGB;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSTER;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTEXT;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTIME;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTRNS;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkUNKNOWN;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkZTXT;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageOutputStream;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    protected final ImageInfo imgInfo;
    private boolean a = false;
    protected int chunkGroup = -1;
    protected int length = -1;
    protected long offset = 0L;
    private static final Map<String, PngChunkFactoryMethod> b = new HashMap<String, PngChunkFactoryMethod>();

    static void factoryRegister(String string, PngChunkFactoryMethod pngChunkFactoryMethod) {
        b.put(string, pngChunkFactoryMethod);
    }

    public static boolean isKnown(String string) {
        return b.containsKey(string);
    }

    protected PngChunk(String string, ImageInfo imageInfo) {
        this.id = string;
        this.imgInfo = imageInfo;
        this.crit = ChunkHelper.isCritical(string);
        this.pub = ChunkHelper.isPublic(string);
        this.safe = ChunkHelper.isSafeToCopy(string);
    }

    public static PngChunk factory(ChunkRaw chunkRaw, ImageInfo imageInfo) {
        PngChunk pngChunk = PngChunk.factoryFromId(ChunkHelper.toString(chunkRaw.idbytes), imageInfo);
        pngChunk.length = chunkRaw.len;
        pngChunk.parseFromRaw(chunkRaw);
        return pngChunk;
    }

    public static PngChunk factoryFromId(String string, ImageInfo imageInfo) {
        PngChunk pngChunk = null;
        try {
            PngChunkFactoryMethod pngChunkFactoryMethod = b.get(string);
            if (pngChunkFactoryMethod != null) {
                pngChunk = pngChunkFactoryMethod.create(imageInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pngChunk == null) {
            pngChunk = new PngChunkUNKNOWN(string, imageInfo);
        }
        return pngChunk;
    }

    protected final ChunkRaw createEmptyChunk(int n2, boolean bl2) {
        ChunkRaw chunkRaw = new ChunkRaw(n2, ChunkHelper.toBytes(this.id), bl2);
        return chunkRaw;
    }

    public static <T extends PngChunk> T cloneChunk(T t2, ImageInfo imageInfo) {
        PngChunk pngChunk = PngChunk.factoryFromId(t2.id, imageInfo);
        if (pngChunk.getClass() != t2.getClass()) {
            throw new PngjExceptionInternal("bad class cloning chunk: " + pngChunk.getClass() + " " + t2.getClass());
        }
        pngChunk.cloneDataFromRead(t2);
        return (T)pngChunk;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    public final void setChunkGroup(int n2) {
        this.chunkGroup = n2;
    }

    public boolean hasPriority() {
        return this.a;
    }

    public void setPriority(boolean bl2) {
        this.a = bl2;
    }

    final void write(ImageOutputStream imageOutputStream) {
        ChunkRaw chunkRaw = this.createRawChunk();
        if (chunkRaw == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        chunkRaw.writeChunk(imageOutputStream);
    }

    public int getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }

    public abstract ChunkRaw createRawChunk();

    public abstract void parseFromRaw(ChunkRaw var1);

    public abstract void cloneDataFromRead(PngChunk var1);

    public abstract boolean allowsMultiple();

    public abstract ChunkOrderingConstraint getOrderingConstraint();

    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.length + " offset=" + this.offset + ") c=" + this.getClass().getSimpleName();
    }

    static {
        PngChunk.factoryRegister("IDAT", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkIDAT(imageInfo);
            }
        });
        PngChunk.factoryRegister("IHDR", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkIHDR(imageInfo);
            }
        });
        PngChunk.factoryRegister("PLTE", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkPLTE(imageInfo);
            }
        });
        PngChunk.factoryRegister("IEND", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkIEND(imageInfo);
            }
        });
        PngChunk.factoryRegister("tEXt", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkTEXT(imageInfo);
            }
        });
        PngChunk.factoryRegister("iTXt", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkITXT(imageInfo);
            }
        });
        PngChunk.factoryRegister("zTXt", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkZTXT(imageInfo);
            }
        });
        PngChunk.factoryRegister("bKGD", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkBKGD(imageInfo);
            }
        });
        PngChunk.factoryRegister("gAMA", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkGAMA(imageInfo);
            }
        });
        PngChunk.factoryRegister("pHYs", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkPHYS(imageInfo);
            }
        });
        PngChunk.factoryRegister("iCCP", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkICCP(imageInfo);
            }
        });
        PngChunk.factoryRegister("tIME", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkTIME(imageInfo);
            }
        });
        PngChunk.factoryRegister("tRNS", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkTRNS(imageInfo);
            }
        });
        PngChunk.factoryRegister("cHRM", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkCHRM(imageInfo);
            }
        });
        PngChunk.factoryRegister("sBIT", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkSBIT(imageInfo);
            }
        });
        PngChunk.factoryRegister("sRGB", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkSRGB(imageInfo);
            }
        });
        PngChunk.factoryRegister("hIST", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkHIST(imageInfo);
            }
        });
        PngChunk.factoryRegister("sPLT", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkSPLT(imageInfo);
            }
        });
        PngChunk.factoryRegister("oFFs", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkOFFS(imageInfo);
            }
        });
        PngChunk.factoryRegister("sTER", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo imageInfo) {
                return new PngChunkSTER(imageInfo);
            }
        });
    }

    public static enum ChunkOrderingConstraint {
        NONE,
        BEFORE_PLTE_AND_IDAT,
        AFTER_PLTE_BEFORE_IDAT,
        BEFORE_IDAT,
        NA;


        public boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT;
        }
    }
}

