/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cms;

import com.aspose.html.utils.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.utils.ms.core.bc.asn1.cms.EncryptedContentInfo;
import com.aspose.html.utils.ms.core.bc.asn1.cms.EncryptedData;
import com.aspose.html.utils.ms.core.bc.cms.CMSException;
import com.aspose.html.utils.ms.core.bc.cms.CMSTypedStream;
import com.aspose.html.utils.ms.core.bc.cms.CMSUtils;
import com.aspose.html.utils.ms.core.bc.operator.InputDecryptor;
import com.aspose.html.utils.ms.core.bc.operator.InputDecryptorProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CMSEncryptedData {
    private ContentInfo contentInfo;
    private EncryptedData encryptedData;

    public CMSEncryptedData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        this.encryptedData = EncryptedData.getInstance(contentInfo.getContent());
    }

    public byte[] getContent(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            return CMSUtils.streamToByteArray(this.getContentStream(inputDecryptorProvider).getContentStream());
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse internal stream: " + iOException.getMessage(), iOException);
        }
    }

    public CMSTypedStream getContentStream(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            EncryptedContentInfo encryptedContentInfo = this.encryptedData.getEncryptedContentInfo();
            InputDecryptor inputDecryptor = inputDecryptorProvider.get(encryptedContentInfo.getContentEncryptionAlgorithm());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets());
            return new CMSTypedStream(encryptedContentInfo.getContentType(), inputDecryptor.getInputStream(byteArrayInputStream));
        }
        catch (Exception exception) {
            throw new CMSException("unable to create stream: " + exception.getMessage(), exception);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }
}

