/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.DERNull;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.X509ObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.util.Properties;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AsymmetricRSAKey
implements AsymmetricKey {
    protected static final AlgorithmIdentifier DEF_ALG_ID = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
    private static final Set<ASN1ObjectIdentifier> rsaOids = new HashSet<ASN1ObjectIdentifier>(4);
    private final boolean approvedModeOnly;
    private final KeyMarker keyMarker;
    private Algorithm algorithm;
    private BigInteger modulus;
    protected final AlgorithmIdentifier rsaAlgIdentifier;
    private static WeakHashMap<BigInteger, WeakReference<KeyMarker>> markers;

    AsymmetricRSAKey(Algorithm algorithm, BigInteger bigInteger) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.keyMarker = AsymmetricRSAKey.getKeyMarker(bigInteger);
        this.modulus = this.keyMarker.modulus;
        this.rsaAlgIdentifier = DEF_ALG_ID;
    }

    AsymmetricRSAKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (!rsaOids.contains(aSN1ObjectIdentifier)) {
            throw new IllegalArgumentException("Unknown algorithm type: " + aSN1ObjectIdentifier);
        }
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.rsaAlgIdentifier = algorithmIdentifier;
        this.keyMarker = AsymmetricRSAKey.getKeyMarker(bigInteger);
        this.modulus = this.keyMarker.modulus;
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            this.keyMarker.canBeUsed(Usage.SIGN_OR_VERIFY);
        } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_RSAES_OAEP)) {
            this.keyMarker.canBeUsed(Usage.ENCRYPT_OR_DECRYPT);
        }
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public boolean canBeUsed(Usage usage) {
        return Properties.isOverrideSet("com.aspose.html.utils.ms.core.bc.rsa.allow_multi_use") || this.keyMarker.canBeUsed(usage);
    }

    protected void zeroize() {
        this.algorithm = null;
        this.modulus = null;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    static synchronized boolean isAlreadySeen(BigInteger bigInteger) {
        return markers.containsKey(bigInteger);
    }

    static synchronized KeyMarker getKeyMarker(BigInteger bigInteger) {
        KeyMarker keyMarker = null;
        WeakReference<KeyMarker> weakReference = markers.get(bigInteger);
        if (weakReference != null) {
            keyMarker = (KeyMarker)weakReference.get();
        }
        if (keyMarker != null) {
            return keyMarker;
        }
        keyMarker = new KeyMarker(bigInteger);
        weakReference = new WeakReference<KeyMarker>(keyMarker);
        markers.put(bigInteger, weakReference);
        return keyMarker;
    }

    static {
        rsaOids.add(PKCSObjectIdentifiers.rsaEncryption);
        rsaOids.add(X509ObjectIdentifiers.id_ea_rsa);
        rsaOids.add(PKCSObjectIdentifiers.id_RSAES_OAEP);
        rsaOids.add(PKCSObjectIdentifiers.id_RSASSA_PSS);
        rsaOids.add(PKCSObjectIdentifiers.id_rsa_KEM);
        markers = new WeakHashMap();
    }

    static class KeyMarker {
        private final AtomicReference<Usage> keyUsage = new AtomicReference<Object>(null);
        private final BigInteger modulus;

        KeyMarker(BigInteger bigInteger) {
            this.modulus = bigInteger;
        }

        public boolean canBeUsed(Usage usage) {
            return this.keyUsage.compareAndSet(null, usage) || this.keyUsage.get().equals((Object)usage) || this.keyUsage.compareAndSet(Usage.SIGN_OR_VERIFY, usage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Usage {
        SIGN_OR_VERIFY,
        ENCRYPT_OR_DECRYPT;

    }
}

