/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipherMode;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Mode {
    ECB(BlockCipherMode.ECB),
    CBC(BlockCipherMode.CBC),
    CFB8(BlockCipherMode.CFB8),
    CFB16(BlockCipherMode.CFB16),
    CFB32(BlockCipherMode.CFB32),
    CFB64(BlockCipherMode.CFB64),
    CFB128(BlockCipherMode.CFB128),
    OFB8(BlockCipherMode.OFB8),
    OFB16(BlockCipherMode.OFB16),
    OFB32(BlockCipherMode.OFB32),
    OFB64(BlockCipherMode.OFB64),
    OFB128(BlockCipherMode.OFB128),
    CTR(BlockCipherMode.CTR),
    GCM(BlockCipherMode.GCM),
    CCM(BlockCipherMode.CCM),
    OCB(BlockCipherMode.OCB),
    EAX(BlockCipherMode.EAX),
    CMAC(BlockCipherMode.CMAC),
    GMAC(BlockCipherMode.GMAC),
    WRAP(BlockCipherMode.WRAP),
    WRAPPAD(BlockCipherMode.WRAPPAD);

    private final BlockCipherMode baseMode;

    private Mode(BlockCipherMode blockCipherMode) {
        this.baseMode = blockCipherMode;
    }

    BlockCipherMode getBaseMode() {
        return this.baseMode;
    }

    int checkIv(byte[] byArray, int n2) {
        switch (this.baseMode) {
            case CBC: 
            case CFB128: 
            case CFB8: 
            case CFB16: 
            case CFB32: 
            case CFB64: 
            case OFB128: 
            case OFB8: 
            case OFB16: 
            case OFB32: 
            case OFB64: {
                if (byArray == null || byArray.length == n2) break;
                throw new IllegalArgumentException("IV must be " + n2 + " bytes long");
            }
            case CTR: {
                if (byArray == null || byArray.length <= n2) break;
                throw new IllegalArgumentException("CTR IV must be less than " + n2 + " bytes long");
            }
        }
        return n2;
    }

    byte[] createDefaultIvIfNecessary(int n2, SecureRandom secureRandom) {
        if (this.baseMode.expectsIV()) {
            return this.baseMode.createDefaultIV(n2, secureRandom);
        }
        return null;
    }

    byte[] createIvIfNecessary(int n2, SecureRandom secureRandom) {
        if (this.baseMode.expectsIV()) {
            byte[] byArray = new byte[n2];
            if (secureRandom != null) {
                secureRandom.nextBytes(byArray);
            } else {
                CryptoServicesRegistrar.getSecureRandom().nextBytes(byArray);
            }
            return byArray;
        }
        return null;
    }
}

