/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.general.EcKeyGenerationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.utils.ms.core.bc.crypto.internal.AsymmetricCipherKeyPairGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.utils.ms.core.bc.math.ec.ECMultiplier;
import com.aspose.html.utils.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.utils.ms.core.bc.math.ec.FixedPointCombMultiplier;
import com.aspose.html.utils.ms.core.bc.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

class EcKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    EcDomainParameters params;
    SecureRandom random;

    EcKeyPairGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        EcKeyGenerationParameters ecKeyGenerationParameters = (EcKeyGenerationParameters)keyGenerationParameters;
        this.random = ecKeyGenerationParameters.getRandom();
        this.params = ecKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            throw new IllegalArgumentException("No random provided where one required.");
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n2 = bigInteger2.bitLength();
        int n3 = n2 >>> 2;
        while ((bigInteger = new BigInteger(n2, this.random)).compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n3) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new EcPublicKeyParameters(eCPoint, this.params), new EcPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

