/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.utils.ms.core.bc.crypto.general.MD5Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.PBEParametersGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenSSLPBEParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Digest digest = new MD5Digest();

    public OpenSSLPBEParametersGenerator(T t2) {
        super(t2);
    }

    public void init(byte[] byArray, byte[] byArray2) {
        super.init(byArray, byArray2, 1);
    }

    private byte[] generateDerivedKey(int n2) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            this.digest.doFinal(byArray, 0);
            int n4 = n2 > byArray.length ? byArray.length : n2;
            System.arraycopy(byArray, 0, byArray2, n3, n4);
            n3 += n4;
            if ((n2 -= n4) == 0) break;
            this.digest.reset();
            this.digest.update(byArray, 0, byArray.length);
        }
        return byArray2;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2) {
        byte[] byArray = this.generateDerivedKey(n2 /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2, int n3) {
        byte[] byArray = this.generateDerivedKey((n2 /= 8) + (n3 /= 8));
        return new ParametersWithIV(new KeyParameterImpl(Arrays.copyOfRange(byArray, 0, n2)), byArray, n2, n3);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n2) {
        return this.generateDerivedParameters(n2);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n2) {
        return this.generateDerivedKey(n2);
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n2, int n3) {
        byte[] byArray = this.generateDerivedKey(n2 + n3);
        return new byte[][]{Arrays.copyOfRange(byArray, 0, n2), Arrays.copyOfRange(byArray, n2, n2 + n3)};
    }
}

