/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.mime.smime;

import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.mime.CanonicalOutputStream;
import com.aspose.html.utils.ms.core.bc.mime.Headers;
import com.aspose.html.utils.ms.core.bc.mime.MimeContext;
import com.aspose.html.utils.ms.core.bc.mime.MimeMultipartContext;
import com.aspose.html.utils.ms.core.bc.mime.MimeParserContext;
import com.aspose.html.utils.ms.core.bc.mime.smime.SMimeParserContext;
import com.aspose.html.utils.ms.core.bc.mime.smime.SMimeUtils;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.utils.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.utils.ms.core.bc.util.io.TeeInputStream;
import com.aspose.html.utils.ms.core.bc.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class SMimeMultipartContext
implements MimeMultipartContext {
    private final SMimeParserContext parserContext;
    private DigestCalculator[] calculators;

    public SMimeMultipartContext(MimeParserContext mimeParserContext, Headers headers) {
        this.parserContext = (SMimeParserContext)mimeParserContext;
        this.calculators = this.createDigestCalculators(headers);
    }

    DigestCalculator[] getDigestCalculators() {
        return this.calculators;
    }

    OutputStream getDigestOutputStream() {
        if (this.calculators.length == 1) {
            return this.calculators[0].getOutputStream();
        }
        OutputStream outputStream = this.calculators[0].getOutputStream();
        for (int i2 = 1; i2 < this.calculators.length; ++i2) {
            outputStream = new TeeOutputStream(this.calculators[i2].getOutputStream(), outputStream);
        }
        return outputStream;
    }

    private DigestCalculator[] createDigestCalculators(Headers headers) {
        try {
            Map<String, String> map = headers.getContentTypeAttributes();
            String string = map.get("micalg");
            if (string == null) {
                throw new IllegalStateException("No micalg field on content-type header");
            }
            String[] stringArray = string.substring(string.indexOf(61) + 1).split(",");
            DigestCalculator[] digestCalculatorArray = new DigestCalculator[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = SMimeUtils.lessQuotes(stringArray[i2]).trim();
                digestCalculatorArray[i2] = this.parserContext.getDigestCalculatorProvider().get(new AlgorithmIdentifier(SMimeUtils.getDigestOID(string2)));
            }
            return digestCalculatorArray;
        }
        catch (OperatorCreationException operatorCreationException) {
            return null;
        }
    }

    public MimeContext createContext(final int n2) throws IOException {
        return new MimeContext(){

            public InputStream applyContext(Headers headers, InputStream inputStream) throws IOException {
                if (n2 == 0) {
                    OutputStream outputStream = SMimeMultipartContext.this.getDigestOutputStream();
                    headers.dumpHeaders(outputStream);
                    outputStream.write(13);
                    outputStream.write(10);
                    return new TeeInputStream(inputStream, new CanonicalOutputStream(SMimeMultipartContext.this.parserContext, headers, outputStream));
                }
                return inputStream;
            }
        };
    }

    public InputStream applyContext(Headers headers, InputStream inputStream) throws IOException {
        return inputStream;
    }
}

