/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.pkcs;

import com.aspose.html.utils.ms.core.bc.asn1.pkcs.MacData;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCS12PBEParams;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.DigestInfo;
import com.aspose.html.utils.ms.core.bc.operator.MacCalculator;
import com.aspose.html.utils.ms.core.bc.pkcs.PKCS12MacCalculatorBuilder;
import com.aspose.html.utils.ms.core.bc.pkcs.PKCSException;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder) {
        this.builder = pKCS12MacCalculatorBuilder;
    }

    public MacData build(char[] cArray, byte[] byArray) throws PKCSException {
        Object object;
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(cArray);
            object = macCalculator.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            throw new PKCSException("unable to process data: " + exception.getMessage(), exception);
        }
        object = macCalculator.getAlgorithmIdentifier();
        DigestInfo digestInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(((AlgorithmIdentifier)object).getParameters());
        return new MacData(digestInfo, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
    }
}

