/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.compression.zlib;

import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.core.compression.zlib.Adler;
import com.aspose.html.utils.ms.core.compression.zlib.ZlibException;
import com.aspose.html.utils.ms.core.compression.zlib.h;
import com.aspose.html.utils.ms.core.compression.zlib.q;

public final class ZlibCodec {
    public byte[] InputBuffer;
    public int NextIn;
    public int AvailableBytesIn;
    public long TotalBytesIn;
    public byte[] OutputBuffer;
    public int NextOut;
    public int AvailableBytesOut;
    public long TotalBytesOut;
    public String Message;
    h a;
    q b;
    long c;
    public int CompressLevel = 6;
    public int WindowBits = 15;
    public int Strategy = 0;

    public int getAdler32() {
        return (int)(this.c & 0xFFFFFFFFL);
    }

    public ZlibCodec() {
    }

    public ZlibCodec(int n2) {
        if (n2 == 0) {
            int n3 = this.initializeDeflate();
            if (n3 != 0) {
                throw new ZlibException("Cannot initialize for deflate.");
            }
        } else if (n2 == 1) {
            int n4 = this.initializeInflate();
            if (n4 != 0) {
                throw new ZlibException("Cannot initialize for inflate.");
            }
        } else {
            throw new ZlibException("Invalid ZlibStreamFlavor.");
        }
    }

    public int initializeInflate() {
        return this.initializeInflate(this.WindowBits);
    }

    public int initializeInflate(boolean bl2) {
        return this.initializeInflate(this.WindowBits, bl2);
    }

    public int initializeInflate(int n2) {
        this.WindowBits = n2;
        return this.initializeInflate(n2, true);
    }

    public int initializeInflate(int n2, boolean bl2) {
        this.WindowBits = n2;
        if (this.a != null) {
            throw new ZlibException("You may not call InitializeInflate() after calling InitializeDeflate().");
        }
        this.b = new q(bl2);
        return this.b.a(this, n2);
    }

    public int inflate(int n2) {
        if (this.b == null) {
            throw new ZlibException("No Inflate State!");
        }
        return this.b.a(n2);
    }

    public int endInflate() {
        if (this.b == null) {
            throw new ZlibException("No Inflate State!");
        }
        int n2 = this.b.c();
        this.b = null;
        return n2;
    }

    public int syncInflate() {
        if (this.b == null) {
            throw new ZlibException("No Inflate State!");
        }
        return this.b.d();
    }

    public int initializeDeflate() {
        return this.a(true);
    }

    public int initializeDeflate(int n2) {
        this.CompressLevel = n2;
        return this.a(true);
    }

    public int initializeDeflate(int n2, boolean bl2) {
        this.CompressLevel = n2;
        return this.a(bl2);
    }

    public int initializeDeflate(int n2, int n3) {
        this.CompressLevel = n2;
        this.WindowBits = n3;
        return this.a(true);
    }

    public int initializeDeflate(int n2, int n3, boolean bl2) {
        this.CompressLevel = n2;
        this.WindowBits = n3;
        return this.a(bl2);
    }

    private int a(boolean bl2) {
        if (this.b != null) {
            throw new ZlibException("You may not call InitializeDeflate() after calling InitializeInflate().");
        }
        this.a = new h();
        this.a.b(bl2);
        return this.a.a(this, this.CompressLevel, this.WindowBits, this.Strategy);
    }

    public int deflate(int n2) {
        if (this.a == null) {
            throw new ZlibException("No Deflate State!");
        }
        return this.a.e(n2);
    }

    public int endDeflate() {
        if (this.a == null) {
            throw new ZlibException("No Deflate State!");
        }
        this.a = null;
        return 0;
    }

    public void resetDeflate() {
        if (this.a == null) {
            throw new ZlibException("No Deflate State!");
        }
        this.a.h();
    }

    public int setDeflateParams(int n2, int n3) {
        if (this.a == null) {
            throw new ZlibException("No Deflate State!");
        }
        return this.a.c(n2, n3);
    }

    public int setDictionary(byte[] byArray) {
        if (this.b != null) {
            return this.b.a(byArray);
        }
        if (this.a != null) {
            return this.a.a(byArray);
        }
        throw new ZlibException("No Inflate or Deflate state!");
    }

    void a() {
        int n2 = this.a.e;
        if (n2 > this.AvailableBytesOut) {
            n2 = this.AvailableBytesOut;
        }
        if (n2 == 0) {
            return;
        }
        if (this.a.c.length <= this.a.d || this.OutputBuffer.length <= this.NextOut || this.a.c.length < this.a.d + n2 || this.OutputBuffer.length < this.NextOut + n2) {
            throw new ZlibException(StringExtensions.format("Invalid State. (pending.Length={0}, pendingCount={1})", this.a.c.length, this.a.e));
        }
        System.arraycopy(this.a.c, this.a.d, this.OutputBuffer, this.NextOut, n2);
        this.NextOut += n2;
        this.a.d += n2;
        this.TotalBytesOut += (long)n2;
        this.AvailableBytesOut -= n2;
        this.a.e -= n2;
        if (this.a.e == 0) {
            this.a.d = 0;
        }
    }

    int a(byte[] byArray, int n2, int n3) {
        int n4 = this.AvailableBytesIn;
        if (n4 > n3) {
            n4 = n3;
        }
        if (n4 == 0) {
            return 0;
        }
        this.AvailableBytesIn -= n4;
        if (this.a.g()) {
            this.c = Adler.adler32(this.c, this.InputBuffer, this.NextIn, n4);
        }
        System.arraycopy(this.InputBuffer, this.NextIn, byArray, n2, n4);
        this.NextIn += n4;
        this.TotalBytesIn += (long)n4;
        return n4;
    }
}

