/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.net;

import com.aspose.html.utils.abN;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.Net.Cookie;
import com.aspose.html.utils.ms.System.Net.CookieCollection;
import com.aspose.html.utils.ms.System.Net.CookieException;
import com.aspose.html.utils.ms.System.Net.Dns;
import com.aspose.html.utils.ms.System.Net.IPAddress;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.RegularExpressions.Regex;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Uri;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public class CookieContainer {
    public static final int DefaultCookieLengthLimit = 4096;
    public static final int DefaultCookieLimit = 300;
    public static final int DefaultPerDomainCookieLimit = 20;
    private int a = 300;
    private int b = 20;
    private int c = 4096;
    private CookieCollection d;
    private static final StringSwitchMap e = new StringSwitchMap("path", "$path", "domain", "$domain", "expires", "$expires", "httponly", "secure");

    public CookieContainer() {
    }

    public CookieContainer(int n2) {
        if (n2 <= 0) {
            throw new ArgumentException("Must be greater than zero", "Capacity");
        }
        this.a = n2;
    }

    public CookieContainer(int n2, int n3, int n4) {
        this(n2);
        if (n3 != Integer.MAX_VALUE && (n3 <= 0 || n3 > n2)) {
            throw new ArgumentOutOfRangeException("perDomainCapacity", StringExtensions.format(StringExtensions.concat("PerDomainCapacity must be ", "greater than {0} and less than {1}."), Operators.boxing(0), Operators.boxing(n2)));
        }
        if (n4 <= 0) {
            throw new ArgumentException("Must be greater than zero", "MaxCookieSize");
        }
        this.b = n3;
        this.c = n4;
    }

    public int getCount() {
        return this.d == null ? 0 : this.d.size();
    }

    public int getCapacity() {
        return this.a;
    }

    public void setCapacity(int n2) {
        if (n2 < 0 || n2 < this.b && this.b != Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("value", StringExtensions.format(StringExtensions.concat("Capacity must be greater ", "than {0} and less than {1}."), Operators.boxing(0), Operators.boxing(this.b)));
        }
        this.a = n2;
    }

    public int getMaxCookieSize() {
        return this.c;
    }

    public void setMaxCookieSize(int n2) {
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.c = n2;
    }

    public int getPerDomainCapacity() {
        return this.b;
    }

    public void setPerDomainCapacity(int n2) {
        if (n2 != Integer.MAX_VALUE && (n2 <= 0 || n2 > this.a)) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.b = n2;
    }

    public void add(Cookie cookie) {
        if (cookie == null) {
            throw new ArgumentNullException("cookie");
        }
        this.a(cookie);
    }

    private void a(Cookie cookie) {
        if (cookie.getDomain().length() == 0) {
            throw new ArgumentException("Cookie domain not set.", "cookie.Domain");
        }
        if (cookie.getValue().length() > this.c) {
            throw new CookieException("value is larger than MaxCookieSize.");
        }
        if (cookie.getVersion() == 1 && cookie.getDomain().charAt(0) != '.') {
            throw new CookieException(StringExtensions.concat("Invalid cookie domain: ", cookie.getDomain()));
        }
        if (cookie.a() && !CookieContainer.a(cookie.getDomain())) {
            throw new CookieException(StringExtensions.concat("Invalid cookie domain: ", cookie.getDomain()));
        }
        if (this.d == null) {
            this.d = new CookieCollection();
        }
        if (this.d.size() >= this.a) {
            this.d(null);
        }
        if (this.d.size() >= this.b && this.c(cookie.getDomain()) >= this.b) {
            this.d(cookie.getDomain());
        }
        Cookie cookie2 = new Cookie(cookie.getName(), cookie.getValue());
        cookie2.setPath(cookie.getPath());
        cookie2.setDomain(cookie.getDomain());
        cookie2.a(cookie.a());
        cookie2.setVersion(cookie.getVersion());
        cookie2.setExpires(cookie.getExpires().anr());
        cookie2.setCommentUri(cookie.getCommentUri());
        cookie2.setComment(cookie.getComment());
        cookie2.setDiscard(cookie.getDiscard());
        cookie2.setHttpOnly(cookie.getHttpOnly());
        cookie2.setSecure(cookie.getSecure());
        this.d.add(cookie2);
        this.a();
    }

    private int c(String string) {
        int n2 = 0;
        for (Cookie cookie : this.d) {
            if (!CookieContainer.a(string, cookie.getDomain(), true)) continue;
            ++n2;
        }
        return n2;
    }

    private void d(String string) {
        int n2 = 0;
        abN abN2 = abN.hsY.anr();
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            Cookie cookie = this.d.get_Item(i2);
            if (!abN.c(cookie.getTimeStamp(), abN2) || string != null && !StringExtensions.equals(string, cookie.getDomain())) continue;
            cookie.getTimeStamp().x(abN2);
            n2 = i2;
        }
        this.d.a().removeAt(n2);
    }

    private void a() {
        if (this.d == null) {
            return;
        }
        for (int i2 = this.d.size() - 1; i2 >= 0; --i2) {
            Cookie cookie = this.d.get_Item(i2);
            if (!cookie.getExpired()) continue;
            this.d.a().removeAt(i2);
        }
    }

    public void add(CookieCollection cookieCollection) {
        if (cookieCollection == null) {
            throw new ArgumentNullException("cookies");
        }
        for (Cookie cookie : cookieCollection) {
            this.add(cookie);
        }
    }

    private void a(Uri uri, Cookie cookie) {
        if (StringExtensions.isNullOrEmpty(cookie.getName())) {
            throw new CookieException("Invalid cookie: name");
        }
        if (cookie.getValue() == null) {
            throw new CookieException("Invalid cookie: value");
        }
        if (uri != null) {
            if (cookie.getDomain().length() == 0) {
                cookie.setDomain(uri.getHost());
                cookie.a(false);
            } else if (cookie.a() && !CookieContainer.a(uri, cookie.getDomain())) {
                throw new CookieException(StringExtensions.concat("Invalid cookie domain: ", cookie.getDomain()));
            }
        }
        if (cookie.getVersion() == 0 && StringExtensions.isNullOrEmpty(cookie.getPath())) {
            if (uri != null) {
                cookie.setPath(uri.getAbsolutePath());
            } else {
                cookie.setPath("/");
            }
        }
        if (cookie.getVersion() == 1 && cookie.getPort().length() == 0 && uri != null && !uri.isDefaultPort()) {
            cookie.a(new int[]{uri.getPort()});
        }
    }

    public void add(Uri uri, Cookie cookie) {
        if (uri == null) {
            throw new ArgumentNullException("uri");
        }
        if (cookie == null) {
            throw new ArgumentNullException("cookie");
        }
        if (!cookie.getExpired()) {
            this.a(uri, cookie);
            this.a(cookie);
        }
    }

    public void add(Uri uri, CookieCollection cookieCollection) {
        if (uri == null) {
            throw new ArgumentNullException("uri");
        }
        if (cookieCollection == null) {
            throw new ArgumentNullException("cookies");
        }
        for (Cookie cookie : cookieCollection) {
            if (cookie.getExpired()) continue;
            this.a(uri, cookie);
            this.a(cookie);
        }
    }

    public String getCookieHeader(Uri uri) {
        if (uri == null) {
            throw new ArgumentNullException("uri");
        }
        CookieCollection cookieCollection = this.getCookies(uri);
        if (cookieCollection.size() == 0) {
            return "";
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (Cookie cookie : cookieCollection) {
            msStringBuilder2.append(cookie.a(uri));
            msStringBuilder2.append("; ");
        }
        if (msStringBuilder2.getLength() > 0) {
            msStringBuilder2.setLength(msStringBuilder2.getLength() - 2);
        }
        return msStringBuilder2.toString();
    }

    static boolean a(String string) {
        if (StringExtensions.isNullOrEmpty(string)) {
            return true;
        }
        IPAddress iPAddress = null;
        IPAddress[] iPAddressArray = new IPAddress[]{iPAddress};
        boolean bl2 = IPAddress.tryParse(string, iPAddressArray);
        iPAddress = iPAddressArray[0];
        if (bl2) {
            return string.charAt(0) != '.';
        }
        if (string.charAt(0) == '.') {
            string = StringExtensions.substring(string, 1);
        }
        if (StringExtensions.equals(string, "localhost", (short)3)) {
            return true;
        }
        String[] stringArray = StringExtensions.split(string, '.');
        return Array.boxing(stringArray).getLength() >= 2;
    }

    static boolean a(Uri uri, String string) {
        if (!CookieContainer.a(string)) {
            return false;
        }
        IPAddress iPAddress = null;
        IPAddress[] iPAddressArray = new IPAddress[]{iPAddress};
        boolean bl2 = IPAddress.tryParse(string, iPAddressArray);
        iPAddress = iPAddressArray[0];
        if (bl2) {
            if (string.charAt(0) == '.') {
                return false;
            }
            for (IPAddress iPAddress2 : Dns.getHostAddresses(uri.getDnsSafeHost())) {
                if (!iPAddress.equals(iPAddress2)) continue;
                return true;
            }
            return false;
        }
        return CookieContainer.a(string, uri.getHost(), false);
    }

    static boolean a(String string, String string2, boolean bl2) {
        String string3;
        if (string.length() == 0) {
            return false;
        }
        String string4 = string3 = string.charAt(0) == '.' ? StringExtensions.substring(string, 1) : string;
        if (bl2) {
            return StringExtensions.compare(string2, string3, (short)3) == 0;
        }
        if (!StringExtensions.endsWith(string2, string3, (short)3)) {
            return false;
        }
        int n2 = string2.length() - string3.length() - 1;
        if (n2 < 0) {
            return true;
        }
        return string2.charAt(n2) == '.';
    }

    static boolean a(String string, String string2) {
        if (string.length() == 0) {
            return false;
        }
        String string3 = string.charAt(0) == '.' ? StringExtensions.substring(string, 1) : string;
        return StringExtensions.compare(string2, string3, (short)3) == 0;
    }

    public CookieCollection getCookies(Uri uri) {
        if (uri == null) {
            throw new ArgumentNullException("uri");
        }
        this.a();
        CookieCollection cookieCollection = new CookieCollection();
        if (this.d == null) {
            return cookieCollection;
        }
        for (Cookie cookie : this.d) {
            String string = cookie.getDomain();
            if ((cookie.getVersion() != 1 ? !CookieContainer.a(string, uri.getHost(), !cookie.a()) : !CookieContainer.a(string, uri.getHost())) || cookie.getPort().length() > 0 && cookie.b() != null && uri.getPort() != -1 && Array.indexOf(Array.boxing(cookie.b()), (Object)uri.getPort()) == -1) continue;
            String string2 = cookie.getPath();
            String string3 = uri.getAbsolutePath();
            if (!"".equals(string2) && !"/".equals(string2) && !StringExtensions.equals(string3, string2) && (!StringExtensions.startsWith(string3, string2) || string2.charAt(string2.length() - 1) != '/' && string3.length() > string2.length() && string3.charAt(string2.length()) != '/') || cookie.getSecure() && !"https".equals(uri.getScheme())) continue;
            cookieCollection.add(cookie);
        }
        cookieCollection.b();
        return cookieCollection;
    }

    public void setCookies(Uri uri, String string) {
        if (uri == null) {
            throw new ArgumentNullException("uri");
        }
        if (string == null) {
            throw new ArgumentNullException("cookieHeader");
        }
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = StringExtensions.split(string, ',');
        for (int i2 = 0; i2 < Array.boxing(stringArray).getLength(); ++i2) {
            String string2 = stringArray[i2];
            if (Array.boxing(stringArray).getLength() > i2 + 1 && Regex.isMatch(stringArray[i2], ".*expires\\s*=\\s*(Mon|Tue|Wed|Thu|Fri|Sat|Sun)", 66) && Regex.isMatch(stringArray[i2 + 1], "\\s\\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\\d{4} \\d{2}:\\d{2}:\\d{2} GMT", 66)) {
                string2 = new msStringBuilder(string2).append(",").append(stringArray[++i2]).toString();
            }
            try {
                Cookie cookie = CookieContainer.b(string2);
                if (cookie.getPath().length() == 0) {
                    cookie.setPath(uri.getAbsolutePath());
                } else if (!StringExtensions.startsWith(uri.getAbsolutePath(), cookie.getPath())) {
                    String string3 = StringExtensions.format("'Path'='{0}' is invalid with URI", cookie.getPath());
                    throw new CookieException(string3);
                }
                if (cookie.getDomain().length() == 0) {
                    cookie.setDomain(uri.getHost());
                    cookie.a(false);
                } else if (cookie.a() && !CookieContainer.a(uri, cookie.getDomain())) {
                    throw new CookieException(StringExtensions.concat("Invalid cookie domain: ", cookie.getDomain()));
                }
                this.a(cookie);
                continue;
            }
            catch (Exception exception) {
                String string4 = StringExtensions.format("Could not parse cookies for '{0}'.", uri);
                throw new CookieException(string4, exception);
            }
        }
    }

    static Cookie b(String string) {
        String[] stringArray = StringExtensions.split(string, ';');
        Cookie cookie = new Cookie();
        block7: for (int i2 = 0; i2 < Array.boxing(stringArray).getLength(); ++i2) {
            String string2;
            String string3;
            int n2 = StringExtensions.indexOf(stringArray[i2], '=');
            if (n2 == -1) {
                string3 = StringExtensions.trim(stringArray[i2]);
                string2 = StringExtensions.Empty;
            } else {
                string3 = StringExtensions.trim(StringExtensions.substring(stringArray[i2], 0, n2));
                string2 = StringExtensions.trim(StringExtensions.substring(stringArray[i2], n2 + 1));
            }
            switch (e.of(StringExtensions.toLowerInvariant(string3))) {
                case 0: 
                case 1: {
                    if (cookie.getPath().length() != 0) continue block7;
                    cookie.setPath(string2);
                    continue block7;
                }
                case 2: 
                case 3: {
                    if (cookie.getDomain().length() != 0) continue block7;
                    cookie.setDomain(string2);
                    continue block7;
                }
                case 4: 
                case 5: {
                    if (!abN.g(cookie.getExpires(), abN.hsX)) continue block7;
                    cookie.setExpires(abN.a(abN.a(string2, "ddd, dd-MMM-yyyy HH:mm:ss G\\MT", (IFormatProvider)CultureInfo.getInvariantCulture()).anr(), 1L).anr());
                    continue block7;
                }
                case 6: {
                    cookie.setHttpOnly(true);
                    continue block7;
                }
                case 7: {
                    cookie.setSecure(true);
                    continue block7;
                }
                default: {
                    if (cookie.getName().length() != 0) continue block7;
                    cookie.setName(string3);
                    cookie.setValue(string2);
                }
            }
        }
        return cookie;
    }
}

