/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.SHAKEDigest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] ZERO_BYTE = new byte[1];
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    CSHAKEDigest(int n2, byte[] byArray, byte[] byArray2) {
        super(n2);
        if (n2 == 128) {
            SelfTestExecutor.validate((FipsAlgorithm)FipsSHS.Algorithm.cSHAKE128, (Object)this, new KatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba7")));
        } else {
            SelfTestExecutor.validate((FipsAlgorithm)FipsSHS.Algorithm.cSHAKE256, (Object)this, new KatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739")));
        }
        if (!(byArray != null && byArray.length != 0 || byArray2 != null && byArray2.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(CSHAKEDigest.leftEncode(this.rate / 8), this.encodeString(byArray), this.encodeString(byArray2));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int n2;
        int n3 = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length * 8);
        for (n2 = (n3 - this.diff.length % n3) % n3; n2 > padding.length; n2 -= padding.length) {
            this.absorb(padding, 0, padding.length * 8);
        }
        this.absorb(padding, 0, n2 * 8);
    }

    private byte[] encodeString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return CSHAKEDigest.leftEncode(0L);
        }
        return Arrays.concatenate(CSHAKEDigest.leftEncode((long)byArray.length * 8L), byArray);
    }

    private static byte[] leftEncode(long l2) {
        int n2 = 1;
        long l3 = l2;
        while ((l3 >>= 8) != 0L) {
            n2 = (byte)(n2 + 1);
        }
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = n2;
        for (int i2 = 1; i2 <= n2; ++i2) {
            byArray[i2] = (byte)(l2 >> 8 * (n2 - i2));
        }
        return byArray;
    }

    public int doOutput(byte[] byArray, int n2, int n3) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorb(ZERO_BYTE, 0, 2L);
            }
            this.squeeze(byArray, n2, (long)n3 * 8L);
            return n3;
        }
        return super.doOutput(byArray, n2, n3);
    }

    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KatTest<T extends Digest>
    implements BasicKatTest<T> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        KatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            digest.reset();
            return Arrays.areEqual(byArray, this.kat);
        }
    }
}

