/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.DhParametersHelper;
import org.bouncycastle.crypto.internal.params.DhParameters;

class DhParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    DhParametersGenerator() {
    }

    public void init(int n2, int n3, SecureRandom secureRandom) {
        this.size = n2;
        this.certainty = n3;
        this.random = secureRandom;
    }

    public DhParameters generateParameters() {
        BigInteger[] bigIntegerArray = DhParametersHelper.generateSafePrimes(this.size, this.certainty, this.random);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = DhParametersHelper.selectGenerator(bigInteger, bigInteger2, this.random);
        return new DhParameters(bigInteger, bigInteger3, bigInteger2, TWO);
    }
}

