/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.DhBasicAgreement;
import org.bouncycastle.crypto.fips.DhKeyPairGenerator;
import org.bouncycastle.crypto.fips.DhParametersGenerator;
import org.bouncycastle.crypto.fips.DhuBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementFactory;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.MqvBasicAgreement;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DhKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.DhuPublicParameters;
import org.bouncycastle.crypto.internal.params.MqvPrivateParameters;
import org.bouncycastle.crypto.internal.params.MqvPublicParameters;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public final class FipsDH {
    private static final int MIN_FIPS_KEY_STRENGTH = 2048;
    static final FipsEngineProvider<DhBasicAgreement> AGREEMENT_PROVIDER;
    static final FipsEngineProvider<MqvBasicAgreement> MQV_PROVIDER;
    static final FipsEngineProvider<DhuBasicAgreement> DHU_PROVIDER;
    public static final FipsAlgorithm ALGORITHM;
    private static final FipsAlgorithm ALGORITHM_DH;
    private static final FipsAlgorithm ALGORITHM_MQV;
    private static final FipsAlgorithm ALGORITHM_DHU;
    public static final AgreementParameters DH;
    public static final MQVAgreementParametersBuilder MQV;
    public static final DHUAgreementParametersBuilder DHU;

    private FipsDH() {
    }

    private static void validateKeyPair(FipsAlgorithm fipsAlgorithm, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        Variations variations = fipsAlgorithm == ALGORITHM ? Variations.DH : (Variations)fipsAlgorithm.basicVariation();
        switch (variations) {
            case DH: {
                SelfTestExecutor.validate((FipsAlgorithm)fipsAlgorithm, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        DhBasicAgreement dhBasicAgreement = new DhBasicAgreement();
                        dhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        dhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger2 = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        dhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger3 = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        dhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger4 = dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        return !bigInteger.equals(bigInteger2) && !bigInteger.equals(bigInteger3) && bigInteger3.equals(bigInteger4);
                    }
                });
                break;
            }
            case MQV: {
                SelfTestExecutor.validate((FipsAlgorithm)fipsAlgorithm, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        MqvBasicAgreement mqvBasicAgreement = new MqvBasicAgreement();
                        mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger2 = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        BigInteger bigInteger3 = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !bigInteger.equals(bigInteger2) && bigInteger2.equals(bigInteger3);
                    }
                });
                break;
            }
            case DHU: {
                SelfTestExecutor.validate((FipsAlgorithm)fipsAlgorithm, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        DhuBasicAgreement dhuBasicAgreement = new DhuBasicAgreement();
                        dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                        dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray2 = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        byte[] byArray3 = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !Arrays.areEqual(byArray, byArray2) && Arrays.areEqual(byArray2, byArray3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled DH algorithm: " + fipsAlgorithm.getName());
            }
        }
    }

    private static void ffPrimitiveZTest() {
        SelfTestExecutor.validate((FipsAlgorithm)ALGORITHM, (VariantInternalKatTest)new VariantInternalKatTest(ALGORITHM){

            void evaluate() throws Exception {
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                DhPrivateKeyParameters dhPrivateKeyParameters = (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
                DhPublicKeyParameters dhPublicKeyParameters = (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
                if (!dhPublicKeyParameters.getY().equals(dhPrivateKeyParameters.getParameters().getG().modPow(dhPrivateKeyParameters.getX(), dhPrivateKeyParameters.getParameters().getP()))) {
                    this.fail("FF primitive 'Z' computation failed");
                }
            }
        });
    }

    private static AsymmetricCipherKeyPair getKATKeyPair() {
        BigInteger bigInteger = new BigInteger("90EAF4D1AF0708B1B612FF35E0A2997EB9E9D263C9CE659528945C0D", 16);
        BigInteger bigInteger2 = new BigInteger("C196BA05AC29E1F9C3C72D56DFFC6154A033F1477AC88EC37F09BE6C5BB95F51C296DD20D1A28A067CCC4D4316A4BD1DCA55ED1066D438C35AEBAABF57E7DAE428782A95ECA1C143DB701FD48533A3C18F0FE23557EA7AE619ECACC7E0B51652A8776D02A425567DED36EABD90CA33A1E8D988F0BBB92D02D1D20290113BB562CE1FC856EEB7CDD92D33EEA6F410859B179E7E789A8F75F645FAE2E136D252BFFAFF89528945C1ABE705A38DBC2D364AADE99BE0D0AAD82E5320121496DC65B3930E38047294FF877831A16D5228418DE8AB275D7D75651CEFED65F78AFC3EA7FE4D79B35F62A0402A1117599ADAC7B269A59F353CF450E6982D3B1702D9CA83", 16);
        BigInteger bigInteger3 = new BigInteger("A59A749A11242C58C894E9E5A91804E8FA0AC64B56288F8D47D51B1EDC4D65444FECA0111D78F35FC9FDD4CB1F1B79A3BA9CBEE83A3F811012503C8117F98E5048B089E387AF6949BF8784EBD9EF45876F2E6A5A495BE64B6E770409494B7FEE1DBB1E4B2BC2A53D4F893D418B7159592E4FFFDF6969E91D770DAEBD0B5CB14C00AD68EC7DC1E5745EA55C706C4A1C5C88964E34D09DEB753AD418C1AD0F4FDFD049A955E5D78491C0B7A2F1575A008CCD727AB376DB6E695515B05BD412F5B8C2F4C77EE10DA48ABD53F5DD498927EE7B692BBBCDA2FB23A516C5B4533D73980B2A3B60E384ED200AE21B40D273651AD6060C13D97FD69AA13C5611A51B9085", 16);
        BigInteger bigInteger4 = new BigInteger("80d54802e42ce811d122ce2657c303013fc33c2f08f8ff1a9c4ebfd1", 16);
        BigInteger bigInteger5 = new BigInteger("76277e7f847626c252c76828a6142b75e92aaa69612c789686686f447d7361f58c54dac02f23a672157a239dedefaeadecdd94b8f581ec086d152517532c2a8465983f51a643491ddcc328792c9795674ba630b47f364670432d826e2733bc85a666c64e3607d599b125b79ff5a179c88ceee1972d3da80c77c7652b0dc2930f0bf81be1a782e27f35f82848ea0e1f2d4ff6d0c6a739bbc61bdb646d1a189a10421a76c2942254ec92e7f7d3bec0b6066eb70c9de6be50409e25f7d0e0b93fcc08a9f2694253238c6889a909f22b636924e54f6b12392ddf5016633646476b74257ffbb486723f1a3167c93f0e577c4e6d3734f4af38153c76850374c067e6c7", 16);
        DhParameters dhParameters = new DhParameters(bigInteger2, bigInteger3, bigInteger);
        return new AsymmetricCipherKeyPair(new DhPublicKeyParameters(bigInteger5, dhParameters), new DhPrivateKeyParameters(bigInteger4, dhParameters));
    }

    private static AsymmetricCipherKeyPair getTestKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        DhPrivateKeyParameters dhPrivateKeyParameters = (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DhParameters dhParameters = dhPrivateKeyParameters.getParameters();
        BigInteger bigInteger = dhPrivateKeyParameters.getX().multiply(BigInteger.valueOf(7L)).mod(dhPrivateKeyParameters.getX());
        if (bigInteger.compareTo(BigInteger.valueOf(2L)) < 0) {
            bigInteger = new BigInteger("0102030405060708090a0b0c0d0e0f101112131415161718", 16);
        }
        DhPrivateKeyParameters dhPrivateKeyParameters2 = new DhPrivateKeyParameters(bigInteger, dhParameters);
        DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(dhParameters.getG().modPow(bigInteger, dhParameters.getP()), dhParameters);
        return new AsymmetricCipherKeyPair(dhPublicKeyParameters, dhPrivateKeyParameters2);
    }

    private static DhParameters getDomainParams(DHDomainParameters dHDomainParameters) {
        return new DhParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getM(), dHDomainParameters.getL(), dHDomainParameters.getJ());
    }

    private static DhPrivateKeyParameters getLwKey(final AsymmetricDHPrivateKey asymmetricDHPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DhPrivateKeyParameters>(){

            @Override
            public DhPrivateKeyParameters run() {
                return new DhPrivateKeyParameters(asymmetricDHPrivateKey.getX(), FipsDH.getDomainParams(asymmetricDHPrivateKey.getDomainParameters()));
            }
        });
    }

    static {
        ALGORITHM = new FipsAlgorithm("DH");
        ALGORITHM_DH = new FipsAlgorithm("DH", (Enum)Variations.DH);
        ALGORITHM_MQV = new FipsAlgorithm("DH", (Enum)Variations.MQV);
        ALGORITHM_DHU = new FipsAlgorithm("DH", (Enum)Variations.DHU);
        DH = new AgreementParameters();
        MQV = new MQVAgreementParametersBuilder();
        DHU = new DHUAgreementParametersBuilder();
        AGREEMENT_PROVIDER = new AgreementProvider();
        MQV_PROVIDER = new MqvProvider();
        DHU_PROVIDER = new DhuProvider();
        AGREEMENT_PROVIDER.createEngine();
        MQV_PROVIDER.createEngine();
        DHU_PROVIDER.createEngine();
        FipsDH.ffPrimitiveZTest();
    }

    public static final class AgreementParameters
    extends FipsAgreementParameters {
        AgreementParameters() {
            this(null);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM, fipsAlgorithm);
        }

        private AgreementParameters(FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM, pRF, byArray);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            super(fipsAlgorithm, agreementKDFParametersBuilder, byArray, n2);
        }

        public AgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new AgreementParameters(fipsAlgorithm);
        }

        public AgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new AgreementParameters(pRF, byArray);
        }

        public AgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            return new AgreementParameters(this.getAlgorithm(), agreementKDFParametersBuilder, byArray, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AgreementProvider
    extends FipsEngineProvider<DhBasicAgreement> {
        static final BigInteger expected = new BigInteger("8b2ba83764fc961a7aeb335d67aa206c1013be9127e2d37a43fa7fff45dd13d4699173a727f4fc88b66d5f53c8848667c090adb2879501d1f7fe53b430beb220b6cce85c5bff74c61b16dbc788ab1459eec1b6f03455862324210e72f7e1f01a55f464bbd996267d3693cdc61053d87a17cb93f6e5079188377db48774bc9232552440471218ec2834e0e29fcdba7e0b7caf9a8f679c4e4382f83f66f8a4dd61cc5d91d15440f10a0f76c3e3a495e7cc53993ba7fb3231310c79e2b587a10074030f158a560e85c89642da9c883f78947116d8ea0d94bfe77c6fb07a7fca8c524827f5779aa7f5428fec0d282f8aca22dd1d47ed61eb6584b5444c5344ab716e", 16);

        private AgreementProvider() {
        }

        @Override
        public DhBasicAgreement createEngine() {
            return (DhBasicAgreement)SelfTestExecutor.validate((FipsAlgorithm)ALGORITHM_DH, (Object)new DhBasicAgreement(), (VariantKatTest)new VariantKatTest<DhBasicAgreement>(){

                @Override
                void evaluate(DhBasicAgreement dhBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    dhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                    if (!expected.equals(dhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic()))) {
                        this.fail("KAT DH agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHAgreementFactory
    extends FipsAgreementFactory<AgreementParameters> {
        @Override
        public FipsAgreement<AgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final AgreementParameters agreementParameters) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)asymmetricPrivateKey;
            DhPrivateKeyParameters dhPrivateKeyParameters = FipsDH.getLwKey(asymmetricDHPrivateKey);
            final DhBasicAgreement dhBasicAgreement = (DhBasicAgreement)AGREEMENT_PROVIDER.createEngine();
            dhBasicAgreement.init(dhPrivateKeyParameters);
            return new FipsAgreement<AgreementParameters>(){

                @Override
                public AgreementParameters getParameters() {
                    return agreementParameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)asymmetricPublicKey;
                    DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(asymmetricDHPublicKey.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey.getDomainParameters()));
                    int n2 = dhBasicAgreement.getFieldSize();
                    BigInteger bigInteger = dhBasicAgreement.calculateAgreement(dhPublicKeyParameters);
                    byte[] byArray = BigIntegers.asUnsignedByteArray(n2, bigInteger);
                    return FipsKDF.processZBytes(byArray, agreementParameters);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHUAgreementFactory
    extends FipsAgreementFactory<DHUAgreementParameters> {
        @Override
        public FipsAgreement<DHUAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final DHUAgreementParameters dHUAgreementParameters) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)asymmetricPrivateKey;
            DhuPrivateParameters dhuPrivateParameters = new DhuPrivateParameters(FipsDH.getLwKey(asymmetricDHPrivateKey), FipsDH.getLwKey(dHUAgreementParameters.ephemeralPrivateKey));
            final DhuBasicAgreement dhuBasicAgreement = (DhuBasicAgreement)DHU_PROVIDER.createEngine();
            dhuBasicAgreement.init(dhuPrivateParameters);
            return new FipsAgreement<DHUAgreementParameters>(){

                @Override
                public DHUAgreementParameters getParameters() {
                    return dHUAgreementParameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)asymmetricPublicKey;
                    DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(asymmetricDHPublicKey.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey.getDomainParameters()));
                    DhuPublicParameters dhuPublicParameters = new DhuPublicParameters(dhPublicKeyParameters, new DhPublicKeyParameters(dHUAgreementParameters.otherPartyEphemeralKey.getY(), dhPublicKeyParameters.getParameters()));
                    byte[] byArray = dhuBasicAgreement.calculateAgreement(dhuPublicParameters);
                    return FipsKDF.processZBytes(byArray, dHUAgreementParameters);
                }
            };
        }
    }

    public static final class DHUAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricDHPublicKey ephemeralPublicKey;
        private final AsymmetricDHPrivateKey ephemeralPrivateKey;
        private final AsymmetricDHPublicKey otherPartyEphemeralKey;

        private DHUAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_DHU, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_DHU, pRF, byArray);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            super(ALGORITHM_DHU, agreementKDFParametersBuilder, byArray, n2);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        public AsymmetricDHPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricDHPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricDHPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public DHUAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public DHUAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public DHUAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n2);
        }
    }

    public static final class DHUAgreementParametersBuilder
    extends FipsParameters {
        DHUAgreementParametersBuilder() {
            super(ALGORITHM_DHU);
        }

        public DHUAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new DHUAgreementParameters((AsymmetricDHPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricDHPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricDHPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new DHUAgreementParameters(null, asymmetricDHPrivateKey, asymmetricDHPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2) {
            return new DHUAgreementParameters(asymmetricDHPublicKey, asymmetricDHPrivateKey, asymmetricDHPublicKey2, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DhuProvider
    extends FipsEngineProvider<DhuBasicAgreement> {
        static final byte[] expected = Hex.decode("8b2ba83764fc961a7aeb335d67aa206c1013be9127e2d37a43fa7fff45dd13d4699173a727f4fc88b66d5f53c8848667c090adb2879501d1f7fe53b430beb220b6cce85c5bff74c61b16dbc788ab1459eec1b6f03455862324210e72f7e1f01a55f464bbd996267d3693cdc61053d87a17cb93f6e5079188377db48774bc9232552440471218ec2834e0e29fcdba7e0b7caf9a8f679c4e4382f83f66f8a4dd61cc5d91d15440f10a0f76c3e3a495e7cc53993ba7fb3231310c79e2b587a10074030f158a560e85c89642da9c883f78947116d8ea0d94bfe77c6fb07a7fca8c524827f5779aa7f5428fec0d282f8aca22dd1d47ed61eb6584b5444c5344ab716e8b2ba83764fc961a7aeb335d67aa206c1013be9127e2d37a43fa7fff45dd13d4699173a727f4fc88b66d5f53c8848667c090adb2879501d1f7fe53b430beb220b6cce85c5bff74c61b16dbc788ab1459eec1b6f03455862324210e72f7e1f01a55f464bbd996267d3693cdc61053d87a17cb93f6e5079188377db48774bc9232552440471218ec2834e0e29fcdba7e0b7caf9a8f679c4e4382f83f66f8a4dd61cc5d91d15440f10a0f76c3e3a495e7cc53993ba7fb3231310c79e2b587a10074030f158a560e85c89642da9c883f78947116d8ea0d94bfe77c6fb07a7fca8c524827f5779aa7f5428fec0d282f8aca22dd1d47ed61eb6584b5444c5344ab716e");

        private DhuProvider() {
        }

        @Override
        public DhuBasicAgreement createEngine() {
            return (DhuBasicAgreement)SelfTestExecutor.validate((FipsAlgorithm)ALGORITHM_DHU, (Object)new DhuBasicAgreement(), (VariantKatTest)new VariantKatTest<DhuBasicAgreement>(){

                @Override
                void evaluate(DhuBasicAgreement dhuBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    dhuBasicAgreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    byte[] byArray = dhuBasicAgreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!Arrays.areEqual(expected, byArray)) {
                        this.fail("KAT DH DHU agreement not verified");
                    }
                }
            });
        }
    }

    public static final class DomainGenParameters
    extends FipsParameters {
        private final int L;
        private final int N;
        private final int certainty;
        private final BigInteger p;
        private final BigInteger q;
        private final byte[] seed;
        private final int usageIndex;

        public DomainGenParameters(int n2) {
            this(n2, n2 > 1024 ? 256 : 160, PrimeCertaintyCalculator.getDefaultCertainty(n2));
        }

        public DomainGenParameters(int n2, int n3) {
            this(n2, n2 > 1024 ? 256 : 160, n3);
        }

        public DomainGenParameters(int n2, int n3, int n4) {
            this(n2, n3, n4, null, null, null, -1);
        }

        public DomainGenParameters(int n2, int n3, int n4, int n5) {
            this(n2, n3, n4, null, null, null, n5);
        }

        public DomainGenParameters(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, null, -1);
        }

        public DomainGenParameters(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
            this(bigInteger.bitLength(), bigInteger2.bitLength(), 0, bigInteger, bigInteger2, Arrays.clone(byArray), n2);
        }

        private DomainGenParameters(int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n5) {
            super(ALGORITHM);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && bigInteger == null && n4 < PrimeCertaintyCalculator.getDefaultCertainty(n2)) {
                throw new FipsUnapprovedOperationError("Prime generation certainty " + n4 + " inadequate for parameters of " + n2 + " bits", (Algorithm)this.getAlgorithm());
            }
            if (n5 > 255) {
                throw new IllegalArgumentException("Usage index must be in range 0 to 255 (or -1 to ignore)");
            }
            this.L = n2;
            this.N = n3;
            this.certainty = n4;
            this.p = bigInteger;
            this.q = bigInteger2;
            this.seed = byArray;
            this.usageIndex = n5;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;
        private final FipsDigestAlgorithm digestAlgorithm;

        public DomainParametersGenerator(DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            this(FipsSHS.Algorithm.SHA256, domainGenParameters, secureRandom);
        }

        public DomainParametersGenerator(FipsDigestAlgorithm fipsDigestAlgorithm, DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int n2 = domainGenParameters.L;
                if (n2 != 2048 && n2 != 3072) {
                    throw new FipsUnapprovedOperationError("Attempt to create parameters with unapproved key size [" + n2 + "]", (Algorithm)ALGORITHM);
                }
                Utils.validateRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n2), ALGORITHM, "Attempt to create parameters with unapproved RNG");
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.parameters = domainGenParameters;
            this.random = secureRandom;
        }

        public DHDomainParameters generateDomainParameters() {
            if (this.parameters.L < 2048) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    throw new FipsUnapprovedOperationError("Requested DH parameter strength too small for approved mode: " + this.parameters.L);
                }
                DhParametersGenerator dhParametersGenerator = new DhParametersGenerator();
                dhParametersGenerator.init(this.parameters.L, this.parameters.certainty, this.random);
                DhParameters dhParameters = dhParametersGenerator.generateParameters();
                return new DHDomainParameters(dhParameters.getP(), dhParameters.getQ(), dhParameters.getG(), dhParameters.getJ(), null);
            }
            FipsDSA.DomainGenParameters domainGenParameters = new FipsDSA.DomainGenParameters(this.parameters.L, this.parameters.N, this.parameters.certainty, this.parameters.p, this.parameters.q, this.parameters.seed, this.parameters.usageIndex);
            FipsDSA.DomainParametersGenerator domainParametersGenerator = new FipsDSA.DomainParametersGenerator(this.digestAlgorithm, domainGenParameters, this.random);
            DSADomainParameters dSADomainParameters = domainParametersGenerator.generateDomainParameters();
            DSAValidationParameters dSAValidationParameters = dSADomainParameters.getValidationParameters();
            if (dSAValidationParameters != null) {
                return new DHDomainParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG(), null, new DHValidationParameters(dSAValidationParameters.getSeed(), dSAValidationParameters.getCounter(), dSAValidationParameters.getUsageIndex()));
            }
            return new DHDomainParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG());
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final DHDomainParameters domainParameters;

        public KeyGenParameters(DHDomainParameters dHDomainParameters) {
            this(ALGORITHM, dHDomainParameters);
        }

        public KeyGenParameters(AgreementParameters agreementParameters, DHDomainParameters dHDomainParameters) {
            this(agreementParameters.getAlgorithm(), dHDomainParameters);
        }

        public KeyGenParameters(MQVAgreementParametersBuilder mQVAgreementParametersBuilder, DHDomainParameters dHDomainParameters) {
            this(mQVAgreementParametersBuilder.getAlgorithm(), dHDomainParameters);
        }

        public KeyGenParameters(DHUAgreementParametersBuilder dHUAgreementParametersBuilder, DHDomainParameters dHDomainParameters) {
            this(dHUAgreementParametersBuilder.getAlgorithm(), dHDomainParameters);
        }

        private KeyGenParameters(FipsAlgorithm fipsAlgorithm, DHDomainParameters dHDomainParameters) {
            super(fipsAlgorithm);
            this.domainParameters = dHDomainParameters;
        }

        public DHDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator {
        private final DhKeyPairGenerator engine = new DhKeyPairGenerator();
        private final DHDomainParameters domainParameters;
        private final DhKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int n2 = keyGenParameters.domainParameters.getP().bitLength();
                if (n2 < 2048) {
                    throw new FipsUnapprovedOperationError("Attempt to create key of less than 2048 bits", (Algorithm)keyGenParameters.getAlgorithm());
                }
                Utils.validateKeyPairGenRandom(secureRandom, Utils.getAsymmetricSecurityStrength(n2), ALGORITHM);
            }
            this.param = new DhKeyGenerationParameters(secureRandom, FipsDH.getDomainParams(keyGenParameters.getDomainParameters()));
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.engine.init(this.param);
        }

        public AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            DhPublicKeyParameters dhPublicKeyParameters = (DhPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            DhPrivateKeyParameters dhPrivateKeyParameters = (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            FipsAlgorithm fipsAlgorithm = (FipsAlgorithm)this.getParameters().getAlgorithm();
            FipsDH.validateKeyPair(fipsAlgorithm, asymmetricCipherKeyPair);
            return new AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey>(new AsymmetricDHPublicKey(fipsAlgorithm, this.domainParameters, dhPublicKeyParameters.getY()), new AsymmetricDHPrivateKey(fipsAlgorithm, this.domainParameters, dhPrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MQVAgreementFactory
    extends FipsAgreementFactory<MQVAgreementParameters> {
        @Override
        public FipsAgreement<MQVAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final MQVAgreementParameters mQVAgreementParameters) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)asymmetricPrivateKey;
            DhPrivateKeyParameters dhPrivateKeyParameters = FipsDH.getLwKey(asymmetricDHPrivateKey);
            final MqvBasicAgreement mqvBasicAgreement = (MqvBasicAgreement)MQV_PROVIDER.createEngine();
            mqvBasicAgreement.init(new MqvPrivateParameters(dhPrivateKeyParameters, mQVAgreementParameters.ephemeralPrivateKey == null ? dhPrivateKeyParameters : FipsDH.getLwKey(mQVAgreementParameters.ephemeralPrivateKey)));
            return new FipsAgreement<MQVAgreementParameters>(){

                @Override
                public MQVAgreementParameters getParameters() {
                    return mQVAgreementParameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)asymmetricPublicKey;
                    DhPublicKeyParameters dhPublicKeyParameters = new DhPublicKeyParameters(asymmetricDHPublicKey.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey.getDomainParameters()));
                    int n2 = mqvBasicAgreement.getFieldSize();
                    AsymmetricDHPublicKey asymmetricDHPublicKey2 = mQVAgreementParameters.getOtherPartyEphemeralKey();
                    BigInteger bigInteger = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters(dhPublicKeyParameters, new DhPublicKeyParameters(asymmetricDHPublicKey2.getY(), FipsDH.getDomainParams(asymmetricDHPublicKey2.getDomainParameters()))));
                    byte[] byArray = BigIntegers.asUnsignedByteArray(n2, bigInteger);
                    return FipsKDF.processZBytes(byArray, mQVAgreementParameters);
                }
            };
        }
    }

    public static final class MQVAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricDHPublicKey ephemeralPublicKey;
        private final AsymmetricDHPrivateKey ephemeralPrivateKey;
        private final AsymmetricDHPublicKey otherPartyEphemeralKey;

        private MQVAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_MQV, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_MQV, pRF, byArray);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            super(ALGORITHM_MQV, agreementKDFParametersBuilder, byArray, n2);
            this.ephemeralPublicKey = asymmetricDHPublicKey;
            this.ephemeralPrivateKey = asymmetricDHPrivateKey;
            this.otherPartyEphemeralKey = asymmetricDHPublicKey2;
        }

        public AsymmetricDHPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricDHPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricDHPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public MQVAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public MQVAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public MQVAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n2);
        }
    }

    public static final class MQVAgreementParametersBuilder
    extends FipsParameters {
        MQVAgreementParametersBuilder() {
            super(ALGORITHM_MQV);
        }

        public MQVAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new MQVAgreementParameters((AsymmetricDHPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricDHPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricDHPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey) {
            return new MQVAgreementParameters(null, asymmetricDHPrivateKey, asymmetricDHPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricDHPublicKey asymmetricDHPublicKey, AsymmetricDHPrivateKey asymmetricDHPrivateKey, AsymmetricDHPublicKey asymmetricDHPublicKey2) {
            return new MQVAgreementParameters(asymmetricDHPublicKey, asymmetricDHPrivateKey, asymmetricDHPublicKey2, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MqvProvider
    extends FipsEngineProvider<MqvBasicAgreement> {
        static final BigInteger expected = new BigInteger("52b800582b28e89d8ee581014ea4a1bc59cc3cc202562788ac40cbf9b1b11657019b556f112ecc9404b1de17630edcd0b8f9f4075e39624e94074b5060d3e699f726873b16e6ec49bdf689bcc275477da4170c7bbe93bfd5bc32a9556311d3f54d0e534118363deda2e3d25b6213b3d01f218c3f1d237967d128cd5a0f0caca8e287fd599d48ce297c8d92a4b7b2d95950a8ddb0e86e7b9bdc6abab91f758613762d185b2a5f516434f96c1bcba67f47bb780ade54dfa6a4f6a8d130aca76f9b28d77ef5eae1e254e5b61526b8c0fecf11b22e8630ebdd5e95f3902954526bd99eb8735263855b5f4d1ea32f6a0d2895ed292e9bb17a07ba1742a1619f4d95c9", 16);

        private MqvProvider() {
        }

        @Override
        public MqvBasicAgreement createEngine() {
            return (MqvBasicAgreement)SelfTestExecutor.validate((FipsAlgorithm)ALGORITHM_MQV, (Object)new MqvBasicAgreement(), (VariantKatTest)new VariantKatTest<MqvBasicAgreement>(){

                @Override
                void evaluate(MqvBasicAgreement mqvBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsDH.getTestKeyPair(asymmetricCipherKeyPair);
                    mqvBasicAgreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (DhPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    BigInteger bigInteger = mqvBasicAgreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (DhPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!expected.equals(bigInteger)) {
                        this.fail("KAT DH MQV agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Variations {
        DH,
        MQV,
        DHU;

    }
}

