/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricOperatorFactory;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SingleBlockEncryptorUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedAsymmetricOperatorFactory<T extends Parameters>
implements AsymmetricOperatorFactory<T> {
    GuardedAsymmetricOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public SingleBlockEncryptorUsingSecureRandom<T> createBlockEncryptor(AsymmetricKey asymmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return new BlockEncryptor(this, asymmetricKey, t2, null);
    }

    protected abstract AsymmetricBlockCipher createCipher(boolean var1, AsymmetricKey var2, T var3, SecureRandom var4);

    protected static boolean isRawEngine(AsymmetricBlockCipher asymmetricBlockCipher) {
        return !(asymmetricBlockCipher instanceof PKCS1Encoding) && !(asymmetricBlockCipher instanceof OAEPEncoding);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BlockEncryptor
    implements SingleBlockEncryptorUsingSecureRandom<T> {
        private final AsymmetricKey key;
        private final T parameters;
        private final SecureRandom random;
        private AsymmetricBlockCipher engine;
        final /* synthetic */ GuardedAsymmetricOperatorFactory this$0;

        BlockEncryptor(AsymmetricKey asymmetricKey, T t2, SecureRandom secureRandom) {
            this.this$0 = var1_1;
            this.key = asymmetricKey;
            this.parameters = t2;
            this.random = secureRandom;
        }

        private AsymmetricBlockCipher getEngine() {
            if (this.engine == null) {
                this.engine = this.this$0.createCipher(true, this.key, this.parameters, this.random);
            }
            return this.engine;
        }

        @Override
        public byte[] encryptBlock(byte[] byArray, int n2, int n3) throws PlainInputProcessingException {
            try {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                return this.getEngine().processBlock(byArray, n2, n3);
            }
            catch (Exception exception) {
                throw new PlainInputProcessingException("Unable to encrypt block: " + exception.getMessage(), exception);
            }
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getInputSize() {
            Utils.approveModeCheck(this.parameters.getAlgorithm());
            AsymmetricBlockCipher asymmetricBlockCipher = this.getEngine();
            if (GuardedAsymmetricOperatorFactory.isRawEngine(asymmetricBlockCipher)) {
                return asymmetricBlockCipher.getInputBlockSize() + 1;
            }
            return asymmetricBlockCipher.getInputBlockSize();
        }

        @Override
        public int getOutputSize() {
            Utils.approveModeCheck(this.parameters.getAlgorithm());
            return this.getEngine().getOutputBlockSize();
        }

        @Override
        public SingleBlockEncryptorUsingSecureRandom<T> withSecureRandom(SecureRandom secureRandom) {
            Utils.approveModeCheck(this.parameters.getAlgorithm());
            return new BlockEncryptor(this.this$0, this.key, this.parameters, secureRandom);
        }
    }
}

