/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class SP80038FWrapWithPaddingEngine
extends SP80038FWrapper {
    public SP80038FWrapWithPaddingEngine(BlockCipher blockCipher, boolean bl2) {
        super(blockCipher, ivKWP, bl2);
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KWP";
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n4 = (n3 + 7) / 8;
        int n5 = n4 * 8 - n3;
        byte[] byArray2 = new byte[n3 + this.iv.length + 4 + n5];
        byte[] byArray3 = Pack.intToBigEndian(n3);
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray3, 0, byArray2, this.iv.length, byArray3.length);
        System.arraycopy(byArray, n2, byArray2, this.iv.length + 4, n3);
        if (n4 == 1) {
            this.engine.init(this.wrapCipherMode, this.param);
            this.engine.processBlock(byArray2, 0, byArray2, 0);
            return byArray2;
        }
        return this.W(n4, byArray2);
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n4 = n3 / 8;
        if (n4 * 8 != n3) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray3 = new byte[this.iv.length + 4];
        byte[] byArray4 = new byte[n3 - byArray3.length];
        if (n4 == 2) {
            byArray2 = new byte[this.engine.getBlockSize()];
            this.engine.init(!this.wrapCipherMode, this.param);
            this.engine.processBlock(byArray, n2, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
        } else {
            System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n2 + byArray3.length, byArray4, 0, n3 - byArray3.length);
            this.invW(n4, byArray4, byArray3);
        }
        byArray2 = new byte[this.iv.length];
        System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        int n5 = Pack.bigEndianToInt(byArray3, 4);
        int n6 = 8 * (n4 - 1) - n5;
        if (!Arrays.constantTimeAreEqual(byArray2, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        if (n6 < 0 || n6 > 7) {
            throw new InvalidCipherTextException("unwrap data has incorrect padding length");
        }
        byte[] byArray5 = new byte[n5];
        System.arraycopy(byArray4, 0, byArray5, 0, n5);
        boolean bl2 = false;
        for (int i2 = 1; i2 <= n6; ++i2) {
            if (byArray4[byArray4.length - i2] == 0) continue;
            bl2 = true;
        }
        if (bl2) {
            throw new InvalidCipherTextException("unwrap data has incorrect padding");
        }
        return byArray5;
    }
}

