/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.ChaCha20;
import org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;

final class ProvChaCha20
extends AlgorithmProvider {
    private static final String PREFIX = ProvChaCha20.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvChaCha20() {
    }

    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.CHACHA20", PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "ChaCha20", 256, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new ChaCha20.KeyGenerator(secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "CHACHA20", "CHACHA7539");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.CHACHA20", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("ChaCha20");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "CHACHA20", "CHACHA7539");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.CHACHA20", PREFIX + "$AlgParamGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "ChaCha20", 12);
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameterGenerator", "CHACHA20", "CHACHA7539");
        final Class[] classArray = new Class[]{IvParameterSpec.class};
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CHACHA20", PREFIX + "$Base", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 96, ChaCha20.STREAM).withParameters(classArray).withGeneralOperators(ProvChaCha20.this.generalParametersCreatorProvider, new ChaCha20.OperatorFactory(), null).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "CHACHA20", "CHACHA7539");
    }
}

