/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Color;
import com.aspose.pdf.Document;
import com.aspose.pdf.Font;
import com.aspose.pdf.FontRepository;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Redaction;
import com.aspose.pdf.XForm;
import com.aspose.pdf.internal.p645.z6;
import com.aspose.pdf.internal.p77.z14;
import com.aspose.pdf.internal.p77.z16;
import com.aspose.pdf.internal.p77.z21;
import com.aspose.pdf.internal.p77.z23;
import com.aspose.pdf.internal.p77.z24;
import com.aspose.pdf.internal.p77.z28;
import com.aspose.pdf.internal.p77.z30;
import com.aspose.pdf.internal.p77.z37;
import com.aspose.pdf.internal.p77.z9;
import com.aspose.pdf.internal.p820.z5;
import java.util.List;

public final class RedactionAnnotation
extends Annotation {
    RedactionAnnotation(z14 engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    public RedactionAnnotation(IDocument document) {
        super(document);
        this.getEngineDict().m2("Subtype", (z16)new z28("Redact"));
    }

    public Point[] getQuadPoint() {
        if (this.getEngineDict().m4("QuadPoints")) {
            com.aspose.pdf.internal.p77.z5 z5100 = this.getEngineDict().m3("QuadPoints").m65();
            int n = z5100.m10() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(z5100.m1(2 * i).m70().m8(), z5100.m1(2 * i + 1).m70().m8());
            }
            return pointArray;
        }
        return null;
    }

    public void setQuadPoint(Point[] value) {
        z23 z2310 = new z23(this.getEngineDict());
        for (Point point : value) {
            z2310.m1((z16)new z30(point.getX()));
            z2310.m1((z16)new z30(point.getY()));
        }
        this.getEngineDict().m1("QuadPoints", (z16)z2310);
        this.updateAppearances();
    }

    public RedactionAnnotation(Page page, Rectangle rect) {
        super(page, rect);
        this.getEngineDict().m2("Subtype", (z16)new z28("Redact"));
        this.updateAppearances();
    }

    public Color getFillColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().m4("IC")) {
            z16 z1610 = this.getEngineDict().m2("IC");
            if (z1610.m65() == null) {
                return color;
            }
            if (z1610.m65().m10() < 3) {
                return color;
            }
            color = new Color(new double[]{z1610.m65().m1(0).m70().m8(), z1610.m65().m1(1).m70().m8(), z1610.m65().m1(2).m70().m8()});
        }
        return color;
    }

    public void setFillColor(Color value) {
        this.getEngineDict().m1("IC", (z16)new z23((z21)((Object)z5.m1(this.getEngineDict(), z21.class)), new z30[]{new z30(z5.m10(value.m2().m14(), 6) / 255.0), new z30(z5.m10(value.m2().m15(), 6) / 255.0), new z30(z5.m10(value.m2().m16(), 6) / 255.0)}));
    }

    public Color getBorderColor() {
        Color color = Color.getBlack();
        if (this.getEngineDict().m4("OC")) {
            z16 z1610 = this.getEngineDict().m2("OC");
            if (z1610.m65() == null) {
                return color;
            }
            if (z1610.m65().m10() < 3) {
                return color;
            }
            color = new Color(new double[]{z1610.m65().m1(0).m70().m8() / 255.0, z1610.m65().m1(1).m70().m8() / 255.0, z1610.m65().m1(2).m70().m8() / 255.0});
        }
        return color;
    }

    public void setBorderColor(Color value) {
        this.getEngineDict().m1("OC", (z16)new z23((z21)((Object)z5.m1(this.getEngineDict(), z21.class)), new z30[]{new z30(z5.m10(value.m2().m14(), 6)), new z30(z5.m10(value.m2().m15(), 6)), new z30(z5.m10(value.m2().m16(), 6))}));
    }

    public String getOverlayText() {
        z16 z1610;
        if (this.getEngineDict().m4("OverlayText") && (z1610 = this.getEngineDict().m2("OverlayText")).m62() != null) {
            return z1610.m62().m8();
        }
        return null;
    }

    public void setOverlayText(String value) {
        z37 z3710 = new z37((z21)((Object)z5.m1(this.getEngineDict(), z21.class)), value);
        this.getEngineDict().m1("OverlayText", (z16)z3710);
        this.updateAppearances();
    }

    public boolean isRepeat() {
        if (this.getEngineDict().m4("Repeat") && this.getEngineDict().m2("Repeat").m67() != null) {
            return this.getEngineDict().m2("Repeat").m67().m2();
        }
        return false;
    }

    public void setRepeat(boolean value) {
        this.getEngineDict().m1("Repeat", (z16)new z24(value));
        this.updateAppearances();
    }

    public int getTextAlignment() {
        int n = 1;
        if (this.getEngineDict().m4("Q") && this.getEngineDict().m2("Q").m70() != null) {
            switch (this.getEngineDict().m2("Q").m70().m2()) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                }
            }
        }
        return n;
    }

    public void setTextAlignment(int value) {
        int n = 0;
        switch (value) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
            }
        }
        this.getEngineDict().m1("Q", (z16)new z30(n));
    }

    @Override
    boolean m5() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void m1(Annotation annotation) {
        if (this._disableUpdateAppearance) {
            return;
        }
        XForm xForm = this.m1("N", annotation);
        XForm xForm2 = this.m1("R", annotation);
        xForm2.getResources().getFonts().add("Helv", "Helvetica");
        Document.startOperation();
        try {
            xForm.getContents().add(this.m3(new Annotation.z1("N"), annotation));
            xForm2.getContents().add(this.m3(new Annotation.z1("R"), annotation));
        }
        finally {
            Document.endOperation();
        }
    }

    com.aspose.pdf.internal.ms.System.Collections.Generic.z16<Operator> m3(Annotation.z1 z1100, Annotation annotation) {
        com.aspose.pdf.internal.ms.System.Collections.Generic.z16<Operator> z1610 = new com.aspose.pdf.internal.ms.System.Collections.Generic.z16<Operator>();
        z1610.addItem(new Operator.GSave());
        if ("R".equals(z1100.m1)) {
            z1610.addItem(new Operator.SetRGBColor(this.getFillColor().toRgb()));
            z1610.addItem(new Operator.SetRGBColorStroke(this.getFillColor().toRgb()));
            z1610.addItem(new Operator.Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            z1610.addItem(new Operator.ClosePathFillStroke());
            if (this.getOverlayText() != null) {
                z1610.addItem(new Operator.BT());
                z1610.addItem(new Operator.SetRGBColor(this.getColor().toRgb()));
                z1610.addItem(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
                double d = 10.0;
                double d2 = this.getRect().getHeight();
                double d3 = 0.0;
                Font font = FontRepository.findFont("Helvetica");
                switch (this.getTextAlignment()) {
                    case 1: {
                        d3 = 0.0;
                        break;
                    }
                    case 2: {
                        d3 = (this.getWidth() - font.m2().m1(this.getOverlayText(), d)) / 2.0;
                        break;
                    }
                    case 3: {
                        d3 = this.getWidth() - font.m2().m1(this.getOverlayText(), d);
                    }
                }
                z1610.addItem(new Operator.SelectFont("Helv", d));
                z1610.addItem(new Operator.MoveTextPosition(d3, d2));
                do {
                    z1610.addItem(new Operator.MoveTextPosition(0.0, -d));
                    z1610.addItem(new Operator.ShowText(this.getOverlayText()));
                } while (this.isRepeat() && (d2 -= d) > 0.0);
                z1610.addItem(new Operator.ET());
            }
        } else if ("N".equals(z1100.m1)) {
            z1610.addItem(new Operator.SetRGBColor(this.getBorderColor().toRgb()));
            z1610.addItem(new Operator.SetRGBColorStroke(this.getBorderColor().toRgb()));
            z1610.addItem(new Operator.SetLineWidth(5.0));
            z1610.addItem(new Operator.Re(0.0, 0.0, this.getRect().getWidth(), this.getRect().getHeight()));
            z1610.addItem(new Operator.ClosePathStroke());
        }
        z1610.addItem(new Operator.GRestore());
        return z1610;
    }

    @Override
    public void flatten() {
        z9 z910 = this.getEngineDict().m2("AP").m64();
        z910.m1("N", z910.m2("R"));
        super.flatten();
    }

    public void redact() {
        Redaction.redactText(this.m6(), this.getRect());
        Redaction.m1(this.m6(), this.getRect(), z6.m25().m158());
        this.flatten();
    }

    @Override
    public int getAnnotationType() {
        return 23;
    }

    @Override
    /* synthetic */ List m2(Annotation.z1 z1100, Annotation annotation) {
        return this.m3(z1100, annotation);
    }
}

