/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.ADocument;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LoadOptions;
import com.aspose.pdf.SaveOptions;
import com.aspose.pdf.exceptions.PdfException;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.l10l;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;

public final class DocumentWeb
extends ADocument
implements IDocument {
    private static final Logger lb = Logger.getLogger(DocumentWeb.class.getName());

    public DocumentWeb() {
    }

    public DocumentWeb(InputStream input) {
        super(input);
    }

    public DocumentWeb(InputStream input, String password) {
        super(input, password);
    }

    DocumentWeb(Stream input) {
        super(input);
    }

    public DocumentWeb(InputStream input, LoadOptions options) {
        super(Stream.fromJava(input), options);
    }

    DocumentWeb(Stream input, LoadOptions options) {
        super(input, options);
    }

    public DocumentWeb(String filename, LoadOptions options) {
        super(filename, options);
    }

    DocumentWeb(Stream input, String password) {
        super(input, password);
    }

    public DocumentWeb(String filename) {
        super(filename);
    }

    public DocumentWeb(String filename, String password) {
        super(filename, password);
    }

    public void save(HttpServletResponse response, String outputFileName, int disposition, SaveOptions options) {
        this.lI(response, outputFileName, disposition, options);
    }

    private void lI(HttpServletResponse httpServletResponse, String string, int n, SaveOptions saveOptions) {
        this.l0j();
        httpServletResponse.reset();
        httpServletResponse.resetBuffer();
        switch (n) {
            case 1: {
                httpServletResponse.addHeader("content-disposition", l10l.lI(new String[]{"attachment; filename=", string}));
                break;
            }
            case 0: {
                httpServletResponse.addHeader("content-disposition", l10l.lI(new String[]{"inline; filename=", string}));
                break;
            }
            default: {
                throw new PdfException("Unsupported content-disposition value");
            }
        }
        switch (saveOptions.getSaveFormat()) {
            case 0: {
                httpServletResponse.setContentType("application/pdf");
                break;
            }
            case 1: {
                httpServletResponse.setContentType("application/msword");
                break;
            }
            case 3: {
                httpServletResponse.setContentType("text/html");
                break;
            }
            case 2: {
                httpServletResponse.setContentType("application/vnd.ms-xpsdocument");
                break;
            }
            case 7: {
                httpServletResponse.setContentType("image/svg+xml");
                break;
            }
            default: {
                throw new PdfException("Unsupported options for saving pdf on web");
            }
        }
        try {
            l1j l1j2 = new l1j();
            this.lI((Stream)l1j2, saveOptions);
            httpServletResponse.getOutputStream().write(l1j2.lt());
            httpServletResponse.flushBuffer();
            l1j2.dispose();
        }
        catch (Exception exception) {
            lb.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception);
        }
    }

    static {
        lb.setUseParentHandlers(false);
    }
}

