/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.internal.l5n.l0h;
import com.aspose.pdf.internal.l5n.l0n;
import com.aspose.pdf.internal.l5n.l0t;
import com.aspose.pdf.internal.l5n.l1u;
import com.aspose.pdf.internal.l5n.lb;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.lh;

public final class Matrix {
    private double[] lI;

    public final double[] getData() {
        return this.lI;
    }

    public double getA() {
        return this.lI[0];
    }

    public void setA(double value) {
        this.lI[0] = value;
    }

    public double getB() {
        return this.lI[1];
    }

    public void setB(double value) {
        this.lI[1] = value;
    }

    public double getC() {
        return this.lI[2];
    }

    public void setC(double value) {
        this.lI[2] = value;
    }

    public double getD() {
        return this.lI[3];
    }

    public void setD(double value) {
        this.lI[3] = value;
    }

    public double getE() {
        return this.lI[4];
    }

    public void setE(double value) {
        this.lI[4] = value;
    }

    public double getF() {
        return this.lI[5];
    }

    public void setF(double value) {
        this.lI[5] = value;
    }

    public Matrix() {
        this.lI = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    public Matrix(double[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new lh();
        }
        this.lI = matrixArray;
    }

    public Matrix(float[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new lh();
        }
        this.lI = new double[6];
        for (int i = 0; i < 6; ++i) {
            this.lI[i] = matrixArray[i];
        }
    }

    public Matrix(Matrix matrix) {
        this.lI = matrix.lI;
    }

    public float[] getElements() {
        return new float[]{(float)this.lI[0], (float)this.lI[1], (float)this.lI[2], (float)this.lI[3], (float)this.lI[4], (float)this.lI[5]};
    }

    public String toString() {
        return l10l.lI("[ {0}, {1}, {2}, {3}, {4}, {5} ]", this.getA(), this.getB(), this.getC(), this.getD(), this.getE(), this.getF());
    }

    public boolean equals(Object obj) {
        Matrix matrix = (Matrix)((Object)com.aspose.pdf.internal.l82h.lb.lI(obj, Matrix.class));
        if (matrix != null) {
            return Double.compare(matrix.getA(), this.getA()) == 0 && Double.compare(matrix.getB(), this.getB()) == 0 && Double.compare(matrix.getC(), this.getC()) == 0 && Double.compare(matrix.getD(), this.getD()) == 0 && Double.compare(matrix.getE(), this.getE()) == 0 && Double.compare(matrix.getF(), this.getF()) == 0;
        }
        return super.equals(obj);
    }

    public lb getMatrix(l0h trailer) {
        l0n l0n2 = new l0n(trailer);
        l0n2.lI((l0t)new l1u(this.getA()));
        l0n2.lI((l0t)new l1u(this.getB()));
        l0n2.lI((l0t)new l1u(this.getC()));
        l0n2.lI((l0t)new l1u(this.getD()));
        l0n2.lI((l0t)new l1u(this.getE()));
        l0n2.lI((l0t)new l1u(this.getF()));
        return l0n2;
    }

    public static Matrix rotation(double alpha) {
        return new Matrix(new double[]{l13p.le(alpha), l13p.lu(alpha), -l13p.lu(alpha), l13p.le(alpha), 0.0, 0.0});
    }

    public static Matrix skew(double alpha, double beta) {
        return new Matrix(new double[]{1.0, l13p.lh(alpha), l13p.lh(alpha), 1.0, 0.0, 0.0});
    }

    public static Matrix scale(double x, double y) {
        return new Matrix(new double[]{x, 0.0, 0.0, y, 0.0, 0.0});
    }

    public static double getAngle(int rotation) {
        double d = 0.0;
        switch (rotation) {
            case 1: {
                d = 1.5707963267948966;
                break;
            }
            case 2: {
                d = Math.PI;
                break;
            }
            case 3: {
                d = 4.71238898038469;
                break;
            }
        }
        return d;
    }

    static double lI(Matrix matrix) {
        double d = 1.0E-5;
        double d2 = 1.5707963267948966 * (double)l13p.ld(matrix.getB());
        if (l13p.lI(matrix.getB()) < d) {
            d2 = 0.0;
        } else if (l13p.lI(matrix.getA()) >= d) {
            d2 = l13p.l0l(matrix.getB() / matrix.getA());
        }
        if (matrix.getA() < -1.0 * d) {
            d2 += Math.PI;
        }
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    private double[] lI() {
        double[] dArray = new double[]{this.getA(), this.getB(), 0.0, this.getC(), this.getD(), 0.0, this.getE(), this.getF(), 1.0};
        return dArray;
    }

    public Matrix multiply(Matrix other) {
        double[] dArray = this.lI();
        double[] dArray2 = other.lI();
        double[] dArray3 = new double[9];
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray[i * n + k] * dArray2[k * n + j];
                }
                dArray3[i * n + j] = d;
            }
        }
        return new Matrix(new double[]{dArray3[0], dArray3[1], dArray3[3], dArray3[4], dArray3[6], dArray3[7]});
    }

    public Matrix add(Matrix other) {
        return new Matrix(this.getA() + other.getA(), this.getB() + other.getB(), this.getC() + other.getC(), this.getD() + other.getD(), this.getE() + other.getE(), this.getF() + other.getF());
    }

    public Point transform(Point p) {
        return new Point(p.getX() * this.getA() + p.getY() * this.getC() + this.getE(), p.getX() * this.getB() + p.getY() * this.getD() + this.getF());
    }

    public Rectangle transform(Rectangle rect) {
        Point[] pointArray = new Point[]{new Point(rect.getLLX(), rect.getLLY()), new Point(rect.getLLX(), rect.getURY()), new Point(rect.getURX(), rect.getLLY()), new Point(rect.getURX(), rect.getURY())};
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = this.transform(pointArray[i]);
            if (i == 0) {
                d = d2 = point.getX();
                d3 = d4 = point.getY();
                continue;
            }
            d = l13p.lt(d, point.getX());
            d2 = l13p.lj(d2, point.getX());
            d3 = l13p.lt(d3, point.getY());
            d4 = l13p.lj(d4, point.getY());
        }
        return new Rectangle(d, d3, d2, d4);
    }

    public Matrix(double a, double b, double c, double d, double e, double f) {
        this(new double[]{a, b, c, d, e, f});
    }

    public Matrix reverse() {
        double d = this.getA() * this.getD() - this.getC() * this.getB();
        return new Matrix(this.getD() / d, -this.getB() / d, -this.getC() / d, this.getA() / d, (this.getC() * this.getF() - this.getE() * this.getD()) / d, -(this.getA() * this.getF() - this.getE() * this.getB()) / d);
    }

    public int hashCode() {
        return super.hashCode();
    }

    lb lI(l0h l0h2) {
        l0t[] l0tArray = new l0t[this.lI.length];
        for (int i = 0; i < this.lI.length; ++i) {
            l0tArray[i] = new l1u(this.lI[i]);
        }
        l0n l0n2 = new l0n(l0h2, l0tArray);
        return l0n2;
    }

    Matrix(lb data) {
        if (data.lv() != 6) {
            throw new lh("Matrix array must have 6 elements");
        }
        this.lI = new double[6];
        for (int i = 1; i <= 6; ++i) {
            if (data.lI(i).l5j() == null) {
                throw new lh("Matrix array must contain only numbers");
            }
            this.lI[i - 1] = data.lI(i).l5j().lu();
        }
    }

    public static boolean isInt16(double value) {
        return value < 32767.0 && value > -32768.0;
    }

    public boolean isInt16Values() {
        return Matrix.isInt16(this.getA()) && Matrix.isInt16(this.getB()) && Matrix.isInt16(this.getC()) && Matrix.isInt16(this.getD()) && Matrix.isInt16(this.getE()) && Matrix.isInt16(this.getF());
    }
}

