/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.devices;

import com.aspose.pdf.Page;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.devices.PageDevice;
import com.aspose.pdf.internal.l70y.l0p;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.l7f;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public final class TextDevice
extends PageDevice {
    private static final Logger lI = Logger.getLogger(TextDevice.class.getName());
    private TextExtractionOptions lf;
    private l0p lj;

    private void lI(TextExtractionOptions textExtractionOptions, l0p l0p2) {
        this.lf = textExtractionOptions;
        this.lj = l0p2;
    }

    public TextExtractionOptions getExtractionOptions() {
        return this.lf;
    }

    public void setExtractionOptions(TextExtractionOptions value) {
        this.lf = value;
    }

    public TextEncodingInternal getEncodingInternal() {
        if (l0p.l0j().equals(this.lj)) {
            return TextEncodingInternal.getASCII();
        }
        if (l0p.l0h().equals(this.lj)) {
            return TextEncodingInternal.getBigEndianUnicode();
        }
        if (l0p.l0y().equals(this.lj)) {
            return TextEncodingInternal.getDefault();
        }
        if (l0p.l1l().equals(this.lj)) {
            return TextEncodingInternal.getUnicode();
        }
        if (l0p.l1t().equals(this.lj)) {
            return TextEncodingInternal.getUTF32();
        }
        if (l0p.l1v().equals(this.lj)) {
            return TextEncodingInternal.getUTF32BE();
        }
        if (l0p.l0n().equals(this.lj)) {
            return TextEncodingInternal.getUTF7();
        }
        if (l0p.l0k().equals(this.lj)) {
            return TextEncodingInternal.getUTF8();
        }
        if (l0p.l0f().equals(this.lj)) {
            return TextEncodingInternal.getUTF8Unmarked();
        }
        return null;
    }

    public Charset getEncoding() {
        return l0p.lI(this.lj);
    }

    public void setEncodingInternal(TextEncodingInternal value) {
        this.lj = value.getInternalFormat();
    }

    public void setEncoding(Charset value) {
        this.setEncodingInternal(TextEncodingInternal.getEncoding(value.displayName()));
    }

    @Override
    public void processInternal(Page page, Stream output) {
        if (page == null) {
            throw new l7f("Page is null");
        }
        TextAbsorber textAbsorber = new TextAbsorber(this.lf);
        textAbsorber.visit(page);
        byte[] byArray = this.lj.lj(textAbsorber.getText());
        output.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Page page, OutputStream output) {
        this.processInternal(page, l1j2);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            output.write(byArray);
        }
    }

    public TextDevice(TextExtractionOptions extractionOptions) {
        this.lI(extractionOptions, l0p.l1l());
    }

    public TextDevice() {
        this.lI(new TextExtractionOptions(0), l0p.l1l());
    }

    public TextDevice(TextEncodingInternal encoding) {
        this.lI(new TextExtractionOptions(0), encoding.getInternalFormat());
    }

    public TextDevice(Charset encoding) {
        this(TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    public TextDevice(TextExtractionOptions extractionOptions, TextEncodingInternal encoding) {
        this.lI(extractionOptions, encoding.getInternalFormat());
    }

    public TextDevice(TextExtractionOptions extractionOptions, Charset encoding) {
        this(extractionOptions, TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    static {
        lI.setUseParentHandlers(false);
    }
}

