/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.exceptions.PdfException;
import com.aspose.pdf.facades.AlignmentType;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.facades.VerticalAlignmentType;
import com.aspose.pdf.internal.l1v.l0l;
import com.aspose.pdf.internal.l1v.l0u;
import com.aspose.pdf.internal.l5n.l0if;
import com.aspose.pdf.internal.l5n.l0t;
import com.aspose.pdf.internal.l5n.l1l;
import com.aspose.pdf.internal.l5n.l1u;
import com.aspose.pdf.internal.l5n.l1v;
import com.aspose.pdf.internal.l5n.lh;
import com.aspose.pdf.internal.l68l.l13j;
import com.aspose.pdf.internal.l82h.lb;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lf;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.l1j;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l13p;
import com.aspose.pdf.internal.ms.System.l7k;
import com.aspose.pdf.operators.ConcatenateMatrix;
import com.aspose.pdf.operators.Do;
import com.aspose.pdf.operators.GRestore;
import com.aspose.pdf.operators.GSave;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class PdfPageEditor
extends SaveableFacade {
    private static final Logger lI = Logger.getLogger(PdfPageEditor.class.getName());
    private static final int lf = 1;
    private static final int lj = 2;
    private static final int lt = 4;
    private int lb = 0;
    private int ld;
    private int lu;
    private int le;
    private int[] lh = null;
    private int lk = 0;
    private lf<Integer, Integer> lc = new lf();
    private float ly = 1.0f;
    private PageSize l0if;
    private int l0l = 1;
    private int l0t = 3;
    private Point l0v = null;
    public static final int SPLITVOUT = 1;
    public static final int SPLITHOUT = 2;
    public static final int SPLITVIN = 3;
    public static final int SPLITHIN = 4;
    public static final int BLINDV = 5;
    public static final int BLINDH = 6;
    public static final int INBOX = 7;
    public static final int OUTBOX = 8;
    public static final int LRWIPE = 9;
    public static final int RLWIPE = 10;
    public static final int BTWIPE = 11;
    public static final int TBWIPE = 12;
    public static final int DISSOLVE = 13;
    public static final int LRGLITTER = 14;
    public static final int TBGLITTER = 15;
    public static final int DGLITTER = 16;
    private static final String l0p = "Invalid rotate value. Page rotate must be  expressed in degrees and be multiple of 90.";
    private static final com.aspose.pdf.internal.l82h.lh l0u;

    public PdfPageEditor() {
    }

    public PdfPageEditor(Document document) {
        super(document);
    }

    public int getTransitionDuration() {
        this.lt();
        return this.le;
    }

    public void setTransitionDuration(int value) {
        this.lt();
        this.lb |= 1;
        this.le = value;
    }

    public int getTransitionType() {
        this.lt();
        return this.lu;
    }

    public void setTransitionType(int value) {
        this.lt();
        this.lb |= 2;
        this.lu = value;
    }

    public int getDisplayDuration() {
        this.lt();
        return this.ld;
    }

    public void setDisplayDuration(int value) {
        this.lt();
        this.lb |= 4;
        this.ld = value;
    }

    public int[] getProcessPages() {
        this.lt();
        return this.lh;
    }

    public void setProcessPages(int[] value) {
        this.lh = value;
    }

    public int getRotation() {
        this.lt();
        if (this.lk < 0) {
            this.lt();
            this.lk = Page.rotationToInt(this.getDocument().getPages().get_Item(0).getRotate());
        }
        return this.lk;
    }

    public void setRotation(int value) {
        this.lt();
        this.lj(value);
        this.lk = value;
    }

    public Map<Integer, Integer> getPageRotations() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        lf.lf.lI lI2 = ((lf.lf)this.lI().getKeys()).lI();
        while (lI2.hasNext()) {
            Integer n = (Integer)lI2.next();
            hashMap.put(n, this.lI().get_Item(n));
        }
        return hashMap;
    }

    lf<Integer, Integer> lI() {
        this.lt();
        if (this.lc == null) {
            this.lc = new lf();
        }
        return this.lc;
    }

    public void setPageRotations(Map<Integer, Integer> value) {
        lf<Integer, Integer> lf2 = new lf<Integer, Integer>();
        for (Integer n : value.keySet()) {
            lf2.addItem(n, value.get(n));
        }
        this.lI(lf2);
    }

    void lI(lf<Integer, Integer> lf2) {
        this.lt();
        this.lf(lf2);
        this.lc = lf2;
    }

    public float getZoom() {
        this.lt();
        return this.ly;
    }

    public void setZoom(float value) {
        this.ly = value;
    }

    public PageSize getPageSize() {
        this.lt();
        if (this.l0if == null) {
            this.l0if = new PageSize(-1.0f, -1.0f);
        }
        return this.l0if;
    }

    public void setPageSize(PageSize value) {
        this.lt();
        this.l0if = value;
    }

    @Deprecated
    public AlignmentType getAlignment() {
        int n = this.getHorizontalAlignment();
        switch (n) {
            case 1: {
                return AlignmentType.Left;
            }
            case 2: {
                return AlignmentType.Center;
            }
            case 3: {
                return AlignmentType.Right;
            }
        }
        throw new PdfException("Unknown Alignment type");
    }

    @Deprecated
    public void setAlignment(AlignmentType value) {
        AlignmentType alignmentType = value;
        switch (l0u.lI(alignmentType.toString())) {
            case 0: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(1);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(3);
                break;
            }
            default: {
                throw new l7k("Center, Right, Left values are valid only");
            }
        }
    }

    public int getHorizontalAlignment() {
        this.lt();
        return this.l0l;
    }

    public void setHorizontalAlignment(int value) {
        this.lt();
        this.l0l = value;
    }

    @Deprecated
    public VerticalAlignmentType getVerticalAlignment() {
        int n = this.getVerticalAlignmentType();
        switch (n) {
            case 1: {
                return VerticalAlignmentType.Top;
            }
            case 2: {
                return VerticalAlignmentType.Center;
            }
            case 3: {
                return VerticalAlignmentType.Bottom;
            }
        }
        throw new PdfException("Unknown Alignment type");
    }

    @Deprecated
    public void setVerticalAlignment(VerticalAlignmentType value) {
        VerticalAlignmentType verticalAlignmentType = value;
        switch (l0u.lI(verticalAlignmentType.toString())) {
            case 3: {
                this.setVerticalAlignmentType(1);
                break;
            }
            case 4: {
                this.setVerticalAlignmentType(3);
                break;
            }
            case 0: {
                this.setVerticalAlignmentType(2);
                break;
            }
            default: {
                this.setVerticalAlignmentType(0);
            }
        }
    }

    public int getVerticalAlignmentType() {
        this.lt();
        return this.l0t;
    }

    public void setVerticalAlignmentType(int value) {
        this.lt();
        this.l0t = value;
    }

    public void movePosition(float moveX, float moveY) {
        this.lt();
        this.l0v = new Point(moveX, moveY);
    }

    public int getPages() {
        this.lt();
        return this.getDocument().getPages().size();
    }

    public PageSize getPageSize(int page) {
        this.lt();
        l0l l0l2 = this.getDocument().getPages().get_Item((int)page).EnginePage.r_();
        l0u l0u2 = null;
        if (l0l2.lt() != null) {
            l0u2 = l0l2.lt();
        } else if (l0l2.lj() != null) {
            l0u2 = l0l2.lj();
        } else {
            throw new com.aspose.pdf.internal.ms.System.lh("Page doesn't have required entry MediaBox");
        }
        double d = l13p.lI(l0u2.lt() - l0u2.lf());
        double d2 = l13p.lI(l0u2.lb() - l0u2.lj());
        for (int i = Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate()); i > 0; i -= 90) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return new PageSize((float)d, (float)d2);
    }

    public int getPageRotation(int page) {
        this.lt();
        return Page.rotationToInt(this.getDocument().getPages().get_Item(page).getRotate());
    }

    public java.awt.Rectangle getPageBoxSize(int page, String pageBoxName) {
        return this.lI(page, pageBoxName).lI();
    }

    l13j lI(int n, String string) {
        this.lt();
        switch (l0u.lI(string)) {
            case 5: {
                return this.lI(this.getDocument().getPages().get_Item(n).getTrimBox());
            }
            case 6: {
                return this.lI(this.getDocument().getPages().get_Item(n).getArtBox());
            }
            case 7: {
                return this.lI(this.getDocument().getPages().get_Item(n).getBleedBox());
            }
            case 8: {
                return this.lI(this.getDocument().getPages().get_Item(n).getCropBox());
            }
            case 9: {
                return this.lI(this.getDocument().getPages().get_Item(n).getMediaBox());
            }
        }
        throw new com.aspose.pdf.internal.ms.System.lh(l10l.lI("\"{0}\" is invalid box name", new Object[]{string}));
    }

    @Override
    public void save(String outputFile) {
        this.lf();
        super.save(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream outputStream) {
        this.lI(l1j2);
        try (l1j l1j2 = new l1j();){
            if (((Stream)l1j2).canSeek()) {
                ((Stream)l1j2).seek(0L, 0);
            }
            byte[] byArray = new byte[l1j2.toInputStream().available()];
            l1j2.toInputStream().read(byArray);
            outputStream.write(byArray);
        }
    }

    @Override
    void lI(Stream stream) {
        this.lf();
        super.lI(stream);
    }

    public void applyChanges() {
        this.lf();
        this.lh = new int[0];
    }

    private void lf() {
        this.lt();
        if (this.lh == null) {
            for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
                this.lf(i);
            }
        } else {
            for (int n : this.lh) {
                this.lf(n);
            }
        }
    }

    private int lI(int n) {
        int n2 = this.lk;
        if (this.lI().containsKey(n)) {
            n2 = this.lI().get_Item(n);
        }
        return n2 % 360;
    }

    private boolean lI(Page page, String string) {
        return ((l0if)((Object)com.aspose.pdf.internal.l82h.lb.lI(page.EnginePage, l0if.class))).l5if().lf(string) != null;
    }

    private Rectangle lI(l0u l0u2) {
        return new Rectangle(l0u2.lf(), l0u2.lj(), l0u2.lt(), l0u2.lb());
    }

    private Rectangle lI(Page page) {
        l0u l0u2 = null;
        if (page.EnginePage.r_().lj() != null) {
            l0u2 = page.EnginePage.r_().lj();
        }
        if (page.EnginePage.r_().lt() != null) {
            l0u2 = page.EnginePage.r_().lt();
        }
        Rectangle rectangle = this.lI(l0u2);
        Matrix matrix = Matrix.rotation(-Matrix.getAngle(page.getRotate()));
        Rectangle rectangle2 = new Rectangle(0.0, 0.0, rectangle.getWidth(), rectangle.getHeight());
        rectangle2 = matrix.transform(rectangle2);
        matrix.setE(matrix.getE() - rectangle2.getLLX());
        matrix.setF(matrix.getF() - rectangle2.getLLY());
        rectangle = matrix.transform(rectangle);
        return rectangle;
    }

    private void lf(int n) {
        Object object;
        Page page = this.getDocument().getPages().get_Item(n);
        XForm xForm = XForm.createNewForm(page, this.getDocument());
        xForm.getContents().insert(1, new GSave());
        xForm.getContents().add(new GRestore());
        page.getResources().getForms().add(xForm);
        xForm.setBBox(page.getMediaBox());
        page.clearContents();
        Matrix matrix = new Matrix(new double[]{this.ly, 0.0, 0.0, this.ly, 0.0, 0.0});
        int n2 = this.lI(n);
        Matrix matrix2 = Matrix.rotation(Math.PI * (double)(-n2) / 180.0);
        matrix = matrix2.multiply(matrix);
        Rectangle rectangle = this.lI(page);
        Rectangle rectangle2 = new Rectangle(rectangle.getLLX(), rectangle.getLLY(), rectangle.getURX(), rectangle.getURY());
        Rectangle rectangle3 = matrix2.transform(rectangle2);
        Rectangle rectangle4 = matrix.transform(rectangle2);
        matrix.setE(-rectangle4.getLLX());
        matrix.setF(-rectangle4.getLLY());
        PageSize pageSize = this.l0if != null ? new PageSize(this.l0if.getWidth(), this.l0if.getHeight()) : new PageSize((float)rectangle3.getWidth(), (float)rectangle3.getHeight());
        if (Float.compare(pageSize.getWidth(), -1.0f) == 0) {
            pageSize.setWidth((float)page.getRect().getWidth());
        }
        if (Float.compare(pageSize.getHeight(), -1.0f) == 0) {
            pageSize.setHeight((float)page.getRect().getHeight());
        }
        PageSize pageSize2 = new PageSize((float)rectangle4.getWidth(), (float)rectangle4.getHeight());
        Point point = new Point(0.0, 0.0);
        if (this.l0l == 3) {
            point.setX(pageSize.getWidth() - pageSize2.getWidth());
        } else if (this.l0l == 2) {
            point.setX((pageSize.getWidth() - pageSize2.getWidth()) / 2.0f);
        }
        if (this.l0t == 1) {
            point.setY(pageSize.getHeight() - pageSize2.getHeight());
        } else if (this.l0t == 2) {
            point.setY((pageSize.getHeight() - pageSize2.getHeight()) / 2.0f);
        }
        matrix.setE(matrix.getE() + point.getX());
        matrix.setF(matrix.getF() + point.getY());
        if (this.l0v != null) {
            matrix.setE(matrix.getE() + this.l0v.getX());
            matrix.setF(matrix.getF() + this.l0v.getY());
        }
        if (page.getRotate() == 3 || page.getRotate() == 1) {
            pageSize = new PageSize(pageSize.getHeight(), pageSize.getWidth());
        }
        page.setMediaBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        if (this.lI(page, "CropBox")) {
            page.setCropBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.lI(page, "ArtBox")) {
            page.setArtBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.lI(page, "BleedBox")) {
            page.setBleedBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if (this.lI(page, "TrimBox")) {
            page.setTrimBox(new Rectangle(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight()));
        }
        if ((this.lb & 2) != 0) {
            object = new lI(this.getDocument(), this.getTransitionType());
            if ((this.lb & 1) != 0) {
                ((lI)object).lI(this.getTransitionDuration());
            }
            page.setTransition(((lI)object).lf());
        }
        if ((this.lb & 4) != 0) {
            page.setDuration(this.getDisplayDuration());
        }
        object = new ArrayList();
        ((ArrayList)object).add(new GSave());
        ((ArrayList)object).add(new ConcatenateMatrix(matrix));
        ((ArrayList)object).add(new Do(xForm.getName()));
        ((ArrayList)object).add(new GRestore());
        page.getContents().add((Iterable<Operator>)object);
        for (Annotation annotation : page.getAnnotations()) {
            annotation.setRect(matrix.transform(annotation.getRect()));
            for (String string : annotation.getAppearance().getKeys()) {
                XForm xForm2 = annotation.getAppearance().get_Item(string);
                Matrix matrix3 = xForm2.getMatrix();
                if (matrix3 == null) {
                    matrix3 = new Matrix();
                }
                if (xForm2.getEngineObj().l5if().lt("BBox")) {
                    // empty if block
                }
                xForm2.setMatrix(matrix.multiply(matrix3));
            }
        }
    }

    private void lj(int n) {
        if (n % 90 != 0) {
            throw new com.aspose.pdf.internal.ms.System.lh(l0p);
        }
    }

    private void lf(lf<Integer, Integer> lf2) {
        lf.lf.lI lI2 = ((lf.lf)lf2.getKeys()).lI();
        while (lI2.hasNext()) {
            Integer n = (Integer)lI2.next();
            int n2 = lf2.get_Item(n);
            int n3 = n;
            int n4 = n2;
            this.lj(n4);
            this.getDocument().getPages().get_Item(n3);
        }
    }

    private l13j lI(Rectangle rectangle) {
        return new l13j((int)rectangle.getLLX(), (int)rectangle.getLLY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    static {
        lI.setUseParentHandlers(false);
        l0u = new com.aspose.pdf.internal.l82h.lh("Center", "Left", "Right", "Top", "Bottom", "trim", "art", "bleed", "crop", "media");
    }

    private static class lI {
        public int lI;
        public IDocument lf;
        public int lj = 1;

        public lI(IDocument iDocument, int n) {
            this.lI = n;
            this.lf = iDocument;
        }

        public int lI() {
            return this.lj;
        }

        public void lI(int n) {
            this.lj = n;
        }

        public lh lf() {
            l1l l1l2 = new l1l(this.lf.getEngineDoc().lf());
            l1l2.lf("Type", (l0t)new l1v("Trans"));
            l1l2.lf("D", (l0t)new l1u(this.lj));
            String string = l10l.lI;
            String string2 = null;
            String string3 = null;
            l1u l1u2 = null;
            switch (this.lI) {
                case 1: {
                    string = "Split";
                    string2 = "V";
                    string3 = "O";
                    break;
                }
                case 2: {
                    string = "Split";
                    string2 = "H";
                    string3 = "O";
                    break;
                }
                case 3: {
                    string = "Split";
                    string2 = "V";
                    string3 = "I";
                    break;
                }
                case 4: {
                    string = "Split";
                    string2 = "H";
                    string3 = "I";
                    break;
                }
                case 5: {
                    string = "Blinds";
                    string2 = "V";
                    break;
                }
                case 6: {
                    string = "Blinds";
                    string2 = "H";
                    break;
                }
                case 7: {
                    string = "Box";
                    string3 = "I";
                    break;
                }
                case 8: {
                    string = "Box";
                    string3 = "O";
                    break;
                }
                case 9: {
                    string = "Wipe";
                    l1u2 = new l1u(0.0);
                    break;
                }
                case 10: {
                    string = "Wipe";
                    l1u2 = new l1u(180.0);
                    break;
                }
                case 11: {
                    string = "Wipe";
                    l1u2 = new l1u(90.0);
                    break;
                }
                case 12: {
                    string = "Wipe";
                    l1u2 = new l1u(270.0);
                    break;
                }
                case 13: {
                    string = "Dissolve";
                    break;
                }
                case 14: {
                    string = "Glitter";
                    l1u2 = new l1u(0.0);
                    break;
                }
                case 15: {
                    string = "Glitter";
                    l1u2 = new l1u(270.0);
                    break;
                }
                case 16: {
                    string = "Glitter";
                    l1u2 = new l1u(315.0);
                    break;
                }
            }
            l1l2.lf("S", (l0t)new l1v(string));
            if (string2 != null) {
                l1l2.lf("Dm", (l0t)new l1v(string2));
            }
            if (string3 != null) {
                l1l2.lf("M", (l0t)new l1v(string3));
            }
            if (l1u2 != null) {
                l1l2.lf("Di", (l0t)l1u2);
            }
            return l1l2;
        }
    }
}

