/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html;

import com.aspose.pdf.internal.html.HTMLElement;
import com.aspose.pdf.internal.html.HTMLFormElement;
import com.aspose.pdf.internal.html.dom.DOMObject;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMNullableAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.l0t;
import com.aspose.pdf.internal.html.dom.lu;
import com.aspose.pdf.internal.html.io.IFileList;
import com.aspose.pdf.internal.html.io.lj;
import com.aspose.pdf.internal.html.lf;
import com.aspose.pdf.internal.l30k.lh;
import com.aspose.pdf.internal.l37f.lI;
import com.aspose.pdf.internal.l37f.lb;
import com.aspose.pdf.internal.l37f.ld;
import com.aspose.pdf.internal.l37f.lt;
import com.aspose.pdf.internal.l68h.l2p;
import com.aspose.pdf.internal.l68h.lv;
import com.aspose.pdf.internal.ms.System.Collections.Generic.lk;
import com.aspose.pdf.internal.ms.System.l10l;
import com.aspose.pdf.internal.ms.System.l3t;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l6u;
import com.aspose.pdf.internal.ms.System.l9n;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLInputElement")
public class HTMLInputElement
extends HTMLElement {
    private static final com.aspose.pdf.internal.l82h.lh gStringSwitchMap = new com.aspose.pdf.internal.l82h.lh("type", "checked", "multiple", "value", "name", "email", "url", "text", "search", "tel", "password", "date", "month", "week", "time", "color", "datetimelocal");
    private HTMLFormElement form;
    private boolean checkedAccessed;
    private boolean valueAccessed;
    private boolean checked;
    private boolean dirtyChechedness;
    private boolean argumentParsed = false;
    private String value;
    private IFileList _files = new lj();

    public HTMLInputElement(lu name, Document doc) {
        super(name, doc);
        l0t.lI((DOMObject)this).lf(l0t.lk, false);
        l0t.lI((DOMObject)this).lf(l0t.lv, false);
        if ((this.getOwnerDocument().getContext().getSecurity() & 0x80) != 128) {
            com.aspose.pdf.internal.l70f.lu lu2 = new com.aspose.pdf.internal.l70f.lu(false);
            ld ld2 = new ld();
            ld2.lf(true);
            lb lb2 = new lb(this.subscribeMutation(lu2), (lf)this.getOwnerDocument().getContext());
            lb2.lI(this, ld2);
        }
    }

    @DOMNameAttribute(name="defaultValue")
    public String getDefaultValue() {
        return this.getAttributeOrDefault("value", l10l.lI);
    }

    @DOMNameAttribute(name="defaultValue")
    public void setDefaultValue(String value) {
        this.initValueAttribute();
        this.setAttribute("value", value);
    }

    @DOMNameAttribute(name="defaultChecked")
    public boolean getDefaultChecked() {
        return this.hasAttribute("checked");
    }

    @DOMNameAttribute(name="defaultChecked")
    public void setDefaultChecked(boolean value) {
        this.initCheckedAttribute();
        this.toggleAttribute("checked", value);
    }

    @DOMNameAttribute(name="form")
    @DOMNullableAttribute
    public HTMLFormElement getForm() {
        if (this.form == null) {
            this.form = this.getParentOfType(HTMLFormElement.class);
        }
        return this.form;
    }

    @DOMNameAttribute(name="form")
    @DOMNullableAttribute
    public void setForm(HTMLFormElement value) {
        this.form = value;
    }

    @DOMNameAttribute(name="files")
    public IFileList getFiles() {
        return this._files;
    }

    @DOMNameAttribute(name="accept")
    public String getAccept() {
        return this.getAttributeOrDefault("accept", l10l.lI);
    }

    @DOMNameAttribute(name="accept")
    public void setAccept(String value) {
        this.setAttribute("accept", value);
    }

    @DOMNameAttribute(name="accessKey")
    public String getAccessKey() {
        return this.getAttributeOrDefault("accesskey", l10l.lI);
    }

    @DOMNameAttribute(name="accessKey")
    public void setAccessKey(String value) {
        this.setAttribute("accesskey", value);
    }

    @DOMNameAttribute(name="align")
    public String getAlign() {
        return this.getAttributeOrDefault("align", l10l.lI);
    }

    @DOMNameAttribute(name="align")
    public void setAlign(String value) {
        this.setAttribute("align", value);
    }

    @DOMNameAttribute(name="alt")
    public String getAlt() {
        return this.getAttributeOrDefault("alt", l10l.lI);
    }

    @DOMNameAttribute(name="alt")
    public void setAlt(String value) {
        this.setAttribute("alt", value);
    }

    @DOMNameAttribute(name="checked")
    public boolean getChecked() {
        this.initCheckedAttribute();
        return this.checked;
    }

    @DOMNameAttribute(name="checked")
    public void setChecked(boolean value) {
        l0t.lI((DOMObject)this).lf(l0t.lv, true);
        this.checked = value;
        this.checkedAccessed = true;
        if (this.checked) {
            this.switchOtherRadioButtonToFalse();
        }
    }

    @DOMNameAttribute(name="disabled")
    public boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    @DOMNameAttribute(name="disabled")
    public void setDisabled(boolean value) {
        this.toggleAttribute("disabled", value);
    }

    @DOMNameAttribute(name="maxLength")
    public int getMaxLength() {
        return this.getAttributeOrDefault("maxlength", (short)Short.MAX_VALUE);
    }

    @DOMNameAttribute(name="maxLength")
    public void setMaxLength(int value) {
        this.setAttribute("maxlength", value);
    }

    @DOMNameAttribute(name="name")
    public String getName() {
        return this.getAttributeOrDefault("name", l10l.lI);
    }

    @DOMNameAttribute(name="name")
    public void setName(String value) {
        this.setAttribute("name", value);
    }

    @DOMNameAttribute(name="readOnly")
    public boolean getReadOnly() {
        return this.hasAttribute("readonly");
    }

    @DOMNameAttribute(name="readOnly")
    public void setReadOnly_Rename_Namesake(boolean value) {
        this.toggleAttribute("readonly", value);
    }

    @DOMNameAttribute(name="size")
    public int getSize() {
        return this.getAttributeOrDefault("size", 20);
    }

    @DOMNameAttribute(name="size")
    public void setSize(int value) {
        this.setAttribute("size", value);
    }

    @DOMNameAttribute(name="src")
    public String getSrc() {
        return this.getAttributeOrDefault("src", l10l.lI);
    }

    @DOMNameAttribute(name="src")
    public void setSrc(String value) {
        this.setAttribute("src", value);
    }

    @DOMNameAttribute(name="tabIndex")
    public int getTabIndex() {
        return this.getAttributeOrDefault("tabindex", 0);
    }

    @DOMNameAttribute(name="tabIndex")
    public void setTabIndex(int value) {
        this.setAttribute("tabindex", value);
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.getAttributeOrDefault("type", "text");
    }

    @DOMNameAttribute(name="type")
    public void setType(String value) {
        this.setAttribute("type", value);
    }

    @DOMNameAttribute(name="useMap")
    public String getUseMap() {
        return this.getAttributeOrDefault("usemap", l10l.lI);
    }

    @DOMNameAttribute(name="useMap")
    public void setUseMap(String value) {
        this.setAttribute("usemap", value);
    }

    @DOMNameAttribute(name="value")
    public String getValue() {
        this.initValueAttribute();
        return this.value;
    }

    @DOMNameAttribute(name="value")
    public void setValue(String value) {
        this.value = value;
        this.valueAccessed = true;
        l0t.lI((DOMObject)this).lf(l0t.lk, true);
        this.sanitizeValue();
    }

    @DOMNameAttribute(name="blur")
    public void blur() {
    }

    @DOMNameAttribute(name="focus")
    public void focus() {
    }

    @DOMNameAttribute(name="select")
    public void select() {
    }

    @DOMNameAttribute(name="click")
    public void click() {
    }

    private void initCheckedAttribute() {
        if (this.checkedAccessed) {
            return;
        }
        this.checked = this.getDefaultChecked();
        this.checkedAccessed = true;
    }

    private lt subscribeMutation(final com.aspose.pdf.internal.l70f.lu autoResetEvent) {
        return new lt(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lI(com.aspose.pdf.internal.ms.System.Collections.Generic.l0t<com.aspose.pdf.internal.l37f.lj> l0t2, lI lI2) {
                lk lk2 = l0t2.iterator();
                try {
                    while (lk2.hasNext()) {
                        com.aspose.pdf.internal.l37f.lj lj2 = (com.aspose.pdf.internal.l37f.lj)lk2.next();
                        if (!"attributes".equals(lj2.lI())) continue;
                        switch (gStringSwitchMap.lI(lj2.lu())) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                if (!l0t.lI((DOMObject)HTMLInputElement.this).lf(l0t.lv) && HTMLInputElement.this.hasAttribute("checked")) {
                                    HTMLInputElement.this.checked = true;
                                    HTMLInputElement.this.switchOtherRadioButtonToFalse();
                                }
                                if (l0t.lI((DOMObject)HTMLInputElement.this).lf(l0t.lv) || HTMLInputElement.this.hasAttribute("checked")) break;
                                HTMLInputElement.this.checked = false;
                                break;
                            }
                            case 2: 
                            case 3: {
                                l0t.lI((DOMObject)HTMLInputElement.this).lf(l0t.lk, true);
                                HTMLInputElement.this.sanitizeValue();
                                break;
                            }
                            case 4: {
                                HTMLInputElement.this.checked = HTMLInputElement.this.hasAttribute("checked");
                            }
                        }
                    }
                }
                finally {
                    if (com.aspose.pdf.internal.l82h.lb.lf((Object)lk2, l5f.class)) {
                        ((l5f)lk2).dispose();
                    }
                }
                autoResetEvent.lj();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchOtherRadioButtonToFalse() {
        if (this.getForm() == null) {
            return;
        }
        com.aspose.pdf.internal.l67h.l0t l0t2 = this.getForm().getElements().iterator();
        try {
            while (l0t2.hasNext()) {
                HTMLInputElement hTMLInputElement;
                Element element = (Element)l0t2.next();
                if (!element.getTagName().equals("INPUT") || !"radio".equals((hTMLInputElement = (HTMLInputElement)element).getType()) || hTMLInputElement.getName() == null || !l10l.lb(l10l.ld(hTMLInputElement.getName()), l10l.ld(this.getName())) || this.equals(hTMLInputElement)) continue;
                hTMLInputElement.setChecked(false);
            }
        }
        finally {
            if (com.aspose.pdf.internal.l82h.lb.lf((Object)l0t2, l5f.class)) {
                ((l5f)((Object)l0t2)).dispose();
            }
        }
    }

    private void initValueAttribute() {
        if (this.valueAccessed) {
            return;
        }
        this.value = this.getDefaultValue();
        this.valueAccessed = true;
    }

    private void sanitizeValue() {
        switch (gStringSwitchMap.lI(this.getType())) {
            case 5: {
                if (this.hasAttribute("multiple")) {
                    String[] stringArray = l10l.lI(this.getValue(), new String[]{","}, 1);
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = l10l.lj(stringArray[i]);
                    }
                    this.value = l10l.lI(",", stringArray);
                    break;
                }
                this.value = l10l.lj(l10l.lI(l10l.lI(this.getValue(), "\r", l10l.lI), "\n", l10l.lI));
                break;
            }
            case 6: {
                this.value = l10l.lj(l10l.lI(l10l.lI(this.getValue(), "\r", l10l.lI), "\n", l10l.lI));
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.value = l10l.lI(l10l.lI(this.getValue(), "\r", l10l.lI), "\n", l10l.lI);
                break;
            }
            case 11: {
                if (this.checkValidDate(this.getValue())) break;
                this.value = l10l.lI;
                break;
            }
            case 12: {
                if (this.checkValidMonth(this.getValue())) break;
                this.value = l10l.lI;
                break;
            }
            case 13: {
                if (this.checkValidWeek(this.getValue())) break;
                this.value = l10l.lI;
                break;
            }
            case 14: {
                if (this.checkValidTime(this.getValue())) break;
                this.value = l10l.lI;
                break;
            }
            case 15: {
                if (!this.checkValidColor(this.getValue())) {
                    this.value = "#000000";
                    break;
                }
                this.value = l10l.lu(this.getValue());
                break;
            }
            case 16: {
                this.value = !this.checkValidDateTimeLocal(this.value) ? l10l.lI : this.getValue();
            }
        }
    }

    private boolean checkValidDateTimeLocal(String s) {
        String[] stringArray = l10l.lI(s, new char[]{'T'}, (short)1);
        return this.checkValidDate(stringArray[0]) || this.checkValidTime(stringArray[1]);
    }

    private boolean checkValidColor(String s) {
        if (s.length() != 7) {
            return false;
        }
        if (s.charAt(0) != '#') {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            if (lh.lI(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkValidTime(String s) {
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        float[] fArray = new float[]{0.0f};
        boolean bl = this.tryParseTime(s, nArray, nArray2, fArray);
        n = nArray[0];
        n2 = nArray2[0];
        f = fArray[0];
        return bl;
    }

    private boolean tryParseTime(String s, int[] hour, int[] minute, float[] second) {
        boolean bl = false;
        hour[0] = 0;
        int n = 0;
        minute[0] = 0;
        int n2 = 0;
        second[0] = 0.0f;
        int n3 = s.length();
        if (n3 < 5) {
            return false;
        }
        int[] nArray = new int[]{0};
        boolean bl2 = !l6u.lI(l10l.lf(s, 0, 2), nArray);
        n = nArray[0];
        if (bl2) {
            return false;
        }
        if (n < 0 || n > 23) {
            return false;
        }
        if (s.charAt(2) != ':') {
            return false;
        }
        int[] nArray2 = new int[]{0};
        boolean bl3 = !l6u.lI(l10l.lf(s, 3, 2), nArray2);
        n2 = nArray2[0];
        if (bl3) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        if (n3 == 5) {
            bl = true;
            hour[0] = n;
            minute[0] = n2;
        }
        if (!bl && s.charAt(5) != ':') {
            return false;
        }
        int n4 = 0;
        int[] nArray3 = new int[]{0};
        boolean bl4 = !bl && !l6u.lI(l10l.lf(s, 6, 2), nArray3);
        n4 = nArray3[0];
        if (bl4) {
            return false;
        }
        if (!(bl || n4 >= 0 && n4 <= 59)) {
            return false;
        }
        if (!bl && n3 == 8) {
            second[0] = n4;
            bl = true;
        }
        if (!bl && s.charAt(8) != '.') {
            return false;
        }
        int n5 = 0;
        int[] nArray4 = new int[]{0};
        boolean bl5 = !bl && !l6u.lI(l10l.lb(s, 9), nArray4);
        n5 = nArray4[0];
        if (bl5) {
            return false;
        }
        if (!bl && n3 > 12) {
            return false;
        }
        return l9n.lI(l10l.lI(new String[]{l6u.lf(n4), ".", l6u.lf(n5)}), 167, com.aspose.pdf.internal.l68h.lh.lt(), second);
    }

    private boolean checkValidDate(String s) {
        l3t l3t2 = new l3t();
        l3t[] l3tArray = new l3t[]{l3t2};
        boolean bl = l3t.lI(s, l3tArray);
        l3tArray[0].ld(l3t2);
        if (bl) {
            return true;
        }
        if (s.length() != 10) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean bl2 = !this.checkValidMonth(l10l.lf(s, 0, 7), nArray, nArray2);
        n = nArray[0];
        n2 = nArray2[0];
        if (bl2) {
            return false;
        }
        if (s.charAt(7) != '-') {
            return false;
        }
        int n3 = 0;
        int[] nArray3 = new int[]{0};
        boolean bl3 = !l6u.lI(l10l.lf(s, 8, 2), nArray3);
        n3 = nArray3[0];
        if (bl3) {
            return false;
        }
        return n3 > 0 && n3 <= l3t.lI(n, n2);
    }

    private boolean checkValidWeek(String s) {
        if (s.length() != 8) {
            return false;
        }
        int n = 0;
        int[] nArray = new int[]{0};
        boolean bl = !l6u.lI(l10l.lf(s, 0, 4), nArray);
        n = nArray[0];
        if (bl) {
            return false;
        }
        if (n <= 0 && n > 9999) {
            return false;
        }
        if (s.charAt(4) != '-') {
            return false;
        }
        if (s.charAt(5) != 'W') {
            return false;
        }
        int n2 = 0;
        int[] nArray2 = new int[]{0};
        boolean bl2 = !l6u.lI(l10l.lf(s, 6, 2), nArray2);
        n2 = nArray2[0];
        if (bl2) {
            return false;
        }
        int n3 = this.getWeeksInYear(n);
        return n2 >= 1 && n2 <= n3;
    }

    private int getWeeksInYear(int year) {
        lv lv2 = lv.l0f();
        l3t l3t2 = new l3t(year, 12, 31);
        l2p l2p2 = lv2.l1t();
        return l2p2.lI(l3t2.l1y(), lv2.l1v(), lv2.l1l());
    }

    private boolean checkValidMonth(String s) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean bl = this.checkValidMonth(s, nArray, nArray2);
        n = nArray[0];
        n2 = nArray2[0];
        return bl;
    }

    private boolean checkValidMonth(String s, int[] year, int[] month) {
        year[0] = 0;
        month[0] = 0;
        if (s.length() != 7) {
            return false;
        }
        if (!l6u.lI(l10l.lf(s, 0, 4), year)) {
            return false;
        }
        if (year[0] <= 0 && year[0] > 9999) {
            return false;
        }
        if (s.charAt(4) != '-') {
            return false;
        }
        if (!l6u.lI(l10l.lf(s, 5, 2), month)) {
            return false;
        }
        return month[0] >= 1 && month[0] <= 12;
    }
}

