/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.dom.svg;

import com.aspose.pdf.internal.html.dom.DOMObject;
import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.Node;
import com.aspose.pdf.internal.html.dom.attributes.DOMNameAttribute;
import com.aspose.pdf.internal.html.dom.attributes.DOMObjectAttribute;
import com.aspose.pdf.internal.html.dom.lI;
import com.aspose.pdf.internal.html.dom.lu;
import com.aspose.pdf.internal.html.dom.svg.ISVGTests;
import com.aspose.pdf.internal.html.dom.svg.SVGElement;
import com.aspose.pdf.internal.html.dom.svg.SVGForeignObjectElement;
import com.aspose.pdf.internal.html.dom.svg.SVGGeometryElement;
import com.aspose.pdf.internal.html.dom.svg.SVGImageElement;
import com.aspose.pdf.internal.html.dom.svg.SVGSVGElement;
import com.aspose.pdf.internal.html.dom.svg.SVGUseElement;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGAnimatedTransformList;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGLength;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGPreserveAspectRatio;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGRect;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGStringList;
import com.aspose.pdf.internal.html.dom.svg.datatypes.SVGTransform;
import com.aspose.pdf.internal.html.dom.svg.lt;
import com.aspose.pdf.internal.l32y.l0t;
import com.aspose.pdf.internal.l32y.l0u;
import com.aspose.pdf.internal.l33n.lf;
import com.aspose.pdf.internal.l82h.lb;
import com.aspose.pdf.internal.ms.System.l5f;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGGraphicsElement")
public class SVGGraphicsElement
extends SVGElement
implements ISVGTests {
    private final l0t transform = new l0t((SVGElement)this, "transform", 1);
    private final l0u requiredFeatures = new l0u(this, "requiredFeatures");
    private final l0u requiredExtensions = new l0u(this, "requiredExtensions");
    private final l0u systemLanguage = new l0u((SVGElement)this, "systemLanguage", 1);

    public SVGGraphicsElement(lu name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="nearestViewportElement")
    public SVGElement getNearestViewportElement() {
        return this.getViewportElement();
    }

    @DOMNameAttribute(name="farthestViewportElement")
    public SVGElement getFarthestViewportElement() {
        Element element = null;
        for (Element element2 = this.getParentElement(); element2 != null; element2 = element2.getParentElement()) {
            if (!"svg".equals(element2.getTagName())) continue;
            element = element2;
        }
        return (SVGElement)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="getBBox")
    public SVGRect getBBox() {
        if (lt.lf(this).lf(lt.lt) || lt.lf(this).lf(lt.lb) || "a".equals(this.getTagName()) && lt.lf(this.getParentNode()).lf(lt.lb)) {
            SVGGeometryElement sVGGeometryElement = (SVGGeometryElement)((Object)lb.lI(this, SVGGeometryElement.class));
            if (sVGGeometryElement == null) {
                return new SVGRect();
            }
            lf lf2 = new lf();
            lf2.lb(sVGGeometryElement.equivalentPath());
            return new SVGRect(lf2.lf().lv(), lf2.lf().lc(), lf2.lf().lk(), lf2.lf().lj());
        }
        if (lt.lf(this).lf(lt.ld) || "use".equals(this.getTagName())) {
            SVGGraphicsElement sVGGraphicsElement;
            SVGRect sVGRect = null;
            SVGElement sVGElement = sVGGraphicsElement = lt.lf(this).lf(lt.ld) ? this : ((SVGUseElement)this).getAnimatedInstanceRoot();
            if (lt.lf(sVGGraphicsElement).lf(lt.ld)) {
                DOMObject dOMObject;
                Node node;
                com.aspose.pdf.internal.l67h.l0t l0t2 = sVGGraphicsElement.getChildNodes().iterator();
                try {
                    while (l0t2.hasNext()) {
                        node = (Node)l0t2.next();
                        if (lt.lf(node).lf(lt.ld)) {
                            sVGRect = com.aspose.pdf.internal.l35if.lt.lI(sVGRect, ((SVGGraphicsElement)node).getBBox());
                            continue;
                        }
                        if (!lt.lf(node).lf(lt.lu) || !((SVGElement)(dOMObject = (SVGGraphicsElement)node)).isRendered()) continue;
                        sVGRect = com.aspose.pdf.internal.l35if.lt.lI(sVGRect, ((SVGGraphicsElement)node).getBBox());
                    }
                }
                finally {
                    if (lb.lf((Object)l0t2, l5f.class)) {
                        ((l5f)((Object)l0t2)).dispose();
                    }
                }
                if (sVGGraphicsElement.hasAttribute("transform") && sVGRect != null) {
                    node = (SVGGraphicsElement)((Object)lb.lI(sVGGraphicsElement.getParentElement(), SVGGraphicsElement.class));
                    dOMObject = node != null ? ((SVGGraphicsElement)node).getCTM() : null;
                    SVGMatrix sVGMatrix = sVGGraphicsElement.getCTM();
                    sVGRect.setX(sVGRect.getX() + (sVGMatrix.getE() - (dOMObject != null ? ((SVGMatrix)dOMObject).getE() : 0.0f)));
                    sVGRect.setY(sVGRect.getY() + (sVGMatrix.getF() - (dOMObject != null ? ((SVGMatrix)dOMObject).getF() : 0.0f)));
                }
            } else {
                sVGRect = sVGGraphicsElement.getBBox();
                sVGRect.setX(sVGRect.getX() + ((SVGLength)((SVGUseElement)this).getX().getAnimVal()).getValue());
                sVGRect.setY(sVGRect.getY() + ((SVGLength)((SVGUseElement)this).getY().getAnimVal()).getValue());
            }
            return sVGRect;
        }
        if ("foreignObject".equals(this.getTagName())) {
            SVGForeignObjectElement sVGForeignObjectElement = (SVGForeignObjectElement)this;
            return new SVGRect(((SVGLength)sVGForeignObjectElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getHeight().getAnimVal()).getValue());
        }
        if ("image".equals(this.getTagName())) {
            SVGImageElement sVGImageElement = (SVGImageElement)this;
            return new SVGRect(((SVGLength)sVGImageElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getHeight().getAnimVal()).getValue());
        }
        return new SVGRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @DOMNameAttribute(name="getCTM")
    public SVGMatrix getCTM() {
        SVGMatrix sVGMatrix;
        if (this.getOwnerDocument() == null) {
            return null;
        }
        if (lI.le.l8n.lf(this) && this.getOwnerSVGElement() == null) {
            return this.rootSVGTransform();
        }
        Element element = this.getParentElement();
        while (!lb.lf((Object)element, SVGGraphicsElement.class)) {
            element = element.getParentElement();
        }
        SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
        if (lI.le.l8n.lf(sVGGraphicsElement)) {
            sVGMatrix = new SVGMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            for (SVGTransform sVGTransform : (Iterable)sVGGraphicsElement.getTransform().getAnimVal()) {
                sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            }
        } else {
            sVGMatrix = sVGGraphicsElement.getCTM();
        }
        for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
        }
        return sVGMatrix;
    }

    @DOMNameAttribute(name="getScreenCTM")
    public SVGMatrix getScreenCTM() {
        SVGMatrix sVGMatrix;
        if (this.getOwnerDocument() == null) {
            return null;
        }
        if (lI.le.l8n.lf(this) && this.getOwnerSVGElement() == null) {
            sVGMatrix = this.rootSVGTransform();
        } else {
            Element element = this.getParentElement();
            while (!lb.lf((Object)element, SVGGraphicsElement.class)) {
                element = element.getParentElement();
            }
            SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
            sVGMatrix = sVGGraphicsElement.getScreenCTM();
            for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
                sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            }
        }
        return sVGMatrix;
    }

    private SVGMatrix rootSVGTransform() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this;
        SVGMatrix sVGMatrix = new SVGMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
        }
        sVGMatrix = sVGMatrix.translate(sVGSVGElement.getCurrentTranslate().getX(), sVGSVGElement.getCurrentTranslate().getY());
        sVGMatrix = sVGMatrix.scale(sVGSVGElement.getCurrentScale());
        if (this.hasAttribute("viewBox")) {
            SVGRect sVGRect = new SVGRect(((SVGLength)sVGSVGElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGSVGElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGSVGElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGSVGElement.getHeight().getAnimVal()).getValue());
            sVGMatrix = sVGMatrix.multiply(com.aspose.pdf.internal.l35if.lt.lI((SVGRect)sVGSVGElement.getViewBox().getAnimVal(), sVGRect, (SVGPreserveAspectRatio)sVGSVGElement.getPreserveAspectRatio().getAnimVal()));
        }
        return sVGMatrix;
    }

    @DOMNameAttribute(name="transform")
    public SVGAnimatedTransformList getTransform() {
        return (SVGAnimatedTransformList)this.transform.lv();
    }

    @Override
    public SVGStringList getRequiredFeatures() {
        return (SVGStringList)this.requiredFeatures.lv();
    }

    @Override
    public SVGStringList getRequiredExtensions() {
        return (SVGStringList)this.requiredExtensions.lv();
    }

    @Override
    public SVGStringList getSystemLanguage() {
        return (SVGStringList)this.systemLanguage.lv();
    }
}

