/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.html.rendering.xps;

import com.aspose.pdf.internal.html.dom.Document;
import com.aspose.pdf.internal.html.dom.Element;
import com.aspose.pdf.internal.html.dom.lI;
import com.aspose.pdf.internal.html.io.ICreateStreamProvider;
import com.aspose.pdf.internal.html.l0v;
import com.aspose.pdf.internal.html.rendering.Device;
import com.aspose.pdf.internal.html.rendering.GraphicContext;
import com.aspose.pdf.internal.html.rendering.xps.XpsRenderingOptions;
import com.aspose.pdf.internal.html.rendering.xps.l0t;
import com.aspose.pdf.internal.html.rendering.xps.lu;
import com.aspose.pdf.internal.l27n.l0y;
import com.aspose.pdf.internal.l27u.lb;
import com.aspose.pdf.internal.l68l.l13h;
import com.aspose.pdf.internal.l68l.l14p;
import com.aspose.pdf.internal.l68l.l2t;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.l10l;
import java.io.OutputStream;

public class XpsDevice
extends Device<lI, XpsRenderingOptions> {
    private lb _package;
    private lu _docWriter;
    private l0t _pathBuider;

    public XpsDevice(ICreateStreamProvider streamProvider) {
        this(new XpsRenderingOptions(), streamProvider);
    }

    public XpsDevice(XpsRenderingOptions options, ICreateStreamProvider streamProvider) {
        super(options, streamProvider, lI.class);
    }

    public XpsDevice(String file) {
        this(new XpsRenderingOptions(), file);
    }

    public XpsDevice(XpsRenderingOptions options, String file) {
        super(options, file, lI.class);
    }

    public XpsDevice(Stream stream) {
        this(new XpsRenderingOptions(), stream);
    }

    public XpsDevice(OutputStream outputStream) {
        this(new XpsRenderingOptions(), outputStream);
    }

    public XpsDevice(XpsRenderingOptions options, OutputStream outputStream) {
        super(options, outputStream, lI.class);
    }

    public XpsDevice(XpsRenderingOptions options, Stream stream) {
        super(options, stream, lI.class);
    }

    @Override
    public void restoreGraphicContext() {
        while (((lI)this.getGraphicContext()).lI() != 0) {
            this._docWriter.lj().lf();
            ((lI)this.getGraphicContext()).lI(((lI)this.getGraphicContext()).lI() - 1);
        }
        super.restoreGraphicContext();
    }

    @Override
    public void lineTo(l2t pt) {
        this._pathBuider.lf(pt.lt());
    }

    @Override
    public void moveTo(l2t pt) {
        this._pathBuider.lI(pt.lt());
    }

    @Override
    public void cubicBezierTo(l2t pt1, l2t pt2, l2t pt3) {
        this._pathBuider.lI(pt1.lt(), pt2.lt(), pt3.lt());
    }

    @Override
    public void addRect(l13h rect) {
        this._pathBuider.lI(rect.ly());
    }

    @Override
    public void closePath() {
        this._pathBuider.lI();
    }

    @Override
    public void clip(int mode) {
        String string = this._pathBuider.lj();
        this._docWriter.lj().lI(string, (GraphicContext)this.getGraphicContext(), mode);
        this._pathBuider.lf();
        ((lI)this.getGraphicContext()).lI(((lI)this.getGraphicContext()).lI() + 1);
    }

    @Override
    public void fill(int mode) {
        String string = this._pathBuider.lj();
        this._docWriter.lj().lf(mode == 1 ? l10l.lI(new String[]{"F 1 ", string}) : string, (GraphicContext)this.getGraphicContext(), 2);
        this._pathBuider.lf();
    }

    @Override
    public void strokeAndFill(int mode) {
        String string = this._pathBuider.lj();
        this._docWriter.lj().lf(mode == 1 ? l10l.lI(new String[]{"F 1 ", string}) : string, (GraphicContext)this.getGraphicContext(), 3);
        this._pathBuider.lf();
    }

    @Override
    public void stroke() {
        this._docWriter.lj().lf(this._pathBuider.lj(), (GraphicContext)this.getGraphicContext(), 1);
        this._pathBuider.lf();
    }

    @Override
    public void fillText(String text, l2t pt) {
        this._docWriter.lj().lI(text, pt.lt(), (GraphicContext)this.getGraphicContext(), false);
    }

    @Override
    public void strokeText(String text, l2t pt) {
    }

    @Override
    public void beginDocument(Document document, Class<? extends GraphicContext> clazz) {
        super.beginDocument(document, lI.class);
        this._package = new lb();
        this._docWriter = new lu(this._package);
        this._docWriter.lI((XpsRenderingOptions)this.getOptions_Rename_Namesake());
        this._pathBuider = new l0t();
    }

    @Override
    public boolean beginElement(Element element, l13h rect) {
        l0v l0v2 = l0v.lI(element.getTagName());
        if (l0v2.lf(lI.le.l1k)) {
            this.startRenderHyperlink(element, rect.ly());
        }
        return true;
    }

    @Override
    public void beginPage(l14p size) {
        super.beginPage(size.ld());
        this._docWriter.lI(size.lf(), size.lj());
        this._docWriter.lI(size.ld());
    }

    @Override
    public void endPage() {
        this._docWriter.lf();
        super.endPage();
    }

    @Override
    public void endDocument() {
        if (null == this._docWriter) {
            return;
        }
        this._docWriter.lI();
        this._package.lI(this.getOutputStream());
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
        l0v l0v2 = l0v.lI(element.getTagName());
        if (l0v2.lf(lI.le.l1k)) {
            this.stopRenderHyperlink(element);
        }
    }

    @Override
    public void drawImage(byte[] data, int type, l13h rect) {
        this._docWriter.lj().lI(data, type, rect.ly(), (GraphicContext)this.getGraphicContext());
    }

    private void startRenderHyperlink(Element element, l13h rect) {
        if (element.hasAttribute("href")) {
            String string = element.getAttribute("href");
            this._docWriter.lj().lI(new l0y(rect.ly(), string));
        }
    }

    private void stopRenderHyperlink(Element element) {
        if (element.hasAttribute("href")) {
            this._docWriter.lj().lt();
        }
    }

    @Override
    protected String getExtension() {
        return ".xps";
    }

    @Override
    public Class<? extends GraphicContext> getGraphicContextClass() {
        return lI.class;
    }

    public static class lI
    extends GraphicContext {
        private int lI;

        public int lI() {
            return this.lI;
        }

        public void lI(int n) {
            this.lI = n;
        }

        @Override
        public GraphicContext deepClone() {
            lI lI2 = (lI)super.deepClone();
            lI2.lI(0);
            return lI2;
        }
    }
}

